

#import "VankeServiceSaleCell_iPhone.h"

#pragma mark -

@implementation VankeServiceSaleCell_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

@synthesize theme = _theme;

DEF_OUTLET( BeeUIImageView, imgLeftBg );
DEF_OUTLET( BeeUIImageView, imgRightBg );
DEF_OUTLET( BeeUIImageView, imgLeftIcon );
DEF_OUTLET( BeeUIImageView, imgAmountIcon );
DEF_OUTLET( BeeUILabel, lblAmount );
DEF_OUTLET( BeeUILabel, lblAmountUnit );
DEF_OUTLET( BeeUIButton, btnHistoryMask );
DEF_OUTLET( BeeUILabel, lblDate );
DEF_OUTLET( BeeUILabel, lblTitle );

- (void)load
{
    self.data = [[NSNumber alloc] initWithInt:0];
}

- (void)unload
{
}

- (void)dataDidChanged {
    int oldAmount = [self.lblAmount.data intValue];
    int newAmount = 0;
    if (nil != self.data) {
        newAmount = [self.data intValue];
    }
    
    if (newAmount >= oldAmount) {
        $(self.imgAmountIcon).REMOVE_CLASS(@"down");
        $(self.imgAmountIcon).ADD_CLASS(@"up");
    } else {
        $(self.imgAmountIcon).REMOVE_CLASS(@"up");
        $(self.imgAmountIcon).ADD_CLASS(@"down");
    }
    
    $(self.lblAmount).DATA([NSString stringWithFormat:@"%d",newAmount]);
}

- (void) setTheme: (NSString*) theme {
    _theme = theme;
    $(self.imgLeftIcon).ADD_CLASS( theme );
    $(self.imgRightBg).ADD_CLASS( theme );
}

@end
