//
//  AnnouncementDetailTableViewCell.m
//  RealEstateManagement
//
//  Created by Javen on 16/9/5.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "AnnouncementDetailTableViewCell.h"
#import "IBTWebViewController.h"
static CGFloat const kBorderRadious = 8;    //圆角的弧度
static CGFloat const kBorderLineWidth = 1;  //虚线的宽度
static CGFloat const kBorderLineHeight = 2; //虚线的每个点的高度
@implementation AnnouncementDetailTableViewCell

- (void)awakeFromNib {
    // Initialization code
    self.selectionStyle = UITableViewCellSelectionStyleNone;
    [self.borderView setLineColorTop:[UIColor grayColor] left:[UIColor grayColor] bottom:[UIColor grayColor] right:[UIColor grayColor]];//设置不同的颜色
    [self.borderView setLineWidthTop:kBorderLineWidth left:kBorderLineWidth bottom:kBorderLineWidth right:kBorderLineWidth];
    [self.borderView setLineDashRight:kBorderLineHeight];//右侧线条是虚线
    [self.borderView setLineDashLeft:kBorderLineHeight];
    [self.borderView setLineDashTop:kBorderLineHeight];
    [self.borderView setLineDashBottom:kBorderLineHeight];
}

- (IBAction)open:(id)sender {
    self.openFile();
}

- (void)setContentText:(NSString *)contentText {
    if (![_contentText isEqualToString:contentText]) {
        _contentText = contentText;
    }
    NSMutableAttributedString *content = [[NSMutableAttributedString alloc]initWithString:contentText];
    NSRange contentRange = {0,[content length]};
    [content addAttribute:NSUnderlineStyleAttributeName value:[NSNumber numberWithInteger:NSUnderlineStyleSingle] range:contentRange];
    self.content.attributedText = content;
}

- (void)setType:(announcementDetailCellType)type {
    _type = type;
    switch (type) {
        case announcementDetailCellTypeTop: {
            [self.borderView setNeedLineTop:YES left:YES bottom:NO right:YES];
            [self.borderView setRadiusTopLeft:kBorderRadious topRight:kBorderRadious bottomLeft:0 bottomRight:0];
            self.line.hidden = NO;
            break;
        }
        case announcementDetailCellTypeCenter: {
            [self.borderView setNeedLineTop:NO left:YES bottom:NO right:YES];
            [self.borderView setRadiusTopLeft:0 topRight:0 bottomLeft:0 bottomRight:0];
            self.line.hidden = NO;
            break;
        }
        case announcementDetailCellTypeBottom: {
            [self.borderView setNeedLineTop:NO left:YES bottom:YES right:YES];
            [self.borderView setRadiusTopLeft:0 topRight:0 bottomLeft:kBorderRadious bottomRight:kBorderRadious];
            self.line.hidden = YES;
            break;
        }
    }
}

- (void)setIsOnlyOne:(BOOL)isOnlyOne {
    if (isOnlyOne) {
        [self.borderView setNeedLineTop:YES left:YES bottom:YES right:YES];
        [self.borderView setRadiusTopLeft:kBorderRadious topRight:kBorderRadious bottomLeft:kBorderRadious bottomRight:kBorderRadious];
        self.line.hidden = YES;
    }
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
