//
//  AnnouncementDetailViewController.m
//  RealEstateManagement
//
//  Created by Z on 16/7/4.
//  Copyright © 2016年 上海勾芒信息科技. All rights reserved.
//

#import "AnnouncementDetailViewController.h"
#import "ICRAnnouncementDetailHeadView.h"
#import "AnnouncementDetailTableViewCell.h"
#import "IBTWebViewController.h"
#import "VankeUtil.h"
#import "VankeAppBoard_iPhone.h"
@interface AnnouncementDetailViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (weak, nonatomic) IBOutlet UILabel *labelPublisher;
@property (weak, nonatomic) IBOutlet UILabel *labelTime;
@property (weak, nonatomic) IBOutlet UILabel *labelContent;
@property (weak, nonatomic) IBOutlet UITableView *tableView;
@property (nonatomic, strong) ICRAnnouncement *announcementDetail;


@end

@implementation AnnouncementDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.tableView.tableFooterView = [UIView new];
    self.title = @"公告详情";
//    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self setUpData];
    // Do any additional setup after loading the view.
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [[VankeAppBoard_iPhone sharedInstance] hideMenu];
}

- (void)setUpData {
    WS(weakSelf);
    NSString *url =  [NSString stringWithFormat:@"affiche/get/%@", self.announcement.uuid];
    
    [[ICRHTTPController sharedController] getUrl:url params:nil success:^(id data) {

        ICRAnnouncement *announcement = [ICRAnnouncement DBObject];
        [announcement praseFromJsonDict:data[@"data"]];
        announcement.readType = weakSelf.announcement.readType;
        weakSelf.announcementDetail = announcement;
        if ([weakSelf.announcementDetail.content hasPrefix:@"<p>"]) {
            NSRange lastRange = [weakSelf.announcementDetail.content rangeOfString:@"</p>"];
            NSString *cutString = [weakSelf.announcementDetail.content substringWithRange:NSMakeRange(3, lastRange.location - 3)];
            weakSelf.announcementDetail.content = cutString;
        }
        weakSelf.labelPublisher.text = weakSelf.announcementDetail.title;
        weakSelf.labelTime.text = weakSelf.announcementDetail.lastModify_time;
        weakSelf.labelContent.text = weakSelf.announcementDetail.content;
        [weakSelf httpAnnouncementRead];
        [weakSelf.tableView reloadData];
    } failure:^(id data) {
        
    }];
  
}

/** 上报已读的公告 */
- (void)httpAnnouncementRead{
    NSString *url = [NSString stringWithFormat:@"affiche/read/%@?user_uuid=%@&read_time=%@", self.announcementDetail.uuid,[VankeCommonModel sharedInstance].currentUser.uuid,[[NSDate date] httpParameterString]];
    NSString *URLString = [url stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
    [[ICRHTTPController sharedController] postUrl:URLString params:nil success:^(id data) {
            CLog(@"该公告已标记为已读");
    } failure:^(id data) {
        
    }];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.announcementDetail.attachmentUrls.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    AnnouncementDetailTableViewCell *cell;
    cell = [tableView dequeueReusableCellWithIdentifier:@"announcementTopCell" forIndexPath:indexPath];
    if (indexPath.row == 0) {
        cell.type = announcementDetailCellTypeTop;
        cell.isOnlyOne = self.announcementDetail.attachmentUrls.count == 1;
    }else if(indexPath.row == self.announcementDetail.attachmentUrls.count - 1) {
        cell.type = announcementDetailCellTypeBottom;
    }else{
        cell.type = announcementDetailCellTypeCenter;
    }
    cell.contentText = self.announcementDetail.attachmentUrls[indexPath.row][@"fileName"];
    
    NSString *url = IMAGE_URL(self.announcementDetail.attachmentUrls[indexPath.row][@"fileUrl"]);
    
    WS(weakSelf);
    cell.openFile = ^{
        IBTWebViewController *WVC = [[IBTWebViewController alloc] initWithURL:url presentModal:NO extraInfo:nil];
        WVC.title = @"附件详情";
        [weakSelf.navigationController pushViewController:WVC animated:YES];
    };
    return cell;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
