
//
//  VankeAppBoard_iPhone.m
//  vanke
//
//  Created by xiaomi on 15/10/11.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeAppBoard_iPhone.h"
#import "VankeUtil.h"
#import "VankeCommonModel.h"
#import "VankeMainBoard_iPhone.h"
#import "VankeLoginBoard_iPhone.h"
#import "VankeAffairsBoard_iPhone.h"
#import "VankeMainTabBoard_iPhone.h"
#import "ICRSystemViewController.h"
#import "VankeTenantTabBoard_iPhone.h"
#import "ICRModifyPwdViewController.h"
#import "ReportViewController.h"
#import "ReportBoardsViewController.h"
#import "VankeAffairsTenantBoard_iPhone.h"
#pragma mark -

@interface VankeAppBoard_iPhone ()
{
    BeeUIRouter *               _router;
    UIWindow *                  _login;
    
    BOOL isTenant;
    VankeMainTabBoard_iPhone*   _mainTabbar;
    VankeTenantTabBoard_iPhone* _tenantTabbar;
}
@end

@implementation VankeAppBoard_iPhone

DEF_SINGLETON( VankeAppBoard_iPhone )
DEF_NOTIFICATION( HIDE_MENU )

- (void)load
{
}

- (void)unload
{
}

#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    self.view.backgroundColor = [VankeUtil colorWithHexString:@"#fafafa"];
    [[UINavigationBar appearance] setTitleTextAttributes:@{NSForegroundColorAttributeName:[UIColor whiteColor]}];
    _router = [BeeUIRouter sharedInstance];
    _router.parentBoard = self;
    _router.view.alpha = 0.0f;
    [_router map:@"home" toClass:[VankeMainBoard_iPhone class]];
    [_router map:@"affairs" toClass:[VankeAffairsBoard_iPhone class]];
    [_router map:@"tenantAffairs" toClass:[VankeAffairsTenantBoard_iPhone class]];
    [_router map:@"me" toClass:[ICRSystemViewController class]];
    [_router map:@"report" toClass:[ReportBoardsViewController class]];
    [self.view addSubview:_router.view];
    
    [self createAndShowLoginWindow];
    [self observeNotification:VankeLoginBoard_iPhone.SUCC_LOGIN];
    [self observeNotification:ICRSystemViewController.SUCC_LOGOUT];
    [self observeNotification:ICRModifyPwdViewController.SUCC_LOGOUT];
    [self observeNotification:VankeAppBoard_iPhone.HIDE_MENU];
}

ON_DELETE_VIEWS( signal )
{
    _login = nil;
    [self unobserveAllNotifications];
}

ON_LAYOUT_VIEWS( signal )
{
    [self relayoutContentView];
}

ON_WILL_APPEAR( signal )
{
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
}

ON_DID_DISAPPEAR( signal )
{
}

- (void)showMenu
{
    [self postNotification:self.HIDE_MENU withObject: @"NO"];
}

- (void)hideMenu
{
    [self postNotification:self.HIDE_MENU withObject: @"YES"];
}

#pragma notification

#define HideLoginViewAnimationName @"LoginViewAnimation"

ON_NOTIFICATION3( VankeLoginBoard_iPhone, SUCC_LOGIN, notification )
{
    [UIView beginAnimations:HideLoginViewAnimationName context:nil];
    [UIView setAnimationDuration:0.5];
    [UIView setAnimationCurve: UIViewAnimationCurveEaseOut];
    [UIView setAnimationTransition:UIViewAnimationTransitionFlipFromLeft forView:self.view cache:YES];
    [UIView setAnimationDelegate:self];
    [UIView commitAnimations];
    
    isTenant = [[VankeCommonModel sharedInstance] curUserIsTenant];
    if (isTenant) {
        _tenantTabbar = [VankeTenantTabBoard_iPhone cell];
        [self.view addSubview:_tenantTabbar];
    } else {
        _mainTabbar = [VankeMainTabBoard_iPhone cell];
        [self.view addSubview:_mainTabbar];
    }
    [self relayoutContentView];
}

// 代理方法，检测动画介绍然后进行其他操作 还有其他两个方法
- (void)animationDidStop:(NSString *)animationId finished:(NSNumber *)finished context:(void *)context
{
    if ([animationId isEqualToString:HideLoginViewAnimationName]) {
        [_login removeFromSuperview];
        _login = nil;
    
        NSString *tabName = nil;
        if (isTenant) {
            tabName = [_tenantTabbar showAndSelectFirst];
        } else {
            tabName = [_mainTabbar showAndSelectFirst];
        }
    
        _router.view.alpha = 1.0f;
        [_router open:tabName animated:YES];
    }
}

ON_NOTIFICATION3( ICRSystemViewController, SUCC_LOGOUT, notification )
{
    [self doLogout];
}

ON_NOTIFICATION3( ICRModifyPwdViewController, SUCC_LOGOUT, notification )
{
    [self doLogout];
}

ON_NOTIFICATION3( VankeAppBoard_iPhone, HIDE_MENU, notification )
{
    NSString *userObj = notification.object;
    UIView *curTab = [self currentTab];
    curTab.hidden = [@"YES" eq:userObj];
    [self relayoutContentView];
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, home, signal )
{
    [_router open:@"home" animated:YES];
    [_mainTabbar selectHome];
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, affairs, signal )
{
    [_router open:@"affairs" animated:YES];
    [_mainTabbar selectAffairs];
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, report, signal )
{
    [_router open:@"report" animated:YES];
    [_mainTabbar selectReport];
}

ON_SIGNAL3( VankeMainTabBoard_iPhone, me, signal )
{
    [_router open:@"me" animated:YES];
    [_mainTabbar selectMe];
    
}

//商户用户
ON_SIGNAL3( VankeTenantTabBoard_iPhone, affairs, signal )
{
    [_router open:@"tenantAffairs" animated:YES];
    [_tenantTabbar selectAffairs];
}

ON_SIGNAL3( VankeTenantTabBoard_iPhone, me, signal )
{
    [_router open:@"me" animated:YES];
    [_tenantTabbar selectMe];
}

-(void) createAndShowLoginWindow {
    // 先检查登录
    _login = [[UIWindow alloc] initWithFrame:[UIScreen mainScreen].bounds];
    _login.rootViewController = [VankeLoginBoard_iPhone board];
    _login.windowLevel = UIWindowLevelStatusBar + 1;
    [_login makeKeyAndVisible];
}

/**
 *  重置router和菜单
 */
-(void) relayoutContentView {
    UIView *tab = [self currentTab];
    if (nil == tab) {
        return;
    }
    
    CGFloat menuHeight = 45.0f;
    
    CGRect frame1;
    frame1.size.width = self.viewSize.width;
    frame1.size.height = 45.0f;
    frame1.origin.x = 0.0;
    frame1.origin.y = self.view.bounds.size.height - menuHeight;
    tab.frame = frame1;
    
    CGRect frame2;
    frame2.size.width = self.viewSize.width;
    if (tab.hidden) {
        frame2.size.height = self.viewSize.height;
    } else {
        CGFloat statusBarHeight = [[UIApplication sharedApplication] statusBarFrame].size.height;
        frame2.size.height = self.viewSize.height - menuHeight - statusBarHeight + 20.0f;
    }
    frame2.origin.x = 0.0;
    frame2.origin.y = 0.0;
    _router.view.frame = frame2;
}

/**
 *  退出登录
 */
-(void) doLogout {
    [self createAndShowLoginWindow];
    _router.view.alpha = 0.0f;
    
    if (isTenant) {
        [_tenantTabbar removeFromSuperview];
        _tenantTabbar = nil;
    } else {
        [_mainTabbar removeFromSuperview];
        _mainTabbar = nil;
    }
}

-(UIView*) currentTab {
    if (isTenant) {
        return _tenantTabbar;
    } else {
        return _mainTabbar;
    }
}

@end