//
//  VankeAffairsTenantBoard_iPhone.m
//  vanke
//
//  Created by Javen on 16/8/24.
//  Copyright © 2016年 gomore. All rights reserved.
//

#import "VankeAffairsTenantBoard_iPhone.h"
#import "VankeUtil.h"
#import "GEToast.h"
#import "VankeCommonModel.h"
#import "VankeAppBoard_iPhone.h"
#import "VankeNoticeListBoard_iPhone.h"
#import "VankeStatementListBoard_iPhone.h"
#import "ICRAnnouncementViewController.h"
#import "SalesInputViewController.h"
#import "StatementViewController.h"
#import "ChooseProjectTableViewController.h"
#import "ICRAppMacro.h"
@interface VankeAffairsTenantBoard_iPhone ()
{
    //
    NSArray *authorizedOrgs;
}
@end

@implementation VankeAffairsTenantBoard_iPhone

SUPPORT_AUTOMATIC_LAYOUT( YES )
SUPPORT_RESOURCE_LOADING( YES )

DEF_OUTLET( BeeUIButton, btnNotice )
DEF_OUTLET( BeeUIButton, btnBill )
DEF_OUTLET( BeeUIButton, btnSaleInput )
DEF_OUTLET( BeeUIButton, btnServiceApply )
- (void)load
{
}

- (void)unload
{
}

#pragma mark - Signal

ON_CREATE_VIEWS( signal )
{
    self.navigationBarShown = YES;
    self.navigationBarTitle = @"业务";
}

ON_DELETE_VIEWS( signal )
{
}

ON_LAYOUT_VIEWS( signal )
{
}

ON_WILL_APPEAR( signal )
{
    self.navigationController.navigationBar.backgroundImage = [UIImage imageWithColor:[UIColor colorWithR:63 g:134 b:244 a:1]];
    UIColor *color = [VankeUtil rgbStringToColor: @"237,27,35"];
//    if ( IOS7_OR_LATER ) {
        self.navigationController.navigationBar.barTintColor = color;
    self.navigationController.navigationBar.tintColor = [UIColor whiteColor];

//    } else {
//        self.navigationController.navigationBar.tintColor = color;
//    }
    [[VankeAppBoard_iPhone sharedInstance] showMenu];
}

ON_DID_APPEAR( signal )
{
}

ON_WILL_DISAPPEAR( signal )
{
}

ON_DID_DISAPPEAR( signal )
{
}

ON_SIGNAL3(VankeAffairsTenantBoard_iPhone, btnNotice, signal) {
    [[VankeAppBoard_iPhone sharedInstance] hideMenu];
    VankeNoticeListBoard_iPhone *board = [VankeNoticeListBoard_iPhone board];
    //    ICRAnnouncementViewController *board = [ICRAnnouncementViewController board];
    [self.stack pushBoard:board animated:YES];
}

ON_SIGNAL3(VankeAffairsTenantBoard_iPhone, btnBill, signal) {
    VankeCommonModel *userModel = [VankeCommonModel sharedInstance];
    authorizedOrgs = [userModel getAuthOrgs];
    
    if (authorizedOrgs.count == 0) {
        return;
    }
    else if (authorizedOrgs.count == 1) {
        AuthorizedOrg *org = [authorizedOrgs objectAtIndex:0];
        //跳转对账单
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Statement" bundle:nil];
        StatementViewController *statementVC = [storyboard instantiateViewControllerWithIdentifier:@"StatementViewController"];
        statementVC.org = org;
        [self.navigationController pushViewController:statementVC animated:YES];
    }
    else {
        CGFloat xWidth = self.view.bounds.size.width - 20.0f;
        CGFloat yHeight = authorizedOrgs.count * 60 + 50;
        if (yHeight > 400) {
            yHeight = 400.0f;
        }
        CGFloat yOffset = (self.view.bounds.size.height - yHeight)/2.0f;
        UIPopoverListView *poplistview = [[UIPopoverListView alloc] initWithFrame:CGRectMake(10, yOffset, xWidth, yHeight)];
        poplistview.tag = 10000;
        poplistview.delegate = self;
        poplistview.datasource = self;
        poplistview.listView.scrollEnabled = YES;
        [poplistview setTitle:@"请选择查看项目"];
        [poplistview show];
    }
}

ON_SIGNAL3(VankeAffairsTenantBoard_iPhone, btnSaleInput, signal) {
    //    [GEToast showWithText:@"销售录入正在开发中..." bottomOffset:60.0f duration:1.0f];
    //    if ([[model getAuthOrgs] count] > 1) {
    //        ChooseProjectTableViewController *chooseVC = [[ChooseProjectTableViewController alloc] init];
    //        chooseVC.arrAuthorized = [model getAuthOrgs];
    //        chooseVC.chooseAuthorized = ^(AuthorizedOrg *author){
    //            salesVC.authorizedOrg = author;
    //            [weakSelf.navigationController pushViewController:salesVC animated:YES];
    //        };
    //        UINavigationController *navc = [[UINavigationController alloc] initWithRootViewController:chooseVC];
    //        [self.navigationController presentViewController:navc animated:YES completion:nil];
    //    }else{
    //        salesVC.authorizedOrg = [model getAuthOrgs][0];
    //        [self.navigationController pushViewController:salesVC animated:YES];
    //    }
    SalesInputViewController *salesVC = [[SalesInputViewController alloc] init];
    salesVC.type = SalesInputViewControllerTypeInput;
    VankeCommonModel *userModel = [VankeCommonModel sharedInstance];
    if ([[userModel getAuthOrgs] count] == 1) {
        salesVC.authorizedOrg = [userModel getAuthOrgs][0];
        [self.navigationController pushViewController:salesVC animated:YES];
    }else{
        
        authorizedOrgs = [userModel getAuthOrgs];
        CGFloat xWidth = self.view.bounds.size.width - 20.0f;
        CGFloat yHeight = authorizedOrgs.count * 60 + 50;
        if (yHeight > 400) {
            yHeight = 400.0f;
        }
        CGFloat yOffset = (self.view.bounds.size.height - yHeight)/2.0f;
        UIPopoverListView *poplistview = [[UIPopoverListView alloc] initWithFrame:CGRectMake(10, yOffset, xWidth, yHeight)];
        poplistview.tag = 10001;
        poplistview.delegate = self;
        poplistview.datasource = self;
        poplistview.listView.scrollEnabled = YES;
        [poplistview setTitle:@"请选择查看项目"];
        [poplistview show];
    }
    
}

ON_SIGNAL3(VankeAffairsTenantBoard_iPhone, btnServiceApply, signal) {
    [GEToast showWithText:@"服务申请正在开发中..." bottomOffset:60.0f duration:1.0f];
}

ON_SIGNAL3(VankeAffairsTenantBoard_iPhone, btnBillAudit, signal) {
//    [[VankeAppBoard_iPhone sharedInstance] hideMenu];
//    CLog(@"销售录入审核");
//    UIStoryboard *storyBoard = [UIStoryboard storyboardWithName:@"SalesInPut" bundle:nil];
//    SaleInputAuditViewController *auditVC = [storyBoard instantiateViewControllerWithIdentifier:@"SaleInputAuditViewController"];
//    [self.navigationController pushViewController:auditVC animated:YES];
    
}

#pragma mark - UIPopoverListViewDataSource

- (UITableViewCell *)popoverListView:(UIPopoverListView *)popoverListView
                    cellForIndexPath:(NSIndexPath *)indexPath
{
    static NSString *identifier = @"cell";
    UITableViewCell *cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault
                                                   reuseIdentifier:identifier];
    
    AuthorizedOrg *org = [authorizedOrgs objectAtIndex:indexPath.row];
    cell.textLabel.text = org.name;
    [cell.imageView sd_setImageWithURL:[NSURL URLWithString:org.picture] placeholderImage:[UIImage imageNamed:@"bill_no_image_default"]];
    return cell;
}

- (NSInteger)popoverListView:(UIPopoverListView *)popoverListView
       numberOfRowsInSection:(NSInteger)section
{
    return authorizedOrgs.count;
}

#pragma mark - UIPopoverListViewDelegate
- (void)popoverListView:(UIPopoverListView *)popoverListView
     didSelectIndexPath:(NSIndexPath *)indexPath
{
    if (popoverListView.tag == 10000) {
        
        //跳转对账单
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Statement" bundle:nil];
        StatementViewController *statementVC = [storyboard instantiateViewControllerWithIdentifier:@"StatementViewController"];
        AuthorizedOrg *org = [authorizedOrgs objectAtIndex:indexPath.row];
        statementVC.org = org;
        [self.navigationController pushViewController:statementVC animated:YES];
    }else{
        SalesInputViewController *salesVC = [[SalesInputViewController alloc] init];
        salesVC.authorizedOrg = [authorizedOrgs objectAtIndex:indexPath.row];
        [self.navigationController pushViewController:salesVC animated:YES];
        
    }
}

- (CGFloat)popoverListView:(UIPopoverListView *)popoverListView
   heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 60.0f;
}

-(void) showStatementList: (AuthorizedOrg*) org {
    if (nil == org) {
        ERROR(@"Authorized Org cannot be null.");
        return;
    }
    
    [[VankeAppBoard_iPhone sharedInstance] hideMenu];
    VankeStatementListBoard_iPhone *board = [VankeStatementListBoard_iPhone board];
    board.authorizedOrgUuidEquals = org.code;
    [self.stack pushBoard:board animated:YES];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
