//
//  GEToast.m
//  LifeBBS
//
//  Created by wangying on 14-3-29.
//  Copyright (c) 2014年 Game Elf. All rights reserved.
//

#import "GEToast.h"
#import "OMGToast.h"
#import "MBProgressHUD.h"

@implementation GEToast
static MBProgressHUD *HUD;
+ (void)showWithText:(NSString *) text_ {
    if (text_) {
        [OMGToast showWithText:text_];
    }
}

+ (void)showWithText:(NSString *) text_
            duration:(CGFloat)duration_ {
    [OMGToast showWithText:text_ duration:duration_];
}

+ (void)showWithText:(NSString *) text_
           topOffset:(CGFloat) topOffset_ {
    [OMGToast showWithText:text_ topOffset:topOffset_];
}

+ (void)showWithText:(NSString *) text_
           topOffset:(CGFloat) topOffset
            duration:(CGFloat) duration_ {
    [OMGToast showWithText:text_ topOffset:topOffset duration:duration_];
}

+ (void)showWithText:(NSString *) text_
        bottomOffset:(CGFloat) bottomOffset_ {
    [OMGToast showWithText:text_ bottomOffset:bottomOffset_];
}

+ (void)showWithText:(NSString *) text_
        bottomOffset:(CGFloat) bottomOffset_
            duration:(CGFloat) duration_ {
    [OMGToast showWithText:text_ bottomOffset: bottomOffset_ duration:duration_];
}

+(void)showProgressWithText:(NSString *)text view:(UIView *)view {
    [GEToast hideProgress];
    
    HUD = [[MBProgressHUD alloc] initWithView:view];
    HUD.mode = MBProgressHUDModeIndeterminate;
    [view addSubview:HUD];
    HUD.labelText = text;
    [HUD show:YES];
}

+(void)showProgress:(UIView *)view {
    [GEToast showProgressWithText:nil view:view];
}

+(void)hideProgress {
    if (HUD) {
        [HUD removeFromSuperview];
        HUD = nil;
    }
}


@end
