//
//  VankeVersionAPI.m
//  vanke
//
//  Created by xiaomi on 15/11/12.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeVersionAPI.h"

@implementation VankeVersionAPI

-(void) route:(BeeMessage *)msg {
    if (self.sending)
    {
        [self http_get:@"ipapk"].PARAM(@"type", @"ipa").TIMEOUT(10);
    }
    else if (self.succeed)
    {
        NSLog(@"response: %@", self.responseString);
        
        self.serverResp = [VersionResponse objectFromDictionary: self.responseJSONDictionary];
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    }
}

@end

#pragma VersionInfo

@implementation VersionInfo

@synthesize uuid;
@synthesize type;
@synthesize version;
@synthesize url;
@synthesize forceUpdate;

@end


#pragma VersionResponse

@implementation VersionResponse

@synthesize data;

-(VersionNumber*) newVersion {
    if (![self isOk]) {
        return nil;
    }
    
    VersionNumber *localVersion = [VankeUtil getCurrentVersion];
    VersionNumber *svrVersion = [VersionNumber initWithVersion:data.version];
    if ([svrVersion compareTo:localVersion] > 0) {
        return svrVersion;
    } else {
        return nil;
    }
}

-(BOOL) isForceUpdate {
    return nil != data && [@"1" eq: data.forceUpdate];
}

@end


