
//
//  VankeUserLoginAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/6.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeUserLoginAPI.h"
#import "VankeUtil.h"
#import "VankeShopModel.h"
#import "LoginShopsInstance.h"

#pragma mark VankeUserLoginAPI

@implementation VankeUserLoginAPI

@synthesize userName;
@synthesize password;
@synthesize authenticode;

-(void) route:(BeeMessage *)msg {
    if (self.sending) {
        if (![self checkToQuery]) {
            return;
        }
        
        NSString *url = [NSString stringWithFormat:@"/wanke/user/login/%@", self.userName];
        NSString *encryptPwd = [VankeUtil md5: self.password];
        NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:
                                  self.authenticode, @"authenticode",
                                  encryptPwd, @"password", nil];
        NSString *postData = [VankeUtil dictToJsonString: dict];
        [self http_post: url].BODY(postData).TIMEOUT(10);
    }
    else if (self.succeed) {
        NSLog(@"response: %@", self.responseString);
        NSDictionary *response = [self.responseString objectFromJSONString];
        for (NSDictionary *dic in response[@"data"][@"shops"]) {
            VankeShopModel *model = [VankeShopModel modelObjectWithDictionary:dic];
            [[LoginShopsInstance shareInstance].arrShops addObject:model];
        }
        LoginShopsInstance *shops = [LoginShopsInstance shareInstance];
        
        self.serverResp = [LoginResponse objectFromDictionary: self.responseJSONDictionary];
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    }
}

-(BOOL) checkToQuery {
    if ([VankeUtil isBlankString:self.userName]) {
        [self setClientError: @"用户名不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.password]) {
        [self setClientError: @"密码不能为空"];
        return NO;
    }

    return YES;
}

@end

#pragma mark UCN
@implementation UCN
@synthesize uuid;
@synthesize code;
@synthesize name;
@end

#pragma mark User
@implementation User
@synthesize uuid;
@synthesize code;
@synthesize name;
@end

#pragma mark Enterpirse
@implementation Enterpirse
@synthesize uuid;
@synthesize code;
@synthesize name;
@end

#pragma mark AuthorizedOrg
@implementation AuthorizedOrg
@synthesize uuid;
@synthesize code;
@synthesize name;
@synthesize picture;

-(NSString*) getPicture {
    if (![VankeUtil isBlankString:self.picture]) {
        return self.picture;
    } else {
        return @"bill_default_image.png";
    }
}


@end

#pragma mark LoginResponseData

NSString *const USER_POSITION_HQ = @"hq";         // 用户职位: 集团
NSString *const USER_POSITION_STORE = @"store";      // 用户职位: 商场用户
NSString *const USER_POSITION_TENANT = @"tenant";     // 用户职位: 商户用户

@implementation LoginResponseData
//@synthesize user;
//@synthesize enterprise;

@synthesize user_uuid;
@synthesize user_code;
@synthesize user_name;
@synthesize enterprise_uuid;
@synthesize enterprise_code;
@synthesize enterprise_name;
@synthesize authenticode;
@synthesize authorizedOrgs;
@synthesize position;
@synthesize tenant;

CONVERT_PROPERTY_CLASS(authorizedOrgs, AuthorizedOrg)

-(User*) getUser {
    if ([VankeUtil isBlankString:self.user_uuid]) {
        return nil;
    }
    
    User *user = [[User alloc]init];
    user.uuid = self.user_uuid;
    user.code = self.user_code;
    user.name = self.user_name;
    return user;
}

-(Enterpirse*) getEnterprise {
    if ([VankeUtil isBlankString:self.enterprise_uuid]) {
        return nil;
    }
    
    Enterpirse *ent = [[Enterpirse alloc]init];
    ent.uuid = self.enterprise_uuid;
    ent.code = self.enterprise_code;
    ent.name = self.enterprise_name;
    return ent;
}

@end

#pragma mark LoginResponse
@implementation LoginResponse
@synthesize data;
@end

