
//
//  VankeProjectSummaryAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/6.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeProjectSummaryAPI.h"
#import "VankeUtil.h"
#import "VankeUserLoginAPI.h"

#pragma mark VankeProjectSummaryAPI

@implementation VankeProjectSummaryAPI

@synthesize salesDate;
@synthesize passengerDate;
@synthesize trafficDate;
@synthesize rentalDateEquals;
@synthesize projectIdsIn;

-(void) route:(BeeMessage *)msg {
    if (self.sending)
    {
        if (![self checkToQuery]) {
            return;
        }
        
        NSDateFormatter *df = [[NSDateFormatter alloc] init];
        [df setDateFormat:@"yyyy-MM-dd"];
        NSDate *date = [df dateFromString:self.passengerDate];
        [df setDateFormat:@"yyyyMM"];
        NSString *yearMonth = [df stringFromDate:date];
    
        [self http_get:@"project/queryclassificationby"].PARAM(@"salesDateEquals", self.salesDate).PARAM(@"passengerDateEquals", self.passengerDate).PARAM(@"trafficDateEquals", self.trafficDate).PARAM(@"rentalDateEquals", self.rentalDateEquals).PARAM(@"projectIdsIn", self.projectIdsIn).PARAM(@"settleNoEquals",yearMonth).TIMEOUT(10);
    }
    else if (self.succeed)
    {
        NSLog(@"response: %@", self.responseString);
        
        self.serverResp = [ProjectSummaryResponse objectFromDictionary: self.responseJSONDictionary];
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    }
}

-(BOOL) checkToQuery {
    if ([VankeUtil isBlankString:self.salesDate]) {
        [self setClientError: @"销量日期不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.passengerDate]) {
        [self setClientError: @"客流量日期不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.trafficDate]) {
        [self setClientError: @"车流量日期不能为空"];
        return NO;
    }
    if ([VankeUtil isBlankString:self.rentalDateEquals]) {
        [self setClientError: @"租赁日期不能为空"];
        return NO;
    }
    
    return YES;
}

@end


#pragma mark ProjectSummary

@implementation ProjectSummary

@synthesize classificationName;
@synthesize passengerFlowVolume;
@synthesize trafficVolume;
@synthesize salesAmount;
@synthesize salesPerArea;
@synthesize wifiLoginTimes;

@end


#pragma mark ProjectSummaryResponse

@implementation ProjectSummaryResponse

@synthesize data;

CONVERT_PROPERTY_CLASS(data, ProjectSummary)

-(BOOL) hasClassification: (NSString*) classificationName {
    ProjectSummary *summary = [self getSummary:classificationName];
    return nil != summary;
}

-(ProjectSummary*) getSummary: (NSString*) classificationName {
    if (nil == self.data) {
        return nil;
    }
    
    for (int i = 0; i < [self.data count]; ++i) {
        ProjectSummary *summary = [self.data objectAtIndex:i];
        if ([summary.classificationName eq: classificationName]) {
            return summary;
        }
    }
    return nil;
}

@end

