//
//  IBTCommon.h
//  AceMTer
//
//  Created by Xummer on 2/27/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"

@interface IBTFileData : IBTObject
@property (strong, nonatomic) NSString *filePath;
@property (strong, nonatomic) NSString *fileName;
@property (strong, nonatomic) NSData *fileData;
@end

@interface IBTCommon : IBTObject

+ (NSString *)localizableString:(NSString *)text;
+ (UIImage *)localizableImage:(NSString *)name;

+ (UIImage *)appIcon;

+ (void)runOnMainThreadWithoutDeadlocking:(void (^)(void))block;

+ (BOOL)isLegalString:(NSString *)string WithRegex:(NSString *)regexStr;

// File Path
+ (NSString *)archivePathForCurrentUser;

+ (NSString *)archivePathForTmpImages;

+ (NSString *)archivePathForTmpAnnouncementAttachment;

+ (NSString *)saveAnnouncementAttachment:(NSData *)data name:(NSString *)name;

+ (IBTFileData *)saveImageToLocal:(UIImage *)imageToSave;


+ (NSDate *)convertToDateFrom:(NSString *)dateString;
+ (NSString *)stringFromDate:(NSDate*)aDate;
+ (NSString *)stringFromDateWithFormat:(NSDate*)aDate format:(NSString *)format;
+ (NSDate *)dateFromStringWithFormat:(NSString*)aStr format:(NSString *)format;

+ (NSString*)dictionaryToJson:(id)dic;
+ (NSString *)checkString:(NSString *)str;
+ (NSString *)checkNull: (id)data;
+ (BOOL)checkStringIsNilOrSpance: (NSString *)str;
+ (NSMutableAttributedString *)setTextViewFontOfString:(NSString *)string paragraphStyle:(NSInteger)lineHeight fontSize:(float)size color:(UIColor *)color;
+ (NSMutableAttributedString *)setTextViewBoldFontOfString:(NSString *)string paragraphStyle:(NSInteger)lineHeight fontSize:(float)size color:(UIColor *)color;
+ (NSString *)trimmingCharacters:(NSString *)str;
+ (int)compareDate:(NSString*)oneDate withDate:(NSString*)twoDate;
+(UILabel *)labelWithTitle:(NSString *)title frame:(CGRect)frame textFont:(UIFont *)titleFont;
+ (UIButton *)buttonWithTitle:(NSString *)title Image:(UIImage *)image frame:(CGRect)frame fontSize:(float)fontSize fontColor:(UIColor *)color;
+ (UIButton *)buttonWithImage:(UIImage *)image frame:(CGRect)frame;
+ (NSString *)getWeekFromDate;
+ (NSString *)getWeekFromDateWithDate: (NSDate *)date;
+ (NSInteger)getWeeks:(NSInteger)year;
+ (NSString*)weekdayStringFromDate:(NSDate*)inputDate;
+(NSString *)countNumAndChangeformat:(NSString *)num;
+ (NSString *)getWeekFromDateStr:(NSString *)dataStr;
+(NSString *)stringDisposeWithFloat:(float)floatValue;


@end
