//
//  ICRHTTPController.h
//  Cruiser
//
//  Created by Xummer on 3/26/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"
#import "ICRAnnouncement.h"

typedef NS_ENUM(NSUInteger, ICRAttachmentType) {
    kAttachmentBoard = 0,
    kAttachmentAnswer,
    kAttachmentTask,
    kAttachmentSaleInput,
    // Insert enum here
    kAttachmentTypeCount,
};


@interface ICRHTTPController : IBTObject

+ (instancetype)sharedController;

// Restful API



/* 密码修改（写）*/
- (void)doChangePassword:(NSString *)nsPassword
             newPassword:(NSString *)nsNewPassword
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;







// Board
/* 公告列表（读）
    获得公告列表
 */
//- (void)doGetBoardListFromUpdateTime:(NSString *)updateTime
//                            position:(NSUInteger)uiPosition
//                                size:(NSUInteger)uiSize
//                                type:(ICRAnnouncementType)eType
//                         deleteLocal:(BOOL)bDeleteLocal
//                             success:(void (^)(id data))succ
//                             failure:(void (^)(id data))fail;

/* 读取公告（读）
    读取单个公告
 */
- (void)doGetBoardWithID:(NSNumber *)boardID
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;

/* 提交公告已读状态（写）*/
- (void)doReadBoardWithID:(NSNumber *)boardID
                  success:(void (^)(id data))succ
                  failure:(void (^)(id data))fail;

// Attachment
/* 添加附件（读）*/
- (void)doAddAttachment:(id)data
                success:(void (^)(id data))succ
                failure:(void (^)(id data))fail;

/* 返回附件列表 */
- (void)doGetAttachmentListWithType:(ICRAttachmentType)eType
                              objID:(NSString *)objID
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

/* 下载附件 */
- (void)doDownloadAttachmentWithID:(NSNumber *)attachmentID
                           success:(void (^)(id data))succ
                           failure:(void (^)(id data))fail;

/* 添加附件（读）直接上传方式 */
- (void)doAddDirectAttachment:(id)data
                      success:(void (^)(id))succ
                      failure:(void (^)(id))fail;

+ (NSString *)AttachmentUrlWithID:(id)attachmentID;

/* 下载附件，直接下载方式 */
- (void)doDownloadDirectAttachment:(NSString *)attachmentId
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;

- (void)postUrl:(NSString *)url params:(id)params success:(void (^)(id data))succ failure:(void (^)(id data))fail;

- (void)getUrl:(NSString *)url params:(id)params success:(void (^)(id data))succ failure:(void (^)(id data))fail;

- (void)POST:(NSString *)requestUrl pictures:(NSArray *)pictures param:(NSDictionary *)params complete:(void (^)(id responseObject, NSError *error))complete;


@end


