
//  VankeUserLoginAPI.h
//  vanke
//
//  Created by xiaomi on 15/10/6.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "Bee.h"
#import "VankeBaseAPI.h"
#import "VankeResponse.h"

#pragma mark -

@class LoginResponse;

// post: http://.../wanke-server/rest/user/login/{login}
@interface VankeUserLoginAPI: VankeBaseAPI

@property (nonatomic, strong) NSString *userName;
@property (nonatomic, strong) NSString *password;
@property (nonatomic, strong) NSString *authenticode;

@end

/** uuid code name */
@interface UCN: BeeActiveObject

// 标识
@property (nonatomic, strong) NSString *uuid;
// 代码
@property (nonatomic, strong) NSString *code;
// 名称
@property (nonatomic, strong) NSString *name;

@end

/** 用户 */
@interface User: BeeActiveObject

// 用户标识
@property (nonatomic, strong) NSString *uuid;
// 用户代码
@property (nonatomic, strong) NSString *code;
// 用户名称
@property (nonatomic, strong) NSString *name;

@end

/** 企业 */
@interface Enterpirse: BeeActiveObject

// 企业标识
@property (nonatomic, strong) NSString *uuid;
// 企业代码
@property (nonatomic, strong) NSString *code;
// 企业名称
@property (nonatomic, strong) NSString *name;

@end

// 授权组织
@interface AuthorizedOrg : BeeActiveObject

// 标识
@property (nonatomic, strong) NSString *uuid;
// 代码
@property (nonatomic, strong) NSString *code;
// 名称
@property (nonatomic, strong) NSString *name;
// 图片
@property (nonatomic, strong) NSString *picture;

@end

extern NSString *const USER_POSITION_HQ;         // 用户职位: 集团
extern NSString *const USER_POSITION_STORE;      // 用户职位: 市场用户
extern NSString *const USER_POSITION_TENANT;     // 用户职位: 商户用户

// 登录响应数据
@interface LoginResponseData : BeeActiveObject

//// 用户
//@property (nonatomic, strong) User *user;
//// 所属企业
//@property (nonatomic, strong) Enterpirse *enterprise;

// 用户标识
@property (nonatomic, strong) NSString *user_uuid;
// 用户代码
@property (nonatomic, strong) NSString *user_code;
// 用户名称
@property (nonatomic, strong) NSString *user_name;

// 企业标识
@property (nonatomic, strong) NSString *enterprise_uuid;
// 企业代码
@property (nonatomic, strong) NSString *enterprise_code;
// 企业名称
@property (nonatomic, strong) NSString *enterprise_name;

// 企业认证码
@property (nonatomic, strong) NSString *authenticode;

// 授权组织
@property (nonatomic, strong) NSArray *authorizedOrgs;

// 职位
@property (nonatomic, strong) NSString *position;

// 商铺
@property (nonatomic, strong) UCN *tenant;


-(User*) getUser;
-(Enterpirse*) getEnterprise;

@end

// 登录请求返回
@interface LoginResponse : VankeResponse
@property (nonatomic, strong) LoginResponseData *data;
@end
