//
//  VankeProjectListAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeProjectListAPI.h"
#import "VankeConfig.h"
#import "VankeUtil.h"

@implementation VankeProjectListAPI

@synthesize classificationEquals;
@synthesize nameLike;
@synthesize salesDateEquals;
@synthesize passengerDateEquals;
@synthesize trafficDateEquals;

-(void) route:(BeeMessage *)msg {
    if (self.sending)
    {
        if (![self checkToQuery]) {
            return;
        }
        
        [self http_get:@"/project/queryprojectsby"].PARAM(@"classificationEquals", self.classificationEquals).PARAM(@"nameLike", nil == self.nameLike ? @"" : self.nameLike).PARAM(@"salesDateEquals", self.salesDateEquals).PARAM(@"passengerDateEquals", self.passengerDateEquals).PARAM(@"trafficDateEquals", self.trafficDateEquals).TIMEOUT(10);
    }
    else if (self.succeed)
    {
        NSLog(@"response: %@", self.responseString);
        
        self.serverResp = [ProjectListResponse objectFromDictionary: self.responseJSONDictionary];
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    } else if (self.failed) {
        NSLog(@"response: %@", self.responseString);
        self.serverResp = [ProjectListResponse objectFromDictionary: self.responseJSONDictionary];
    }
}

-(BOOL) checkToQuery {
    if ([VankeUtil isBlankString:self.classificationEquals]) {
        [self setClientError: @"项目分类不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.salesDateEquals]) {
        [self setClientError: @"销量日期不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.passengerDateEquals]) {
        [self setClientError: @"客流量日期不能为空"];
        return NO;
    }
    
    if ([VankeUtil isBlankString:self.trafficDateEquals]) {
        [self setClientError: @"车流量日期不能为空"];
        return NO;
    }
    
    return YES;
}

@end

#pragma ProjectCategory

@implementation ProjectCategory

@synthesize projectClassification;
@synthesize projectId;
@synthesize projectName;
@synthesize foundingDate;
@synthesize salesAmount;
@synthesize passengerFlowVolume;
@synthesize perCustomerTransaction;
@synthesize picture;
@synthesize salesDate;

-(NSString*) getPictureUrlOrDefault {
    if ([VankeUtil isBlankString:self.picture]) {
        return @"floor-def.jpg";
    } else {
        return [NSString stringWithFormat:@"%@/%@", VANKE_SERVER_MEDIA_BASE_URL, self.picture];
    }
}

@end

#pragma ProjectListResponse

@implementation ProjectListResponse

@synthesize data;

CONVERT_PROPERTY_CLASS(data, ProjectCategory)

-(int) total {
    return nil == data ? 0 :[data count];
}

@end
