//
//  SalesInputTableViewCell.m
//  vanke
//
//  Created by Z on 16/4/18.
//  Copyright © 2016年 gomore. All rights reserved.
//

#import "SalesInputTableViewCell.h"

@interface SalesInputTableViewCell ()<UITextFieldDelegate>
@property (weak, nonatomic) IBOutlet UITextField *textFieldAmount;
@property (weak, nonatomic) IBOutlet UITextField *txtfieldSum;

@end

@implementation SalesInputTableViewCell

- (void)awakeFromNib {
    self.selectionStyle = UITableViewCellSelectionStyleNone;
    self.textFieldAmount.delegate = self;
    self.txtfieldSum.delegate = self;
    
        // Initialization code
}

- (void)cellWithArray:(NSArray *)array {
    
    self.textFieldAmount.text = [array[0] isEqualToString:@"0"] ? @"" : array[0];
    self.txtfieldSum.text = [array[1] isEqualToString:@"0"] ? @"" : array[0];
}

//结束编辑
- (void)textFieldDidEndEditing:(UITextField *)textField {
    NSLog(@"textField end editing");
    
    if (([self.txtfieldSum.text isEqualToString:@"0"] || [self.txtfieldSum.text isEqualToString:@""]) && ![self.textFieldAmount.text isEqualToString:@""])
    {
        self.txtfieldSum.text = @"1";
    }else if ([self.textFieldAmount.text isEqualToString:@""]){
        self.txtfieldSum.text = @"";
    }
    
    self.updateCellData(@[self.textFieldAmount.text, self.txtfieldSum.text]);
}

- (void)textFieldDidBeginEditing:(UITextField *)textField
{
    [textField selectAll:self];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
