//
//  ChooseShopViewController.m
//  vanke
//
//  Created by Z on 16/4/19.
//  Copyright © 2016年 gomore. All rights reserved.
//

#import "ChooseShopViewController.h"
#import "UIImage+Helper.h"
#import "ICRHTTPController.h"
#import "LoginShopsInstance.h"

#define kCellId @"searchCell"
@interface ChooseShopViewController ()<UITableViewDelegate, UITableViewDataSource, UISearchBarDelegate>
@property (nonatomic, strong) UISearchBar *searchBar;
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, copy) NSString *searchText;
@property (nonatomic, strong) NSMutableArray *arrData;
@property (nonatomic, strong) NSArray *results;
@property (nonatomic, strong) VankeShopModel *shop;

@property (nonatomic, assign) BOOL isChoose;

@end

@implementation ChooseShopViewController

- (void)viewDidLoad {

    [super viewDidLoad];
    self.arrData = [LoginShopsInstance shareInstance].arrShops;
    self.results = [NSArray arrayWithArray:self.arrData];
    self.title = @"选择商铺";
    [self setUPSearchBar];
    [self setUpTableView];
    // Do any additional setup after loading the view.
}

- (void)setUPSearchBar {
    self.searchBar = [[UISearchBar alloc] initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, 50)];
    self.searchBar.backgroundImage = [UIImage imageWithColor:[UIColor colorWithRed:0.953 green:0.439 blue:0.063 alpha:1.000]];
    self.searchBar.tintColor = [UIColor whiteColor];
    self.searchBar.placeholder = @"请输入关键字";
    self.searchBar.delegate = self;
    [self.view addSubview:self.searchBar];
}

#pragma mark =========== searbar delegate ===========
- (void)searchBarCancelButtonClicked:(UISearchBar *)searchBar {
    [self.view endEditing:YES];
    searchBar.showsCancelButton = NO;
    searchBar.text = nil;
    self.results = [NSArray arrayWithArray:self.arrData];
    [self.tableView reloadData];
}

- (void)searchBar:(UISearchBar *)searchBar textDidChange:(NSString *)searchText {
    self.searchText = searchText;
    NSPredicate *pred = [NSPredicate predicateWithFormat:@"name contains [cd] %@ OR code contains [cd] %@", searchText, searchText];
    self.results = [self.arrData filteredArrayUsingPredicate:pred];
    [self.tableView reloadData];
}

- (BOOL)searchBarShouldBeginEditing:(UISearchBar *)searchBar {
    searchBar.showsCancelButton = YES;
    return YES;
}

- (void)searchBarSearchButtonClicked:(UISearchBar *)searchBar {
    [self searchShopName:self.searchText];
    [self.view endEditing:YES];
}

- (void)searchShopName:(NSString *)name {
    NSDictionary *param = @{@"codeOrNameLike":name,
                            @"projectIdEquals":@""};
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl getUrl:@"rest/shop/" params:param success:^(id data){
        
    } failure:^(id data){
        
    }];
    
}

- (void)setUpTableView {
    self.tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, self.searchBar.bottom, SCREEN_WIDTH, SCREEN_HEIGHT - self.searchBar.bottom - 64) style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:kCellId];
    [self.view addSubview:self.tableView];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.results.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellId forIndexPath:indexPath];
    VankeShopModel *shop = self.results[indexPath.row];
    cell.textLabel.text = [NSString stringWithFormat:@"%@【%@】", shop.name, shop.code];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    self.chooseBlock(self.results[indexPath.row]);
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
