//
//  VankeNoticeListAPI.m
//  vanke
//
//  Created by xiaomi on 15/10/8.
//  Copyright © 2015年 gomore. All rights reserved.
//

#import "VankeNoticeListAPI.h"
#import "VankeConfig.h"
#import "VankeUtil.h"
#import "VankeCommonModel.h"

@implementation VankeNoticeListAPI

@synthesize read;
@synthesize pageNumber;
@synthesize pageSize;

-(void) route:(BeeMessage *)msg {
    if (self.sending)
    {
        if (![self checkToQuery]) {
            return;
        }
        
        User *curUser = [[VankeCommonModel sharedInstance] currentUser];
        NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:
                              self.read? @"true": @"false", @"read",
                              [NSString stringWithFormat:@"%lu", self.pageNumber], @"page_number",
                              [NSString stringWithFormat:@"%lu", self.pageSize], @"page_size",
                              nil];
        NSString *url = [NSString stringWithFormat:@"/affiche/download/%@", curUser.uuid];
        [self http_post:url].BODY(dict).TIMEOUT(10);
    }
    else if (self.succeed)
    {
        NSLog(@"response: %@", self.responseString);
        
        self.serverResp = [NoticeListResponse objectFromDictionary: self.responseJSONDictionary];        
        if ( nil == self.serverResp )
        {
            self.failed = YES;
            return;
        }
    } else if (self.failed) {
        NSLog(@"response: %@", self.responseString);
        self.serverResp = [NoticeListResponse objectFromDictionary: self.responseJSONDictionary];
    }
}

-(BOOL) checkToQuery {
    User *curUser = [[VankeCommonModel sharedInstance] currentUser];
    if (nil == curUser) {
        [self setClientError: @"尚未登录"];
        return NO;
    }
    
    return YES;
}

@end

#pragma Notice

@implementation Notice

@synthesize uuid;
@synthesize version;
@synthesize create_time;
@synthesize create_id;
@synthesize create_operName;
@synthesize lastModify_id;
@synthesize lastModify_time;
@synthesize lastModify_operName;
@synthesize enterprise;
@synthesize title;
@synthesize content;
@synthesize priority;
@synthesize state;
@synthesize attachment;

-(NSString*) getAttachmentUrl {
    if ([VankeUtil isBlankString:self.attachment]) {
        return nil;
    } else {
        return [NSString stringWithFormat:@"%@/%@", VANKE_SERVER_MEDIA_BASE_URL, self.attachment];
    }
}

@end

#pragma NoticeListResponseData 

@implementation NoticeListResponseData

@synthesize paging;
@synthesize records;

CONVERT_PROPERTY_CLASS(records, Notice)

@end

#pragma NoticeListResponse

@implementation NoticeListResponse

@synthesize data;

-(NSInteger) total {
    return nil == data ? 0 :data.records.count;
}

@end
