//
//  IBTSegmentContainer.m
//  Cruiser
//
//  Created by Xummer on 4/11/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTSegmentContainer.h"
#import "IBTUIKit.h"

#define SEGMENT_LEFT_PADDING    (15)

@implementation IBTSegmentContainer

#pragma mark - Life Cycle
- (id)initWithItems:(NSArray *)items {
    self = [super init];
    if (self) {
        self.segmentControl = [[IBTSegmentedControl alloc] initWithItems:items];
        [self addSubview:_segmentControl];
    }
    return self;
}

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
        [self _init];
    }
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    _segmentControl.frame = (CGRect){
        .origin.x = SEGMENT_LEFT_PADDING,
        .origin.y = (CGRectGetHeight(self.bounds) - SEGMENT_HEIGHT) * .5f,
        .size.width = CGRectGetWidth(self.bounds) - 2 * SEGMENT_LEFT_PADDING,
        .size.height = SEGMENT_HEIGHT
    };
}

#pragma mark - Private Method

- (void)_init {
    
    self.backgroundColor = [UIColor whiteColor];
    
    IBTUIView *greyLine = [[IBTUIView alloc] initWithFrame:(CGRect){
        .origin.x = 0,
        .origin.y = CGRectGetHeight(self.bounds) - 1,
        .size.width = CGRectGetWidth(self.bounds),
        .size.height = 1
    }];
    greyLine.backgroundColor = IBT_CELL_GREY_LINE_COLOR;
    greyLine.autoresizingMask = UIViewAutoresizingFlexibleTopMargin | UIViewAutoresizingFlexibleWidth;
    [self addSubview:greyLine];
}


@end