
//
//  VankeCommonModel.h
//  vanke
//
//  Created by xiaomi on 15/10/7.
//  Copyright © 2015年 gomore. All rights reserved.
//
#import "Bee.h"
#import "VankeUserLoginAPI.h"

#pragma mark -

// TODO 要按最新的结构调整
@interface VankeCommonModel : NSObject

AS_SINGLETON(VankeCommonModel)

/**
 *  保存登录信息
 *
 *  @param info     登录请求响应，传入nil表示清空当前人员信息
 *  @param password 密码
 */
- (void) saveLoginInfo: (LoginResponseData*) info password: (NSString*) password;

/**
 *  取得当前登录人员信息
 *
 *  @return 人员信息，找不到返回nil
 */
- (LoginResponseData*) getLoginInfo;

/**
 *  删除当前登录信息
 */
- (void) removeLoginInfo;

/**
 *  当前登录人员基本信息
 *
 *  @return 人员基本信息，找不到返回nil.
 */
- (User*) currentUser;

/**
 *  当前登录人员的所属组织信息
 *
 *  @return 组织基本信息，找不到返回nil.
 */
- (Enterpirse*) currentEnt;

/**
 *  当前人员的授权组织列表
 *
 *  @return 组织列表，找不到nil
 */
-(NSArray*) getAuthOrgs;

/**
 *  当前登录人员的登录密码
 *
 *  @return 明文密码，找不到返回nil.
 */
- (NSString*) currentUserPwd;



@end


