
#import <Foundation/Foundation.h>
#import "JSONModel.h"


/**
 *  单据状态
 *
 *  @author wsx
 *
 */
/**
 * 未提交
 */
extern NSString * const BILLSTATE_INITIAL;
/**
 * 已提交
 */
extern NSString * const BILLSTATE_SUBMIT;
/**
 * 已完成
 */
extern NSString * const BILLSTATE_ACCOMPLISHED;




/**
 *  合约状态。
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 增加
 */
extern NSString * const CONTRACTLOGACTIONTYPE_ADD;
/**
 * 减少
 */
extern NSString * const CONTRACTLOGACTIONTYPE_SUB;




/**
 *  合约状态。
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 配油单
 */
extern NSString * const CONTRACTLOGSOURCETYPE_PICKINGBILL;
/**
 * 收油单
 */
extern NSString * const CONTRACTLOGSOURCETYPE_RECEIVEBILL;




/**
 *  修改数量类型。
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 账面余额
 */
extern NSString * const CONTRACTLOGQUANTITYTYPE_VIRTUAL;
/**
 * 实际余额
 */
extern NSString * const CONTRACTLOGQUANTITYTYPE_REAL;




/**
 *  建仓单状态。
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 未提交
 */
extern NSString * const DEPOTBILLSTATE_INITIAL;
/**
 * 已提交
 */
extern NSString * const DEPOTBILLSTATE_SUBMIT;
/**
 * 已取消
 */
extern NSString * const DEPOTBILLSTATE_CANCELED;
/**
 * 已生效
 */
extern NSString * const DEPOTBILLSTATE_EFFECTIVED;
/**
 * 已完成
 */
extern NSString * const DEPOTBILLSTATE_ACCOMPLISHED;




/**
 *  付款方式
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 现金
 */
extern NSString * const PAYMETHOD_CASH;
/**
 * 支票
 */
extern NSString * const PAYMETHOD_CHEQUE;
/**
 * 转账
 */
extern NSString * const PAYMETHOD_TRANSFER;




/**
 *  合约状态。
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 保存
 */
extern NSString * const CONTRACTSTATE_SAVE;
/**
 * 已提交
 */
extern NSString * const CONTRACTSTATE_SUBMIT;
/**
 * 已关闭
 */
extern NSString * const CONTRACTSTATE_CLOSE;




/**
 *  建仓申请类型
 *
 *  @author wsx
 *
 */
/**
 * 普通
 */
extern NSString * const DEPOTTYPE_GENERAL;
/**
 * 特殊
 */
extern NSString * const DEPOTTYPE_SPECIAL;




/**
 *  申请状态
 *
 *  @author wsx
 *
 */
/**
 * 未提交
 */
extern NSString * const DEPOTREQUESTBILLSTATE_INITIAL;
/**
 * 已提交
 */
extern NSString * const DEPOTREQUESTBILLSTATE_SUBMIT;
/**
 * 已取消
 */
extern NSString * const DEPOTREQUESTBILLSTATE_CANCELED;
/**
 * 已生效
 */
extern NSString * const DEPOTREQUESTBILLSTATE_EFFECTIVED;
/**
 * 已完成
 */
extern NSString * const DEPOTREQUESTBILLSTATE_ACCOMPLISHED;




/**
 * (no documentation provided)
 */
/**
 *
 */
extern NSString * const QUERYORDERDIRECTION_ASC;
/**
 *
 */
extern NSString * const QUERYORDERDIRECTION_DESC;




/**
 *  配油方式
 *
 *  @author wsx
 *
 */
/**
 * 自发
 */
extern NSString * const TRANSINFOTYPE_SELFSHIPPING;
/**
 * 直送
 */
extern NSString * const TRANSINFOTYPE_DIRECTSENDING;




/**
 *  经营方式
 *
 *  @author wsx
 *
 */
/**
 * COCO
 */
extern NSString * const OPERATINGTYPE_SELFSUPPORT;
/**
 * DODO
 */
extern NSString * const OPERATINGTYPE_LEAGUE;




/**
 *  油站状态
 *
 *  @author wsx
 *
 */
/**
 * 未生效
 */
extern NSString * const STORESTATE_INEFFECTIVE;
/**
 * 生效
 */
extern NSString * const STORESTATE_EFFECTIVE;
/**
 * 作废
 */
extern NSString * const STORESTATE_INVALID;




/**
 *  订油单状态
 *
 *  @author wsx
 *
 */
/**
 * 未提交
 */
extern NSString * const ORDERBILLSTATE_INITIAL;
/**
 * 已提交
 */
extern NSString * const ORDERBILLSTATE_SUBMIT;
/**
 * 已取消
 */
extern NSString * const ORDERBILLSTATE_CANCELED;
/**
 * 配送中(部分已配货)
 */
extern NSString * const ORDERBILLSTATE_SHIPPING;
/**
 * 已配货(全部已配货)
 */
extern NSString * const ORDERBILLSTATE_SHIPPED;
/**
 * 已完成
 */
extern NSString * const ORDERBILLSTATE_ACCOMPLISHED;




/**
 *  配油单状态
 *
 *  @author wsx
 *
 */
/**
 * 未提交
 */
extern NSString * const PICKINGBILLSTATE_INITIAL;
/**
 * 已提交
 */
extern NSString * const PICKINGBILLSTATE_SUBMIT;
/**
 * 已完成
 */
extern NSString * const PICKINGBILLSTATE_ACCOMPLISHED;




/**
 *  订油单明细状态
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 未配送
 */
extern NSString * const ORDERBILLDTLSTATE_INITIAL;
/**
 * 配送中
 */
extern NSString * const ORDERBILLDTLSTATE_SHIPPING;
/**
 * 已完成
 */
extern NSString * const ORDERBILLDTLSTATE_ACCOMPLISHED;




/**
 *  油价类别。
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 售价
 */
extern NSString * const PRICECATEGORY_SALEPRICE;
/**
 * 普通建仓批发价
 */
extern NSString * const PRICECATEGORY_GENERALTRADEPRICE;
/**
 * 特殊建仓批发价
 */
extern NSString * const PRICECATEGORY_SPECTRADEPRICE;
/**
 * 内部配送价
 */
extern NSString * const PRICECATEGORY_INTERALSHIPPINGPRICE;




/**
 *  收油单状态。
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 未提交
 */
extern NSString * const RECEIVEBILLSTATE_INITIAL;
/**
 * 已提交
 */
extern NSString * const RECEIVEBILLSTATE_SUBMIT;




/**
 *  收油单状态。
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 未导出
 */
extern NSString * const RECEIVEBILLEXPOTSTATE_NOEXPOT;
/**
 * 已导出库存入库单
 */
extern NSString * const RECEIVEBILLEXPOTSTATE_EXPORTENVIN;
/**
 * 已导出销售订单
 */
extern NSString * const RECEIVEBILLEXPOTSTATE_EXPORTSALE;
/**
 * 已导出发货单
 */
extern NSString * const RECEIVEBILLEXPOTSTATE_EXPORTPICKING;
/**
 * 已导出库存出库单
 */
extern NSString * const RECEIVEBILLEXPOTSTATE_EXPORTENVOUT;




/**
 *  提醒类型。
 *
 *  @author Debenson
 *  @since 0.1
 */
/**
 * 合约数量
 */
extern NSString * const REMINDTYPE_CONTRACTNUMBER;




/**
 *  配油单状态
 *
 *  @author wsx
 *
 */
/**
 * 已保存
 */
extern NSString * const FUELPRICESTATE_INITIAL;
/**
 * 已提交
 */
extern NSString * const FUELPRICESTATE_SUBMIT;




/**
 * (no documentation provided)
 */
/**
 *
 */
extern NSString * const POSITIONTYPE_MANAGER;
/**
 *
 */
extern NSString * const POSITIONTYPE_INSPECTOR;
/**
 *
 */
extern NSString * const POSITIONTYPE_STORER;
/**
 *
 */
extern NSString * const POSITIONTYPE_ENGINEER;
/**
 *
 */
extern NSString * const POSITIONTYPE_PURCHASEMAN;
/**
 *
 */
extern NSString * const POSITIONTYPE_PURCHASER;
/**
 *
 */
extern NSString * const POSITIONTYPE_VENDOR;
/**
 *
 */
extern NSString * const POSITIONTYPE_NONE;




@class BeanOperator;
@class OperateInfo;
@class Operator;
@class UCN;
@class PEntity;
@class POperator;
@class QueryCondition;
@class QueryOrder;
@class QueryResult;
@class QueryDefinition2;
@class DateTimeRange;
@class AreaMap;
@class QueryResultPaging;
@class QueryDefinition;
@class GasMeasureValue;
@class POperateInfo;
@class RsOperateInfo;
@class OperateInfo2;
@class Entity;
@class BeanOperateInfo;
@class GasFueler;
@class GasTransInfo;
@class DeliveryArea;
@class Carrier;
@class GasDepot;
@class BasicBillDtl;
@class StandardEntity2;
@class Area;
@class PStandardEntity;
@class GasItem;
@class GasTank;
@class StandardEntity;
@class OrderBillDtl;
@class FuelPrice;
@class ReceiveTankDtl;
@class PEnterpriseEntity;
@class DepotPickingDtl;
@class EnterpriseEntity2;
@class Role;
@class DepotBillPayDtl;
@class EnterpriseEntity;
@class Store;
@class BasicEnterpriseBill2;
@class User;
@class Organization;
@class PBasicEnterpriseBill;
@class PickingBill;
@class ReceiveBill;
@class Remind;
@class RemindLog;
@class TotalOption;
@class POBill;
@class OrderBill;
@class CarryInfo;
@class DepotRequestBill;
@class ContractNumber;
@class DepotInv;
@class DepotBill;
@class ContractLog;
@class Contract;

@protocol BeanOperator @end
@protocol OperateInfo @end
@protocol Operator @end
@protocol UCN @end
@protocol PEntity @end
@protocol POperator @end
@protocol QueryCondition @end
@protocol QueryOrder @end
@protocol QueryResult @end
@protocol QueryDefinition2 @end
@protocol DateTimeRange @end
@protocol AreaMap @end
@protocol QueryResultPaging @end
@protocol QueryDefinition @end
@protocol GasMeasureValue @end
@protocol POperateInfo @end
@protocol RsOperateInfo @end
@protocol OperateInfo2 @end
@protocol Entity @end
@protocol BeanOperateInfo @end
@protocol GasFueler @end
@protocol GasTransInfo @end
@protocol DeliveryArea @end
@protocol Carrier @end
@protocol GasDepot @end
@protocol BasicBillDtl @end
@protocol StandardEntity2 @end
@protocol Area @end
@protocol PStandardEntity @end
@protocol GasItem @end
@protocol GasTank @end
@protocol StandardEntity @end
@protocol OrderBillDtl @end
@protocol FuelPrice @end
@protocol ReceiveTankDtl @end
@protocol PEnterpriseEntity @end
@protocol DepotPickingDtl @end
@protocol EnterpriseEntity2 @end
@protocol Role @end
@protocol DepotBillPayDtl @end
@protocol EnterpriseEntity @end
@protocol Store @end
@protocol BasicEnterpriseBill2 @end
@protocol User @end
@protocol Organization @end
@protocol PBasicEnterpriseBill @end
@protocol PickingBill @end
@protocol ReceiveBill @end
@protocol Remind @end
@protocol RemindLog @end
@protocol TotalOption @end
@protocol POBill @end
@protocol OrderBill @end
@protocol CarryInfo @end
@protocol DepotRequestBill @end
@protocol ContractNumber @end
@protocol DepotInv @end
@protocol DepotBill @end
@protocol ContractLog @end
@protocol Contract @end


/**
 * (no documentation provided)
 */
@interface BeanOperator : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *operId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *operName;
@end /* interface BeanOperator */



/**
 * (no documentation provided)
 */
@interface OperateInfo : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *time;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) Operator *operator;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *enterprise;
@end /* interface OperateInfo */



/**
 * (no documentation provided)
 */
@interface Operator : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *operName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
@end /* interface Operator */



/**
 * (no documentation provided)
 */
@interface UCN : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *uuid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface UCN */



/**
 * (no documentation provided)
 */
@interface PEntity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *uuid;
@end /* interface PEntity */



/**
 * (no documentation provided)
 */
@interface POperator : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *operName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *fid;
@end /* interface POperator */



/**
 * (no documentation provided)
 */
@interface QueryCondition : JSONModel
/**
 * (no documentation provided)
 * @see NSObject
 *
 */
@property (nonatomic, strong) NSArray<NSObject> *parameters;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *operation;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSObject *parameter;
@end /* interface QueryCondition */



/**
 * (no documentation provided)
 */
@interface QueryOrder : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *field;
/**
 * (no documentation provided)
 *
 * 取值: QUERYORDERDIRECTION_ASC, QUERYORDERDIRECTION_DESC,
 */
@property (nonatomic, copy) NSString *direction;
@end /* interface QueryOrder */



/**
 * (no documentation provided)
 */
@interface QueryResult : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) QueryResultPaging *paging;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger pageCount;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) long long recordCount;
/**
 * (no documentation provided)
 * @see NSObject
 *
 */
@property (nonatomic, strong) NSArray<NSObject> *records;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
@end /* interface QueryResult */



/**
 * (no documentation provided)
 */
@interface QueryDefinition2 : JSONModel
/**
 * (no documentation provided)
 * @see QueryCondition
 *
 */
@property (nonatomic, strong) NSArray<QueryCondition> *conditions;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger pageNumber;
/**
 * (no documentation provided)
 * @see QueryOrder
 *
 */
@property (nonatomic, strong) NSArray<QueryOrder> *orders;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
@end /* interface QueryDefinition2 */



/**
 *  用来表示起止时间。
 
 @author Debenson
 @since 0.1
 
 */
@interface DateTimeRange : JSONModel
/**
 * 起始时间，非空
 *
 *
 */
@property (nonatomic, copy) NSString *beginDateTime;
/**
 * 截止时间，如果为null表示永久有效
 *
 *
 */
@property (nonatomic, copy) NSString *endDateTime;
@end /* interface DateTimeRange */



/**
 *  行政单位树。
 
 @author Debenson
 @since 0.1
 
 */
@interface AreaMap : JSONModel
/**
 * 行政区域
 *
 *
 */
@property (nonatomic, strong) Area *area;
/**
 * (no documentation provided)
 * @see Area
 *
 */
@property (nonatomic, strong) NSArray<Area> *childrenUnits;
@end /* interface AreaMap */



/**
 * (no documentation provided)
 */
@interface QueryResultPaging : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger page;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger pageSize;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) long long recordCount;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger pageCount;
@end /* interface QueryResultPaging */



/**
 * (no documentation provided)
 */
@interface QueryDefinition : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger limit;
/**
 * (no documentation provided)
 * @see QueryOrder
 *
 */
@property (nonatomic, strong) NSArray<QueryOrder> *orders;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger offset;
/**
 * (no documentation provided)
 * @see QueryCondition
 *
 */
@property (nonatomic, strong) NSArray<QueryCondition> *conditions;
@end /* interface QueryDefinition */



/**
 *  油气计量数。
 
 @author Debenson
 @since 0.1
 
 */
@interface GasMeasureValue : JSONModel
/**
 * 容量，单位: 升
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *capacity;
/**
 * 质量，单位公斤
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *quality;
/**
 * 密度
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *density;
/**
 * 标准体积
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *volume;
@end /* interface GasMeasureValue */



/**
 * (no documentation provided)
 */
@interface POperateInfo : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) POperator *operator;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *time;
@end /* interface POperateInfo */



/**
 *  操作人信息。
 
 <p>
 enunciate无法识别BeanOperator中使用 @QueryParam("")这种非标准的rest标签.
 
 @author Debenson
 @since 0.1
 @see com.thor.commons.entity.BeanOperateInfo
 
 */
@interface RsOperateInfo : JSONModel
/**
 * 操作人标识
 *
 *
 */
@property (nonatomic, copy) NSString *operId;
/**
 * 操作人名称
 *
 *
 */
@property (nonatomic, copy) NSString *operName;
/**
 * 操作时间
 *
 *
 */
@property (nonatomic, copy) NSString *time;
/**
 * 企业标识
 *
 *
 */
@property (nonatomic, copy) NSString *enterprise;
@end /* interface RsOperateInfo */



/**
 *  操作上下文。
 
 @author Debenson
 @since 0.1
 
 */
@interface OperateInfo2 : JSONModel
/**
 * 操作时间
 *
 *
 */
@property (nonatomic, copy) NSString *time;
/**
 * 操作人信息
 *
 *
 */
@property (nonatomic, strong) Operator *operator;
@end /* interface OperateInfo2 */



/**
 * (no documentation provided)
 */
@interface Entity : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *uuid;
@end /* interface Entity */



/**
 * (no documentation provided)
 */
@interface BeanOperateInfo : JSONModel
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *time;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) BeanOperator *operator;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *enterprise;
@end /* interface BeanOperateInfo */



/**
 *  发油商
 
 @author cyy24
 @since 0.1
 
 */
@interface GasFueler : Entity
/**
 * 发油商代码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 发油商名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface GasFueler */



/**
 *  配油默认信息维护
 
 @author cyy24
 @since 0.1
 
 */
@interface GasTransInfo : Entity
/**
 * 配油默认信息维护门店信息
 *
 *
 */
@property (nonatomic, strong) UCN *store;
/**
 * 配油默认信息维护油品信息
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * 配油默认信息维护类型
 *
 * 取值: TRANSINFOTYPE_SELFSHIPPING, TRANSINFOTYPE_DIRECTSENDING,
 */
@property (nonatomic, copy) NSString *type;
/**
 * 配油默认信息维护仓库信息
 *
 *
 */
@property (nonatomic, strong) UCN *depot;
/**
 * 配油默认信息维护供应商
 *
 *
 */
@property (nonatomic, copy) NSString *provider;
/**
 * 配油默认信息维护发油商
 *
 *
 */
@property (nonatomic, strong) UCN *fueler;
/**
 * 配油默认信息维护级别
 *
 *
 */
@property (nonatomic, assign) NSInteger level;
@end /* interface GasTransInfo */



/**
 *  配送区域
 
 @author Debenson
 @since 0.1
 
 */
@interface DeliveryArea : Entity
/**
 * 编码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface DeliveryArea */



/**
 *  油库
 
 @author cyy24
 @since 0.1
 
 */
@interface Carrier : Entity
/**
 * 油库代码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 油库代码
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface Carrier */



/**
 *  油库
 
 @author cyy24
 @since 0.1
 
 */
@interface GasDepot : Entity
/**
 * 油库代码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 油库代码
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 经度
 *
 *
 */
@property (nonatomic, copy) NSString *longitude;
/**
 * 纬度
 *
 *
 */
@property (nonatomic, copy) NSString *latitude;
@end /* interface GasDepot */



/**
 *  单据明细基类。
 
 @author Debenson
 @since 0.1
 
 */
@interface BasicBillDtl : Entity
/**
 * 行号
 *
 *
 */
@property (nonatomic, assign) NSInteger lineNumber;
/**
 * 创建信息
 *
 *
 */
@property (nonatomic, strong) OperateInfo2 *createInfo;
@end /* interface BasicBillDtl */



/**
 *  标准实体。
 
 @author thor
 
 
 */
@interface StandardEntity2 : Entity
/**
 * 版本号
 *
 *
 */
@property (nonatomic, assign) long long version;
/**
 * 操作人信息
 *
 *
 */
@property (nonatomic, strong) OperateInfo2 *createInfo;
/**
 * 最后修改信息
 *
 *
 */
@property (nonatomic, strong) OperateInfo2 *lastModifyInfo;
@end /* interface StandardEntity2 */



/**
 *  行政区域。
 
 @author wsx
 
 
 */
@interface Area : Entity
/**
 * 区域编码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 区域名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface Area */



/**
 * (no documentation provided)
 */
@interface PStandardEntity : PEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) POperateInfo *lastModifyInfo;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) POperateInfo *createInfo;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) long long version;
@end /* interface PStandardEntity */



/**
 *  油品
 
 @author cyy24
 @since 0.1
 
 */
@interface GasItem : Entity
/**
 * 油品代码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 油品名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 油品最小密度
 *
 *
 */
@property (nonatomic, assign) double minDensity;
/**
 * 油品最大密度
 *
 *
 */
@property (nonatomic, assign) double maxDensity;
@end /* interface GasItem */



/**
 *  油罐
 
 @author cyy24
 @since 0.1
 
 */
@interface GasTank : Entity
/**
 * 油罐代码
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * 油罐名称
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * 油罐所属门店
 *
 *
 */
@property (nonatomic, strong) UCN *store;
/**
 * 油罐油品
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * 油罐容量
 *
 *
 */
@property (nonatomic, assign) double capacity;
@end /* interface GasTank */



/**
 * (no documentation provided)
 */
@interface StandardEntity : Entity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) OperateInfo *createInfo;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) long long version;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) OperateInfo *lastModifyInfo;
@end /* interface StandardEntity */



/**
 *  订单明细。
 
 @author wsx
 @author Debenson
 @since 0.1
 
 */
@interface OrderBillDtl : BasicBillDtl
/**
 * 油品
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * 数量
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *quantity;
/**
 * 明细状态
 *
 * 取值: ORDERBILLDTLSTATE_INITIAL, ORDERBILLDTLSTATE_SHIPPING, ORDERBILLDTLSTATE_ACCOMPLISHED,
 */
@property (nonatomic, copy) NSString *state;
/**
 * 配送单号
 *
 *
 */
@property (nonatomic, copy) NSString *pickingBillNumber;
/**
 * 配送时间
 *
 *
 */
@property (nonatomic, copy) NSString *pickedTime;
/**
 * 要求到油时间
 *
 *
 */
@property (nonatomic, copy) NSString *receiveTime;
@end /* interface OrderBillDtl */



/**
 *  油价。
 
 <p>
 设计用来存储油品的售价、普通建仓批发价、特殊建仓批发价和内部配送价。
 
 @author Debenson
 @since 0.1
 
 */
@interface FuelPrice : StandardEntity2
/**
 * 状态
 *
 * 取值: FUELPRICESTATE_INITIAL, FUELPRICESTATE_SUBMIT,
 */
@property (nonatomic, copy) NSString *state;
/**
 * 价格类别
 *
 * 取值: PRICECATEGORY_SALEPRICE, PRICECATEGORY_GENERALTRADEPRICE, PRICECATEGORY_SPECTRADEPRICE, PRICECATEGORY_INTERALSHIPPINGPRICE,
 */
@property (nonatomic, copy) NSString *category;
/**
 * 油品
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * 国牌价， 当#getCategory() = PriceCategory#salePrice时有效。
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *guidancePrice;
/**
 * 售价
 * <p>
 * 根据 #getCategory() 价格类别的不同，此值的意义也不同：
 *
 * <pre>
 *  <table border=1>
 *    <tr>
 *         <td>价格类别</td>
 *         <td>含义（元/吨）</td>
 *    </tr>
 *    <tr>
 *         <td>PriceCategory#salePrice</td>
 *         <td>建议零售价</td>
 *    </tr>
 *          <tr>
 *         <td>PriceCategory#generalTradePrice</td>
 *         <td>普通建仓批发价</td>
 *    </tr>
 *          <tr>
 *         <td>PriceCategory#specTradePrice</td>
 *         <td>特殊建仓批发价</td>
 *    </tr>
 *         <tr>
 *         <td>PriceCategory#interalShippingPrice</td>
 *         <td>内部配送价</td>
 *    </tr>
 *  </table>
 *  </pre>
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *salePrice;
/**
 * 生效时间
 *
 *
 */
@property (nonatomic, strong) DateTimeRange *effectiveTime;
/**
 * 配送开始时间, 当#getCategory() = PriceCategory#specialTradePrice
 * 时有效。
 *
 *
 */
@property (nonatomic, strong) DateTimeRange *shipTime;
/**
 * 行政区域
 *
 * <p>
 * 当#getCategory() = PriceCategory#salePrice有效。
 *
 *
 */
@property (nonatomic, strong) UCN *area;
/**
 *
 *
 *
 */
@property (nonatomic, strong) UCN *deliveryArea;
@end /* interface FuelPrice */



/**
 *  收油单油罐明细
 
 @author wsx
 
 
 */
@interface ReceiveTankDtl : BasicBillDtl
/**
 * 油罐
 *
 *
 */
@property (nonatomic, strong) UCN *tank;
/**
 * 卸油前的测液位计量数
 *
 *
 */
@property (nonatomic, strong) GasMeasureValue *measureBeforeUnload;
/**
 * 卸油后的测液位计量数
 *
 *
 */
@property (nonatomic, strong) GasMeasureValue *measureAfterUnload;
/**
 * 期间销售计量数
 *
 *
 */
@property (nonatomic, strong) GasMeasureValue *measureOnSale;
/**
 * 计算测量值
 *
 *
 */
@property (nonatomic, strong) GasMeasureValue *measureCalc;
/**
 * 配送单计量数
 *
 *
 */
@property (nonatomic, strong) GasMeasureValue *measureBill;
/**
 * 实际配送数
 *
 *
 */
@property (nonatomic, strong) GasMeasureValue *measureRealDelivery;
@end /* interface ReceiveTankDtl */



/**
 * (no documentation provided)
 */
@interface PEnterpriseEntity : PStandardEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *enterprise;
@end /* interface PEnterpriseEntity */



/**
 *  配油明细，在建仓单已生效状态下可以被配油处理回写。
 
 @author Debenson
 @since 0.1
 
 */
@interface DepotPickingDtl : BasicBillDtl
/**
 * 配油数量（吨）
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *qty;
/**
 * 配油金额（元）
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *amount;
/**
 * 配油单号
 *
 *
 */
@property (nonatomic, copy) NSString *pickingBillNumber;
/**
 * 配油时间
 *
 *
 */
@property (nonatomic, copy) NSString *pickingTime;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
@end /* interface DepotPickingDtl */



/**
 *  带企业字段的entity
 
 @author Administrator
 
 
 */
@interface EnterpriseEntity2 : StandardEntity2
/**
 * 企业标识
 *
 *
 */
@property (nonatomic, copy) NSString *enterprise;
@end /* interface EnterpriseEntity2 */



/**
 * (no documentation provided)
 */
@interface Role : StandardEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *name;
@end /* interface Role */



/**
 *  建仓单付款明细。
 
 @author Debenson
 @since 0.1
 
 */
@interface DepotBillPayDtl : BasicBillDtl
/**
 * 付款方式
 *
 * 取值: PAYMETHOD_CASH, PAYMETHOD_CHEQUE, PAYMETHOD_TRANSFER,
 */
@property (nonatomic, copy) NSString *payMethod;
/**
 * 付款金额
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *total;
/**
 * 付款凭证
 *
 *
 */
@property (nonatomic, copy) NSString *payTicket;
/**
 * 付款时间
 *
 *
 */
@property (nonatomic, copy) NSString *payTime;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 是否已生效
 *
 *
 */
@property (nonatomic, assign) BOOL effectived;
@end /* interface DepotBillPayDtl */



/**
 * (no documentation provided)
 */
@interface EnterpriseEntity : StandardEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *enterprise;
@end /* interface EnterpriseEntity */



/**
 *  @author thor
 
 
 */
@interface Store : EnterpriseEntity2
/**
 * 所属公司
 *
 *
 */
@property (nonatomic, strong) Organization *company;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *opendate;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL status;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *longitude;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *latitude;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) Organization *operationArea;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *area;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *deliveryArea;
/**
 * (no documentation provided)
 *
 * 取值: OPERATINGTYPE_SELFSUPPORT, OPERATINGTYPE_LEAGUE,
 */
@property (nonatomic, copy) NSString *operatingType;
/**
 * (no documentation provided)
 * @see User
 *
 */
@property (nonatomic, strong) NSArray<User> *gasUser;
/**
 * (no documentation provided)
 *
 * 取值: STORESTATE_INEFFECTIVE, STORESTATE_EFFECTIVE, STORESTATE_INVALID,
 */
@property (nonatomic, copy) NSString *state;
/**
 * 客户代码
 *
 *
 */
@property (nonatomic, copy) NSString *consumerCode;
/**
 * 采购组织
 *
 *
 */
@property (nonatomic, copy) NSString *buyOrg;
/**
 * 公司代码
 *
 *
 */
@property (nonatomic, copy) NSString *companyCode;
/**
 * 工厂
 *
 *
 */
@property (nonatomic, copy) NSString *factory;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger days;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger hours;
@end /* interface Store */



/**
 *  基本单据实体。
 
 @author Debenson
 @since 0.1
 
 */
@interface BasicEnterpriseBill2 : EnterpriseEntity2
/**
 * 单号
 *
 *
 */
@property (nonatomic, copy) NSString *billnumber;
@end /* interface BasicEnterpriseBill2 */



/**
 * (no documentation provided)
 */
@interface User : EnterpriseEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) Organization *belongOrg;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *businessType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *login;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *password;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * (no documentation provided)
 *
 * 取值: POSITIONTYPE_MANAGER, POSITIONTYPE_INSPECTOR, POSITIONTYPE_STORER, POSITIONTYPE_ENGINEER, POSITIONTYPE_PURCHASEMAN, POSITIONTYPE_PURCHASER, POSITIONTYPE_VENDOR, POSITIONTYPE_NONE,
 */
@property (nonatomic, copy) NSString *position;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *mobile;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *email;
/**
 * (no documentation provided)
 * @see Role
 *
 */
@property (nonatomic, strong) NSArray<Role> *roles;
/**
 * (no documentation provided)
 * @see Organization
 *
 */
@property (nonatomic, strong) NSArray<Organization> *organizations;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL enabled;
@end /* interface User */



/**
 * (no documentation provided)
 */
@interface Organization : EnterpriseEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *orgType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *shortName;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *name;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL enabled;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL isLeaf;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *contact;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *attachmentId;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *storeType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *address;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) Organization *upper;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *authentication;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *namePath;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *phone;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *code;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *path;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger level;
@end /* interface Organization */



/**
 * (no documentation provided)
 */
@interface PBasicEnterpriseBill : PEnterpriseEntity
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *billnumber;
@end /* interface PBasicEnterpriseBill */



/**
 *  配油单。
 
 @author Debenson
 @since 0.1
 
 */
@interface PickingBill : BasicEnterpriseBill2
/**
 * 所属业主公司
 *
 *
 */
@property (nonatomic, strong) UCN *org;
/**
 * 来���订单，保存时只设置uuid字段即可，其它字段可不传。
 *
 *
 */
@property (nonatomic, strong) OrderBill *orderBill;
/**
 * 来源订单行，保存时只设置uuid即可， 其它字段可不传。
 *
 *
 */
@property (nonatomic, strong) OrderBillDtl *orderBillDtl;
/**
 * 状态
 *
 * 取值: PICKINGBILLSTATE_INITIAL, PICKINGBILLSTATE_SUBMIT, PICKINGBILLSTATE_ACCOMPLISHED,
 */
@property (nonatomic, copy) NSString *state;
/**
 * 油站
 *
 *
 */
@property (nonatomic, strong) UCN *store;
/**
 * 经营方式
 *
 * 取值: OPERATINGTYPE_SELFSUPPORT, OPERATINGTYPE_LEAGUE,
 */
@property (nonatomic, copy) NSString *operatingType;
/**
 * 油品
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * 配送数量
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *quantity;
/**
 * 油库
 *
 *
 */
@property (nonatomic, strong) UCN *depot;
/**
 * 类型
 *
 * 取值: TRANSINFOTYPE_SELFSHIPPING, TRANSINFOTYPE_DIRECTSENDING,
 */
@property (nonatomic, copy) NSString *pickType;
/**
 * 供应商
 *
 *
 */
@property (nonatomic, copy) NSString *provider;
/**
 * 发油商
 *
 *
 */
@property (nonatomic, strong) UCN *fueler;
/**
 * 到油时间
 *
 *
 */
@property (nonatomic, copy) NSString *receiveTime;
/**
 * 合约号
 *
 *
 */
@property (nonatomic, copy) NSString *contractNumber;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 价格
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *price;
/**
 * 金额
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *total;
/**
 * SO单是否已导出
 *
 *
 */
@property (nonatomic, copy) NSString *expotState;
/**
 * Excel是否已导出
 *
 *
 */
@property (nonatomic, copy) NSString *excelState;
/**
 * 承运商信息
 *
 *
 */
@property (nonatomic, strong) UCN *carrier;
@end /* interface PickingBill */



/**
 *  收油
 
 @author wsx
 
 
 */
@interface ReceiveBill : BasicEnterpriseBill2
/**
 * 状态
 *
 * 取值: RECEIVEBILLSTATE_INITIAL, RECEIVEBILLSTATE_SUBMIT,
 */
@property (nonatomic, copy) NSString *state;
/**
 * 导出状态
 *
 * 取值: RECEIVEBILLEXPOTSTATE_NOEXPOT, RECEIVEBILLEXPOTSTATE_EXPORTENVIN, RECEIVEBILLEXPOTSTATE_EXPORTSALE, RECEIVEBILLEXPOTSTATE_EXPORTPICKING, RECEIVEBILLEXPOTSTATE_EXPORTENVOUT,
 */
@property (nonatomic, copy) NSString *expotState;
/**
 * 油站
 *
 *
 */
@property (nonatomic, strong) UCN *store;
/**
 * 所属业主公司
 *
 *
 */
@property (nonatomic, strong) UCN *org;
/**
 * 经营方式
 *
 * 取值: OPERATINGTYPE_SELFSUPPORT, OPERATINGTYPE_LEAGUE,
 */
@property (nonatomic, copy) NSString *operatingType;
/**
 * 订单编号
 *
 *
 */
@property (nonatomic, copy) NSString *orderBillNumber;
/**
 * 配油编号
 *
 *
 */
@property (nonatomic, copy) NSString *pickingBillNumber;
/**
 * 供应商
 *
 *
 */
@property (nonatomic, copy) NSString *provider;
/**
 * 发油商
 *
 *
 */
@property (nonatomic, strong) UCN *fueler;
/**
 * 油仓
 *
 *
 */
@property (nonatomic, strong) UCN *depot;
/**
 * 油品
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * 车牌号
 *
 *
 */
@property (nonatomic, copy) NSString *truckNo;
/**
 * 货车司机
 *
 *
 */
@property (nonatomic, copy) NSString *carter;
/**
 * 货车司机联系方式
 *
 *
 */
@property (nonatomic, copy) NSString *carterMobile;
/**
 * 配送单计量数
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *billMeasure;
/**
 * 发油公斤数
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *realMeasure;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 收油单油罐明细
 * @see ReceiveTankDtl
 *
 */
@property (nonatomic, strong) NSArray<ReceiveTankDtl> *tankDtls;
/**
 * 要求到油时间
 *
 *
 */
@property (nonatomic, copy) NSString *receiveTime;
/**
 * 实际到油时间
 *
 *
 */
@property (nonatomic, copy) NSString *realReceiveTime;
/**
 * 班次号
 *
 *
 */
@property (nonatomic, copy) NSString *serviceNumber;
/**
 * 发油密度
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *pickFuelDensity;
/**
 * 发油升数
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *pickFuelDensityCapacity;
/**
 * 损耗升数
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *wasterCapacity;
/**
 * 收油营业日期
 *
 *
 */
@property (nonatomic, copy) NSString *receiveBusinessDate;
/**
 * 损耗率
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *wasterRate;
/**
 * 承运商
 *
 *
 */
@property (nonatomic, strong) UCN *carrier;
/**
 * 单价
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *price;
@end /* interface ReceiveBill */



/**
 *  提醒对象
 
 @author cyy24
 @since 0.1
 
 */
@interface Remind : BasicEnterpriseBill2
/**
 * (no documentation provided)
 *
 * 取值: REMINDTYPE_CONTRACTNUMBER,
 */
@property (nonatomic, copy) NSString *remindType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *receiver;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *phoneNumber;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *email;
@end /* interface Remind */



/**
 *  提醒日志
 
 @author cyy24
 @since 0.1
 
 */
@interface RemindLog : BasicEnterpriseBill2
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *fueler;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *receiverNumber;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *context;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) BOOL result;
@end /* interface RemindLog */



/**
 *  全局参数
 
 @author cyy24
 @since 0.1
 
 */
@interface TotalOption : BasicEnterpriseBill2
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *optionKey;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *optionValue;
@end /* interface TotalOption */



/**
 *  PO单。
 
 @author Debenson
 @since 0.1
 
 */
@interface POBill : PBasicEnterpriseBill
/**
 * 状态
 *
 *
 */
@property (nonatomic, copy) NSString *state;
/**
 * 订单类型
 *
 *
 */
@property (nonatomic, copy) NSString *billType;
/**
 * 采购订单日期
 *
 *
 */
@property (nonatomic, copy) NSString *buyBillTime;
/**
 * 供应商
 *
 *
 */
@property (nonatomic, copy) NSString *provider;
/**
 * 采购组织
 *
 *
 */
@property (nonatomic, copy) NSString *buyOrg;
/**
 * 采购组
 *
 *
 */
@property (nonatomic, copy) NSString *buyGroup;
/**
 * 公司代码
 *
 *
 */
@property (nonatomic, copy) NSString *org;
/**
 * 客户采购订单编号
 *
 *
 */
@property (nonatomic, copy) NSString *storeBuyBillCode;
/**
 * 采购合约
 *
 *
 */
@property (nonatomic, copy) NSString *buyContract;
/**
 * 采购合约行项目
 *
 *
 */
@property (nonatomic, copy) NSString *buyContractRowProject;
/**
 * 科目分配类别
 *
 *
 */
@property (nonatomic, copy) NSString *projectPickType;
/**
 * 物料
 *
 *
 */
@property (nonatomic, copy) NSString *materiel;
/**
 * 短文本
 *
 *
 */
@property (nonatomic, copy) NSString *shortText;
/**
 * 采购订单数量
 *
 *
 */
@property (nonatomic, copy) NSString *buyBillQuantity;
/**
 * 基本计量单位
 *
 *
 */
@property (nonatomic, copy) NSString *basicUtils;
/**
 * 净价
 *
 *
 */
@property (nonatomic, copy) NSString *netPrice;
/**
 * 货币
 *
 *
 */
@property (nonatomic, copy) NSString *currency;
/**
 * 物料组
 *
 *
 */
@property (nonatomic, copy) NSString *materielGroup;
/**
 * 工厂
 *
 *
 */
@property (nonatomic, copy) NSString *factory;
/**
 * 订单
 *
 *
 */
@property (nonatomic, copy) NSString *orderBill;
/**
 * 资产
 *
 *
 */
@property (nonatomic, copy) NSString *asset;
/**
 * 次级编号
 *
 *
 */
@property (nonatomic, copy) NSString *secondaryCode;
/**
 * 需求跟踪号
 *
 *
 */
@property (nonatomic, copy) NSString *needFollowingBill;
/**
 * 货物收据标识
 *
 *
 */
@property (nonatomic, copy) NSString *goodsReceiveSign;
/**
 * SLED的期间标识
 *
 *
 */
@property (nonatomic, copy) NSString *SLEDSign;
/**
 * 物料开票周期
 *
 *
 */
@property (nonatomic, copy) NSString *materielTicketCycle;
/**
 * 总账账目
 *
 *
 */
@property (nonatomic, copy) NSString *generalLedgerAccounts;
/**
 * 成本中心
 *
 *
 */
@property (nonatomic, copy) NSString *costCenter;
/**
 * 交货日期
 *
 *
 */
@property (nonatomic, copy) NSString *deliveryTime;
/**
 * 框架协议
 *
 *
 */
@property (nonatomic, copy) NSString *frameContract;
/**
 * 主要协议项目
 *
 *
 */
@property (nonatomic, copy) NSString *mainContractProject;
/**
 * 采购凭证
 *
 *
 */
@property (nonatomic, copy) NSString *buyEvidence;
/**
 * 项目
 *
 *
 */
@property (nonatomic, copy) NSString *project;
/**
 * 消息
 *
 *
 */
@property (nonatomic, copy) NSString *fnews;
@end /* interface POBill */



/**
 *  订油单。
 
 @author wsx
 @since 0.1
 
 */
@interface OrderBill : BasicEnterpriseBill2
/**
 * 所属业主公司
 *
 *
 */
@property (nonatomic, strong) UCN *org;
/**
 * 状态
 *
 * 取值: ORDERBILLSTATE_INITIAL, ORDERBILLSTATE_SUBMIT, ORDERBILLSTATE_CANCELED, ORDERBILLSTATE_SHIPPING, ORDERBILLSTATE_SHIPPED, ORDERBILLSTATE_ACCOMPLISHED,
 */
@property (nonatomic, copy) NSString *state;
/**
 * 油站
 *
 *
 */
@property (nonatomic, strong) UCN *store;
/**
 * 申请数量
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *quantity;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 订单明细
 * @see OrderBillDtl
 *
 */
@property (nonatomic, strong) NSArray<OrderBillDtl> *dtls;
/**
 * 经营方式
 *
 * 取值: OPERATINGTYPE_SELFSUPPORT, OPERATINGTYPE_LEAGUE,
 */
@property (nonatomic, copy) NSString *operatingType;
/**
 * 价格
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *price;
/**
 * 配送区域
 *
 *
 */
@property (nonatomic, strong) UCN *deliveryArea;
@end /* interface OrderBill */



/**
 *  承运信息
 
 @author cyy24
 @since 0.1
 
 */
@interface CarryInfo : BasicEnterpriseBill2
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *depot;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *store;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *fueler;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *carrier;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *price;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger level;
@end /* interface CarryInfo */



/**
 *  建仓申请单。
 
 @author wsx
 @since 0.1
 
 */
@interface DepotRequestBill : BasicEnterpriseBill2
/**
 * 状态
 *
 * 取值: DEPOTREQUESTBILLSTATE_INITIAL, DEPOTREQUESTBILLSTATE_SUBMIT, DEPOTREQUESTBILLSTATE_CANCELED, DEPOTREQUESTBILLSTATE_EFFECTIVED, DEPOTREQUESTBILLSTATE_ACCOMPLISHED,
 */
@property (nonatomic, copy) NSString *state;
/**
 * 类型
 *
 * 取值: DEPOTTYPE_GENERAL, DEPOTTYPE_SPECIAL,
 */
@property (nonatomic, copy) NSString *type;
/**
 * 配送区域
 *
 *
 */
@property (nonatomic, strong) UCN *deliveryArea;
/**
 * 建仓单位
 *
 *
 */
@property (nonatomic, strong) UCN *org;
/**
 * 油品
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * 配送时间
 *
 *
 */
@property (nonatomic, strong) DateTimeRange *deliveryTime;
/**
 * 申请价格
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *reqPrice;
/**
 * 申请数量
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *quantity;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
@end /* interface DepotRequestBill */



/**
 *  合约
 
 @author cyy24
 @since 0.1
 
 */
@interface ContractNumber : BasicEnterpriseBill2
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *fueler;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *deliveryArea;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *minQuantity;
@end /* interface ContractNumber */



/**
 *  建仓单。
 
 <p>
 建仓单来源于建仓申请单。
 
 @author Debenson
 @since 0.1
 
 */
@interface DepotInv : BasicEnterpriseBill2
/**
 * (no documentation provided)
 *
 * 取值: DEPOTTYPE_GENERAL, DEPOTTYPE_SPECIAL,
 */
@property (nonatomic, copy) NSString *type;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *depotBillUuid;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *depotBillNumber;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *org;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) DateTimeRange *deliveryTime;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *total;
@end /* interface DepotInv */



/**
 *  建仓单。
 
 <p>
 建仓单来源于建仓申请单。
 
 @author Debenson
 @since 0.1
 
 */
@interface DepotBill : BasicEnterpriseBill2
/**
 * 状态
 *
 * 取值: DEPOTBILLSTATE_INITIAL, DEPOTBILLSTATE_SUBMIT, DEPOTBILLSTATE_CANCELED, DEPOTBILLSTATE_EFFECTIVED, DEPOTBILLSTATE_ACCOMPLISHED,
 */
@property (nonatomic, copy) NSString *state;
/**
 * 类型
 *
 * 取值: DEPOTTYPE_GENERAL, DEPOTTYPE_SPECIAL,
 */
@property (nonatomic, copy) NSString *type;
/**
 * 建仓单
 *
 *
 */
@property (nonatomic, strong) DepotRequestBill *requestBill;
/**
 * 建仓单位
 *
 *
 */
@property (nonatomic, strong) UCN *org;
/**
 * 配送区域
 *
 *
 */
@property (nonatomic, strong) UCN *deliveryArea;
/**
 * 油品
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * 配送时间范围
 *
 *
 */
@property (nonatomic, strong) DateTimeRange *shipTime;
/**
 * 建仓价格
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *price;
/**
 * 建仓数量（吨）
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *quantity;
/**
 * 建仓金额
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *amount;
/**
 * 付款时间范围
 *
 *
 */
@property (nonatomic, strong) DateTimeRange *payTime;
/**
 * 付款明细
 * @see DepotBillPayDtl
 *
 */
@property (nonatomic, strong) NSArray<DepotBillPayDtl> *payDtls;
/**
 * 配送明细
 * @see DepotPickingDtl
 *
 */
@property (nonatomic, strong) NSArray<DepotPickingDtl> *pickingDtls;
/**
 * 备注
 *
 *
 */
@property (nonatomic, copy) NSString *remark;
/**
 * 未付金额
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *unpayAmount;
/**
 * 未增加库存数
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *undepotInv;
/**
 * 已缴纳保证金额
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *payMarginAmount;
/**
 * 剩余库存
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *total;
@end /* interface DepotBill */



/**
 *  合约日志
 
 @author cyy24
 @since 0.1
 
 */
@interface ContractLog : BasicEnterpriseBill2
/**
 * (no documentation provided)
 *
 * 取值: CONTRACTLOGACTIONTYPE_ADD, CONTRACTLOGACTIONTYPE_SUB,
 */
@property (nonatomic, copy) NSString *actionType;
/**
 * (no documentation provided)
 *
 * 取值: CONTRACTLOGQUANTITYTYPE_VIRTUAL, CONTRACTLOGQUANTITYTYPE_REAL,
 */
@property (nonatomic, copy) NSString *quantityType;
/**
 * (no documentation provided)
 *
 * 取值: CONTRACTLOGSOURCETYPE_PICKINGBILL, CONTRACTLOGSOURCETYPE_RECEIVEBILL,
 */
@property (nonatomic, copy) NSString *sourceType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *contractBillNumber;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *sourceBillNumber;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *beforeTotal;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *subTotal;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *nowTotal;
/**
 * (no documentation provided)
 *
 * 取值: BILLSTATE_INITIAL, BILLSTATE_SUBMIT, BILLSTATE_ACCOMPLISHED,
 */
@property (nonatomic, copy) NSString *billState;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *store;
/**
 * (no documentation provided)
 *
 * 取值: OPERATINGTYPE_SELFSUPPORT, OPERATINGTYPE_LEAGUE,
 */
@property (nonatomic, copy) NSString *operatingType;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *depot;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, copy) NSString *provider;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *fueler;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *carrier;
@end /* interface ContractLog */



/**
 *  合约
 
 @author cyy24
 @since 0.1
 
 */
@interface Contract : BasicEnterpriseBill2
/**
 * (no documentation provided)
 *
 * 取值: CONTRACTSTATE_SAVE, CONTRACTSTATE_SUBMIT, CONTRACTSTATE_CLOSE,
 */
@property (nonatomic, copy) NSString *state;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *fueler;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *deliveryArea;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) UCN *item;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *quantity;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, strong) NSDecimalNumber *realQuantity;
/**
 * (no documentation provided)
 *
 *
 */
@property (nonatomic, assign) NSInteger level;
@end /* interface Contract */


