//
//  TimeSelectViewController.m
//  total
//
//  Created by 曹云霄 on 16/6/23.
//  Copyright © 2016年 free. All rights reserved.
//

#import "TimeSelectViewController.h"

@interface TimeSelectViewController ()

@end

@implementation TimeSelectViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupDatePickerView];
}

#pragma mark -设置pickerView
- (void)setupDatePickerView
{
    self.datePickerView.date = self.defaultDate;
    self.datePickerView.minimumDate = [GTOCommonTools dateWithString:[GTOCommonTools GetCurrenttime]];
    [self.datePickerView addTarget:self action:@selector(pickerViewisChange:) forControlEvents:UIControlEventValueChanged];
}

#pragma mark -监听变化
- (void)pickerViewisChange:(UIDatePicker *)pickerView
{
    if (self.returnSelectTime) {
        self.returnSelectTime([self dateAsString:pickerView.date]);
    }
}

- (NSString*)dateAsString:(NSDate*)date {
    NSDateFormatter *formatter=[[NSDateFormatter alloc]init];
    formatter.dateFormat=@"yyyy-MM-dd";
    NSString *timeStr=[formatter stringFromDate:date];
    return timeStr;
    
}
@end
