//
//  HttpRequestManager.h
//  total
//
//  Created by 曹云霄 on 16/6/24.
//  Copyright © 2016年 Delevin. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  成功返回
 */
typedef void (^returnValueBlock)(id returnValue);

/**
 *  失败返回
 */
typedef void (^failedValueBlock)(NSError *failed);

/**
 *  请求类型
 */
typedef NS_ENUM(NSInteger,RequestType){
    
    NetworkRequestWithPOST = 0, //POST
    NetworkRequestWithGET       //GET
    
};


@interface HttpRequestManager : NSObject


/**
 *  网络请求
 *
 *  @param requestString 请求链接
 *  @param requestType   POST or GET
 *  @param parameter     JSONModel
 *  @param success       成功返回
 *  @param failed        失败返回
 */
+ (void)requestNetworkwithURL:(NSString *)requestString
              withRequestType:(RequestType)requestType
                withParameter:(id)parameter
                  withSuccess:(returnValueBlock)success
                   withFailed:(failedValueBlock)failed;

@end
