//
//  GTORepairListCellContentView.m
//  total
//
//  Created by freecui on 15/10/29.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTORepairListCellContentView.h"
#import "GTORepair.h"
@interface GTORepairListCellContentView ()
@property (strong, nonatomic) IBTUILabel *m_repairTitleLabel;
@property (strong, nonatomic) IBTUILabel *m_billNumberLabel;
@property (strong, nonatomic) IBTUILabel *m_storeNameLabel;//油站
@property (strong, nonatomic) IBTUILabel *m_stateLabel;//完成状态
@property (strong, nonatomic) IBTUILabel *m_stateValueLabel;//完成状态
@property (strong, nonatomic) IBTUILabel *m_repairDateLabel;//开始时间
@end
@implementation GTORepairListCellContentView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    
    self.m_repairTitleLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:20] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_billNumberLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_storeNameLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_stateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_stateValueLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_repairDateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];


 
    
    [self addSubview:_m_repairTitleLabel];
    [self addSubview:_m_billNumberLabel];
    [self addSubview:_m_storeNameLabel];
    [self addSubview:_m_stateLabel];
    [self addSubview:_m_stateValueLabel];
    [self addSubview:_m_repairDateLabel];

    
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_repairTitleLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH + 10,
    };
    _m_billNumberLabel.frame = (CGRect){
        .origin.x = _m_repairTitleLabel.x,
        .origin.y = _m_repairTitleLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    _m_storeNameLabel.frame = (CGRect){
        .origin.x = _m_repairTitleLabel.x,
        .origin.y = _m_billNumberLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = _m_billNumberLabel.width,
        .size.height = lblH,
    };
    _m_stateLabel.frame = (CGRect){
        .origin.x =_m_repairTitleLabel.x,
        .origin.y = _m_storeNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = 80,
        .size.height = lblH,
    }; [_m_stateLabel sizeToFit];
    _m_stateValueLabel.frame = (CGRect){
        .origin.x =_m_stateLabel.right,
        .origin.y = _m_storeNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = self.width - _m_stateLabel.right,
        .size.height = lblH,
    };
    _m_repairDateLabel.frame = (CGRect){
        .origin.x = _m_repairTitleLabel.x,
        .origin.y = _m_stateLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };

}
@end


@implementation GTORepairListCellContentView (configure)

- (void)updateWithRepair: (GTORepair *)repair {
    self.m_repairTitleLabel.text = [NSString stringWithFormat:@"%@ ",repair.title];
    self.m_billNumberLabel.text = [NSString stringWithFormat:@"维修单号：%@ ",repair.billnumber];
    self.m_storeNameLabel.text = [NSString stringWithFormat:@"油站名称：%@ ",repair.store_name];
    self.m_stateLabel.text = [NSString stringWithFormat:@"报修状态:  "];
    self.m_stateValueLabel.text = [GTOCommonTools repairStateChineseWithEnglish:repair.state];
    self.m_stateValueLabel.textColor = [GTOCommonTools textColorWithState:repair.state];
    self.m_repairDateLabel.text = [NSString stringWithFormat:@"维修时间：%@",repair.repairDate ];
    [self layoutSubviews];
}
@end
