//
//  GTORepairAddPhotoView.m
//  total
//
//  Created by freecui on 15/11/4.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTORepairAddPhotoView.h"
#import "ICRAttachmentView.h"
#import "LBorderView.h"
#define LEFT_MARGIN                 (15.0f)
#define HELPER_ATTACH_HEIGHT        (50)
@interface GTORepairAddPhotoView ()
{
    BOOL m_bIsResult;
}
//@property (strong, nonatomic) IBTUILabel *m_titleLable;
@property (strong, nonatomic) LBorderView *m_attachBGView;
@end
@implementation GTORepairAddPhotoView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    
    return self;
}
- (instancetype)initWithFrame:(CGRect)frame isResult:(BOOL)bIsResult {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    m_bIsResult = bIsResult;
    
    [self initSubViews];
    
    return self;
}
- (void)initSubViews {
    
     self.backgroundColor = [UIColor whiteColor];
//    self.m_titleLable = [[IBTUILabel alloc] init];
//    _m_titleLable.font = [UIFont systemFontOfSize:14];
//    _m_titleLable.textColor = ICR_TINTCOLOR;
//    _m_titleLable.text = @"添加图片";
//    [self addSubview:_m_titleLable];
    
    self.m_attachBGView = [[LBorderView alloc] init];
    _m_attachBGView.cornerRadius = IBT_DEFAULT_CORNER_RADIUS;
    _m_attachBGView.borderType = BorderTypeDashed;
    _m_attachBGView.borderWidth = .5f;
    _m_attachBGView.borderColor = [UIColor lightGrayColor];
    _m_attachBGView.dashPattern = 4;
    _m_attachBGView.spacePattern = 2;
    [self addSubview:_m_attachBGView];
    
    if (!m_bIsResult) {
        self.m_photoAttachView = [[ICRAttachmentView alloc] initWithType:kAttViewImage];
        _m_photoAttachView.m_uiMaxAttCount = 1;
        
        [_m_attachBGView addSubview:_m_photoAttachView];
        
    }
    
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat fH = 35;
    CGFloat fW = self.width - 2 * LEFT_MARGIN;
    
//    _m_titleLable.frame = (CGRect){
//        .origin.x = LEFT_MARGIN,
//        .origin.y = 0,
//        .size.width = fW ,
//        .size.height = fH
//    };
    _m_attachBGView.frame = (CGRect){
        .origin.x = LEFT_MARGIN,
        .origin.y = 0,
        .size.width = fW,
        .size.height = 60
    };
    
    CGFloat fGap = 5;
    if (_m_photoAttachView) {
        _m_photoAttachView.frame = (CGRect){
            .origin.x = fGap,
            .origin.y = 0,
            .size.width =  _m_attachBGView.width - 2 * fGap,
            .size.height = HELPER_ATTACH_HEIGHT
        };
    }

}
@end
