//
//  GTOLicenceListCellContentView.m
//  total
//  报修单详情处显示的简单的许可证明细
//  Created by freecui on 15/10/30.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOLicenceListSimpleCellContentView.h"
#import "GTOLicence.h"
@interface GTOLicenceListSimpleCellContentView ()
//@property (strong, nonatomic) IBTUILabel *m_repairTitleLabel;
@property (strong, nonatomic) IBTUILabel *m_billNumberLabel;
@property (strong, nonatomic) IBTUILabel *m_storeNameLabel;//油站
@property (strong, nonatomic) IBTUILabel *m_stateLabel;//完成状态
@property (strong, nonatomic) UIImageView *m_riskImgView;
//@property (strong, nonatomic) IBTUILabel *m_repairDateLabel;//开始时间
@end
@implementation GTOLicenceListSimpleCellContentView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    
    //self.m_repairTitleLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:20] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_billNumberLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_storeNameLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_stateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    //self.m_repairDateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_riskImgView = [[UIImageView alloc]init];
    
    
    
    //[self addSubview:_m_repairTitleLabel];
    [self addSubview:_m_billNumberLabel];
    [self addSubview:_m_storeNameLabel];
    [self addSubview:_m_stateLabel];
    [self addSubview:_m_riskImgView];
   // [self addSubview:_m_repairDateLabel];
    
    
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
//    _m_repairTitleLabel.frame = (CGRect){
//        .origin.x = GTO_LEFT_PADDING,
//        .origin.y = GTO_TOP_VERTICAL_PADDING,
//        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
//        .size.height = lblH + 10,
//    };
    _m_billNumberLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    CGFloat leftX = _m_billNumberLabel.x;
    _m_storeNameLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_billNumberLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = _m_billNumberLabel.width,
        .size.height = lblH,
    };
    _m_stateLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_storeNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = self.width,
        .size.height = lblH,
    }; [_m_stateLabel sizeToFit];
    
    CGFloat imgW = 40;
    _m_riskImgView.frame = (CGRect){
        .origin.x = self.width - imgW,
        .origin.y = 0,
        .size.width = imgW,
        .size.height = imgW,
    };
//    _m_repairDateLabel.frame = (CGRect){
//        .origin.x = leftX,
//        .origin.y = _m_stateLabel.bottom + GTO_VERTICAL_PADDING,
//        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
//        .size.height = lblH,
//    };
    
}
@end


@implementation GTOLicenceListSimpleCellContentView (configure)

- (void)updateWithLicence:(GTOLicence *)licence {
   // self.m_repairTitleLabel.text = [NSString stringWithFormat:@"许可证类型：%@ ",licence.licenceType];
    self.m_billNumberLabel.text = [NSString stringWithFormat:@"许可证单号：%@ ",licence.billnumber];
    self.m_storeNameLabel.text = [NSString stringWithFormat:@"油站名称：%@ ",licence.store_name];
    self.m_stateLabel.text = [NSString stringWithFormat:@"许可证状态: %@",[GTOCommonTools licenceStateChineseWithEnglish:licence.state] ];
   // self.m_repairDateLabel.text = [NSString stringWithFormat:@"申请时间：%@",licence.requestDate ];
    if ([licence.riskGrade isEqualToString:@"高"]) {
        self.m_riskImgView.image = [UIImage imageNamed:@"licence_hight"];
    } else {
        self.m_riskImgView.image = [UIImage imageNamed:@"licence_middle"];
    }
    
}
@end



