//
//  GTOLicenceBoltView.m
//  total
//
//  Created by freecui on 15/10/30.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOPioneeringBoltView.h"

#import "MaskCell.h"
#define TableHeight 45
#define LeftMargin 80
#define TotalHeight 224
#define LeftHeight 44
#define BottomHeight 50

@interface GTOPioneeringBoltView ()<UITextFieldDelegate>
{
    UIView *_leftView;
    UIButton *_currentBtn;
    NSIndexPath *_currentIndexPath;
    
    UIView *_titleLikeView;
    UIView *_nameLikeView;
    
    NSString *_state;
    UIButton *_clearBtn;
}
@property (nonatomic,strong)NSString *state;
@property (nonatomic,strong)NSString *titleLike;


@end

@implementation GTOPioneeringBoltView

- (instancetype)initWithFrame:(CGRect)frame state:(NSString *)state titleLike:(NSString *)titleLike {
    self = [super initWithFrame:frame];
    if (self) {
        self.state = state;
        self.titleLike = titleLike;
        [self createRightView];
        [self createView];
        [self preferData];
    }
    return self;
}

- (void)preferData{
    
    if ([self.state isEqualToString:@"none"]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    }else if ([self.state isEqualToString:GTO_PIONEERING_STATE_INITIAL]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:1 inSection:0];
    }else if ([self.state isEqualToString:GTO_PIONEERING_STATE_SUBMITTED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:2 inSection:0];
    } else {
        
    }

    
}
#pragma mark - 创建视图
- (void)createView
{

    _leftView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, LeftMargin,self.frame.size.height- BottomHeight)];
    [self addSubview:_leftView];
    NSArray *arr = @[@"按状态",@"标题",@"拓站人员"];
    for (NSInteger i = 0; i<arr.count; i++) {
        UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
        button.frame = CGRectMake(0, LeftHeight * i ,  LeftMargin ,LeftHeight);
        [button setTitle:arr[i] forState:UIControlStateNormal];
        [button setTitleColor:GXF_DETAIL_COLOR forState:UIControlStateNormal];
        if (i == 0) {
            button.enabled = NO;
            _currentBtn = button;
        }
        [button setBackgroundImage:[UIImage imageNamed:@"maskEnable"] forState:UIControlStateDisabled];
        [button setBackgroundImage:[UIImage imageNamed:@"mask"] forState:UIControlStateNormal];
        button.tag = 1001+i;
        [button addTarget:self action:@selector(leftBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [_leftView addSubview:button];
    }
    _clearBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    _clearBtn.frame = CGRectMake(0, CGRectGetMaxY(_leftView.frame), self.frame.size.width * 0.5, BottomHeight);
    [_clearBtn setTitle:@"清空选项" forState:UIControlStateNormal];
    [_clearBtn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    _clearBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [_clearBtn addTarget:self action:@selector(clearBolt) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_clearBtn];
    
    UIButton *sureBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    sureBtn.frame = CGRectMake(_clearBtn.right, CGRectGetMaxY(_leftView.frame), self.frame.size.width * 0.5, BottomHeight);
    [sureBtn setTitle:@"确定" forState:UIControlStateNormal];
    [sureBtn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    sureBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [sureBtn addTarget:self action:@selector(sureBolt) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:sureBtn];
}


- (void)p_createOneRightViewWithView: (UIView *)view forViewFrame: (CGRect)viewFrame
                       forLabelFrame: (CGRect)lblFrame
                           labelText: (NSString *)lblText
                           textField: (UITextField *)textField forTextFieldFrame: (CGRect)textFieldFrame
                textFieldPlaceholder: (NSString *)placeholder {
    
    view = [[UIView alloc]initWithFrame: viewFrame];
    view.backgroundColor = [UIColor whiteColor];
    [self addSubview:view];
    UILabel *titleLabel = [[UILabel alloc]initWithFrame:lblFrame];
    titleLabel.font = GXF_FIFTEENTEN_SIZE;
    titleLabel.text = lblText;//@"类似于：";
    [view addSubview:titleLabel];
    textField = [[UITextField alloc]initWithFrame:textFieldFrame];
    textField .textAlignment = NSTextAlignmentLeft;
    textField .textColor = GXF_CONTENT_COLOR;
    textField .placeholder = placeholder;//@"输入类似报修单号";
    textField .borderStyle = UITextBorderStyleRoundedRect;
    textField .font = GXF_FIFTEENTEN_SIZE;
    textField .returnKeyType = UIReturnKeyDone;
    textField .delegate = self;
    [view addSubview:textField];
    if ([placeholder isEqualToString:@"输入标题类似于"]) {
        _titleLikeView = view;
        self.titleFiled = textField;
    }else
    {
        _nameLikeView = view;
        self.nameField = textField;
    }
}

- (void)createRightView{
    
    CGRect viewRect = CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight);
    CGRect lblRect = CGRectMake(10, 20, (ScreenSize.width - LeftMargin - 10*2), 20);
    CGRect textFRect = CGRectMake(10, 20 + 20 + 10, (ScreenSize.width - LeftMargin - 10*2), 30);
    [self p_createOneRightViewWithView:_titleLikeView forViewFrame:viewRect forLabelFrame:lblRect labelText:@"类似于：" textField:self.titleFiled forTextFieldFrame:textFRect textFieldPlaceholder:@"输入标题类似于"];
    [self p_createOneRightViewWithView:_nameLikeView forViewFrame:viewRect forLabelFrame:lblRect labelText:@"类似于：" textField:self.nameField forTextFieldFrame:textFRect textFieldPlaceholder:@"输入名称类似于"];
    self.tableView = [[UITableView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self addSubview:self.tableView];
    
}
- (void)leftBtnClick:(UIButton *)btn{
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;
    [self keyBoardHidden];
    switch (btn.tag) {
        case 1001://状态
        {
            self.tableView.hidden = NO;
            _titleLikeView.hidden = YES;
            _nameLikeView.hidden = YES;
        }
            break;
        case 1002://条件二
        {
            self.tableView.hidden = YES;
            _titleLikeView.hidden = NO;
            _nameLikeView.hidden = YES;
        }
            break;
        case 1003://拓站人员名称搜索
        {
            self.tableView.hidden = YES;
            _titleLikeView.hidden = YES;
            _nameLikeView.hidden = NO;
        }
            break;
        default:
            break;
    }
}

- (void)clearBolt{
    if (_titleFiled.text.length > 0) {
        _titleFiled.text = @"";
    }
    
    if (_currentIndexPath) {
        _currentIndexPath = nil;
        [self.tableView reloadData];
    }
    if ([self.delegate respondsToSelector:@selector(clearBoltInformation)]) {
        [self.delegate clearBoltInformation];
    }
}
- (void)sureBolt {
    if ([self.delegate respondsToSelector:@selector(sureBoltInformation)]) {
        [self.delegate sureBoltInformation];
    }
}
#pragma mark - 协议
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskID";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth: ScreenSize.width - 80 totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        cell.Commitbtn.hidden = YES;
        [cell setTitleStr:self.dataArr[indexPath.row]];
        
    }
    if (_currentIndexPath) {
        if (indexPath.row == _currentIndexPath.row) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    //获取选中的cell
    MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
    currentCell.Commitbtn.hidden = YES;
    MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
    cell.Commitbtn.hidden = NO;
    _currentIndexPath = indexPath;
    
    NSString *stateStr = @"";
    if (indexPath.row == 0) {
        stateStr = @"none";
    }else if(indexPath.row == 1){
        stateStr = GTO_PIONEERING_STATE_INITIAL;
    }else if(indexPath.row == 2){
        stateStr = GTO_PIONEERING_STATE_SUBMITTED;
    }else {
        
    }
    [self.delegate getBoltValueSelectRow:stateStr];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self keyBoardHidden];
    return YES;
}
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event{
    [self keyBoardHidden];
}
- (void)keyBoardHidden{
    [self.titleFiled resignFirstResponder];

}

- (void)textFieldDidEndEditing:(UITextField *)textField{
    if ([textField isEqual:self.titleFiled]) {//标题
        if ([self.delegate respondsToSelector:@selector(getTitleLike:)]) {
            [self.delegate getTitleLike:self.titleFiled.text];
        }
    }
    if ([textField isEqual:self.nameField]){//拓站人员
        if ([self.delegate respondsToSelector:@selector(getNameLike:)]) {
            [self.delegate getNameLike:textField.text];
        }
    }
}


@end
