//
//  ICRQAViewController.m
//  Cruiser
//  回复类
//  Created by Xummer on 6/7/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//  GTO

#import "GTOQAViewController.h"
#import "GTOQuestionManager.h"

@interface GTOQAViewController ()<UITextViewDelegate>

@property (strong, nonatomic) UILabel *m_questionLabel;
@property (strong, nonatomic) UITextView *m_answerTextView;
@end

@implementation GTOQAViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc]init];
    backItem.title = @"";
    self.navigationItem.backBarButtonItem = backItem;
    
//    self.c_helperView.m_inputTxtF.text = self.d_answer.resultContent;

    

}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)initScrollViewWithRect:(CGRect)rect {
    [super initScrollViewWithRect:rect];
    
    self.m_questionLabel = [[IBTUILabel alloc] init];
    _m_questionLabel.numberOfLines = 0;
    _m_questionLabel.font = [UIFont systemFontOfSize:17];
    _m_questionLabel.textColor = [UIColor grayColor];
//    _m_questionLabel.text = @"请将内容填写在【备注】框中";
    
    CGFloat fMargin = 12.0f;
    CGSize size = CGSizeMake(self.view.width - 2 * fMargin,CGFLOAT_MAX);
    size = [_m_questionLabel widthLimitedSizeThatFits:size];
    
    _m_questionLabel.frame = (CGRect){
        .origin.x = fMargin,
        .origin.y = 0,
        .size = size
    };
    
    [self.c_contentScrollView addSubview:_m_questionLabel];
    
    
    //answerTextView
    self.m_answerTextView = [[UITextView alloc] init];
    self.m_answerTextView.delegate = self;
    _m_answerTextView.font = [UIFont systemFontOfSize:17];
    _m_answerTextView.textColor = [UIColor grayColor];
    //    _m_questionLabel.text = @"请将内容填写在【备注】框中";
       _m_answerTextView.text = self.d_answer.resultContent;
    size = CGSizeMake(self.view.width - 2 * fMargin,100);
    if (self.d_notEdit) {
        _m_answerTextView.editable = NO;
//        _m_answerTextView.userInteractionEnabled = NO;
//        size = CGSizeMake(self.view.width - 2 * fMargin,CGFLOAT_MAX);
//        size = [_m_answerTextView widthLimitedSizeThatFits:size];
    }
    

    
    _m_answerTextView.frame = (CGRect){
        .origin.x = fMargin,
        .origin.y = _m_questionLabel.bottom + 20,
        .size = size
    };
   
    [self.c_contentScrollView addSubview:_m_answerTextView];
}

#pragma mark - UITextViewDelegate
- (void)textViewDidBeginEditing:(UITextView *)textView {
    
}
- (void)textViewDidChange:(UITextView *)textView {
    
}
#pragma mark - Actions
- (void)onNextBtnAction:(__unused id)sender {

    if (self.d_notEdit) {
        [super disMissSelf];
        return;
    }
//    if (self.c_helperView.m_inputTxtF.text.length <= 0) {
//        self.d_answer.bIsAnswered = NO;
//        return;
//    }
    

    if (self.self.m_answerTextView.text.length <= 0) {
        self.d_answer.bIsAnswered = NO;
        return;
    }
    
    self.d_answer.resultContent = self.m_answerTextView.text;//self.c_helperView.m_inputTxtF.text;
    self.d_answer.bIsAnswered = YES;
    self.d_answer.resultRemark = self.c_helperView.m_inputTxtF.text;
    GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
    UIViewController *qVC = [mgr questionViewControlAtIndex:self.d_questionIndex + 1];
        if (qVC) {
        [self PushViewController:qVC animated:YES];
    }
    else {
        [super disMissSelf];
        // [self openResultView];
    }
  

    [self.d_answer saveToDBWithHandleData:NULL
                                 complete:^{
                                     [IBTLoadingView hideHUDWithText:nil];
                                     
                                     
                                 }
                                     fail:^(NSError *error) {
                                         
                                         [IBTLoadingView hideHUDWithText:error.localizedDescription];
                                     }];
}


@end
