//
//  GTOPioneeringAddressInfoViewController.m
//  total
//
//  Created by freecui on 15/11/15.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOPioneeringAddressInfoViewController.h"
#import "GTOPioneeringAddressInfoView.h"
#import "GXFBottomView.h"
#import "GTOPioneering.h"
#import <BaiduMapAPI/BMapKit.h>
@interface GTOPioneeringAddressInfoViewController ()<GXFBottomViewDelegate>
@property (nonatomic, strong) GTOPioneering *d_pioneering;
@property (nonatomic, strong) BMKMapView *c_mapView;
@end

@implementation GTOPioneeringAddressInfoViewController
- (instancetype)initWithPioneering: (GTOPioneering *)pioneering {
    self = [super init];
    if (!self) {
        return nil;
    }
    self.d_pioneering = pioneering;
    return self;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"拓站信息";
    [self initSubViews];
}
- (void)initSubViews {

    CGFloat latitude = [_d_pioneering.latitude floatValue];
    CGFloat longitude = [_d_pioneering.longitude floatValue];
    CGRect rect = CGRectMake(0, 0, self.view.width, 120);
    GTOPioneeringAddressInfoView *addressInfo = [[GTOPioneeringAddressInfoView alloc]initWithFrame:rect];
    [addressInfo updateWithPioneering:_d_pioneering];
    [self.view addSubview:addressInfo];
    
    IBTUILabel *locationLbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(10, addressInfo.bottom + 10, 100, 20) text:@"签到位置" font:[UIFont systemFontOfSize:19] tintColor:GTO_BLUE_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    [locationLbl sizeToFit];
    IBTUILabel *locationValueLbl = [[IBTUILabel alloc]initWithFrame:CGRectMake(self.view.width - 185, locationLbl.y,180, locationLbl.height) text:[NSString stringWithFormat:@"坐标(%.6f,%.6f)",latitude,longitude] font:[UIFont systemFontOfSize:17] tintColor:[UIColor blackColor] backgroundColor:nil textAlignment:NSTextAlignmentRight]; //_d_pioneering.longitude,_d_pioneering.latitude
    [locationValueLbl sizeToFit];
    [self.view addSubview:locationLbl];
    [self.view addSubview:locationValueLbl];

    
    rect = CGRectMake(0, locationValueLbl.bottom,self.view.width, self.view.height - locationValueLbl.bottom - 64 - BottomViewHeight - 20);
    self.c_mapView = [[BMKMapView alloc]initWithFrame:rect];
    [self.view addSubview:_c_mapView];
    BMKPointAnnotation *pointAnnotation = [[BMKPointAnnotation alloc]init];
    CLLocationCoordinate2D coor;
    coor.latitude = latitude;
    coor.longitude = longitude;
    pointAnnotation.coordinate = coor;
    
    [_c_mapView addAnnotation:pointAnnotation];
    _c_mapView.showsUserLocation = YES;
    _c_mapView.centerCoordinate = CLLocationCoordinate2DMake(latitude, longitude);
    _c_mapView.zoomLevel = 17;
    
    GXFBottomView *bottomV = [[GXFBottomView alloc]initOneButtonWithFrame:CGRectMake(0, _c_mapView.bottom  +20, self.view.width, BottomViewHeight) buttonColor:GTO_RED_COLOR buttonTitle:@"返回"];
    bottomV.delegate = self;
    [self.view addSubview:bottomV];
    
}
#pragma GXFBottomViewDelegate
- (void)bottomView:(GXFBottomView *)bottomView oneButtonClicked:(UIButton *)oneBtn {
    [self PopViewControllerAnimated:YES];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}



@end
