//
//  ICRAttachmentView.m
//  Cruiser
//
//  Created by Xummer on 15/4/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GTOMutiPhotosView.h"
#import "ICRAttachTitleView.h"

#define ADD_BTN_WIDTH           (44.0f)
#define ATTVIEW_INNER_GAP       (5.0f)

@interface GTOMutiPhotosView ()
//{
//    ICRAttViewType m_eViewType;
//}
@property (strong, nonatomic) ICRAttachTitleView *m_titleView;

@end

@implementation GTOMutiPhotosView

#pragma mark - Life Cycle
//- (instancetype)initWithType:(ICRAttViewType)eType {
//    self = [super initWithFrame:CGRectZero];
//    if (!self) {
//        return nil;
//    }
//    
//    m_eViewType = eType;
//    
//    self.m_arrAttViews = [NSMutableArray array];
//    [self initSubviews];
//    
//    return self;
//}

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    self.m_arrAttViews = [NSMutableArray array];
    [self initSubviews];
    
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat fDelta = 10;
    
    _m_titleView.frame = (CGRect){
        .origin.x = 0,
        .origin.y = (self.height - ICRATTACH_TITLE_VIEW_HEIGHT) * .5f + fDelta,
        .size.width = ICRATTACH_TITLE_VIEW_WIDTH,
        .size.height = ICRATTACH_TITLE_VIEW_HEIGHT
    };
    
//    _m_addButton.frame = (CGRect){
//        .origin.x = self.width - ADD_BTN_WIDTH,
//        .origin.y = (self.height - ADD_BTN_WIDTH) * .5f + fDelta,
//        .size.width = ADD_BTN_WIDTH,
//        .size.height = ADD_BTN_WIDTH
//    };
    
    CGFloat fDx = _m_titleView.right + ATTVIEW_INNER_GAP;
    _m_scrollView.frame = (CGRect){
        .origin.x = fDx,
        .origin.y = 0,
        .size.width = self.width - fDx - ATTVIEW_INNER_GAP,// _m_addButton.left - fDx - ATTVIEW_INNER_GAP,
        .size.height = self.height
    };
}

#pragma mark - Public Method
- (void)addContentAttachmentView:(ICRAttachmentUnit *)attView {
    
    UIView *lastView = [_m_arrAttViews lastObject];
    CGFloat fX = (lastView ? lastView.right : 0) + ATTVIEW_INNER_GAP;
    attView.origin = (CGPoint){
        .x = fX,
        .y =  (_m_scrollView.height - attView.height) * .5f//_isDownImg ?(_m_scrollView.height ) * .5f : (_m_scrollView.height - attView.height) * .5f //
    };
    
    attView.m_uiAttachIndex = [_m_arrAttViews count];
//    attView.m_closeButton.tag = attView.m_uiAttachIndex;
//    [attView.m_closeButton addTarget:self action:@selector(onCloseButtonAction:)
//                    forControlEvents:UIControlEventTouchUpInside];
    
    [self.m_scrollView addSubview:attView];
    [self.m_arrAttViews addObject:attView];
    
    _m_scrollView.contentSize = CGSizeMake(attView.right + ATTVIEW_INNER_GAP, _m_scrollView.height);
    
    //[self checkIsReachedMaxCount];
}

//- (void)removeContentAttachmentViewAtIndex:(NSUInteger)uiIndex {
//    if (uiIndex < [_m_arrAttViews count]) {
//        ICRAttachmentUnit *unit = _m_arrAttViews[ uiIndex ];
//        [self removeContentAttachmentView:unit];
//    }
//}

//- (void)removeContentAttachmentView:(ICRAttachmentUnit *)attView {
//    //    [attView.m_closeButton removeFromSuperview];
//    [attView removeFromSuperview];
//    [_m_arrAttViews removeObject:attView];
//    
//    [self checkIsReachedMaxCount];
//    
//    [self relayoutContentView];
//}

//- (void)checkIsReachedMaxCount {
//    //    if (_m_uiMaxAttCount > 0) {
//    //        self.m_addButton.hidden = [_m_arrAttViews count] >= _m_uiMaxAttCount;
//    //    }
//}

//- (void)relayoutContentView {
//    NSUInteger uiIndex = 0;
//    
//    CGFloat fX = ATTVIEW_INNER_GAP;
//    for (ICRAttachmentUnit *attV in _m_arrAttViews) {
//        attV.m_uiAttachIndex = uiIndex++;
//        attV.m_closeButton.tag = uiIndex++;
//        attV.origin = (CGPoint){
//            .x = fX,
//            .y = (_m_scrollView.height - attV.height) * .5f
//        };
//        
//        fX = attV.right + ATTVIEW_INNER_GAP;
//        [attV updateCloseButton];
//    }
//    
//    _m_scrollView.contentSize = CGSizeMake(fX, _m_scrollView.height);
//}


#pragma mark - Private Method
- (void)initSubviews {
    self.m_titleView = [[ICRAttachTitleView alloc] init];
    [self addSubview:_m_titleView];
    
    self.m_scrollView = [[IBTUIScrollView alloc] init];
    [self addSubview:_m_scrollView];
    
//    self.m_addButton = [IBTUIButton buttonWithType:UIButtonTypeCustom];
//    [self addSubview:_m_addButton];
    
    self.m_arrAttViews = [NSMutableArray array];
    
    NSString *nsTitle = nil;
    NSString *nsIconName = nil;
    NSString *nsAddBtnName = nil;
    nsTitle = @"参考照片";//[IBTCommon localizableString:@"Add Photo"];
    nsIconName = @"AttachCamera";
    nsAddBtnName = @"AttachmentAddBtn";
//    switch (m_eViewType) {
//        case kAttViewImage:
//        {
//            nsTitle = @"参考照片";//[IBTCommon localizableString:@"Add Photo"];
//            nsIconName = @"AttachCamera";
//            nsAddBtnName = @"AttachmentAddBtn";
//        }
//            break;
//        case kAttViewTask:
//        {
//            nsTitle = @"关联任务";//[IBTCommon localizableString:@"Related Task"];
//            nsIconName = @"AttachCamera";
//            nsAddBtnName = @"AttachmentAddBtn";
//        }
//            break;
//        case kAttViewVoice:
//        {
//            nsTitle = @"录音";//[IBTCommon localizableString:@"Record"];
//            nsIconName = @"RecordIcon";
//            nsAddBtnName = @"AttachmentAddBtn";
//        }
//            break;
//        default:
//            break;
//    }
    
//    [_m_addButton setImage:[UIImage imageNamed:nsAddBtnName]
//                  forState:UIControlStateNormal];
    
    [_m_titleView updateWithTitle:nsTitle iconName:nsIconName];
}

//#pragma mark - Action
//- (void)onCloseButtonAction:(id)sender {
//    UIButton *closeBtn = sender;
//    
//    if ([_delegate respondsToSelector:@selector(attachmentView:removeContentAttachmentViewAtIndex:)]) {
//        [_delegate attachmentView:self removeContentAttachmentViewAtIndex:closeBtn.tag];
//    }
//    [self removeContentAttachmentViewAtIndex:closeBtn.tag];
//    
//    for(int i=0;i<self.m_arrAttViews.count;i++){
//        id view= self.m_arrAttViews[i];
//        if([view isKindOfClass:[ICRAttachmentUnit class]]){
//            ((ICRAttachmentUnit*)view).m_closeButton.tag = i;
//            
//        }
//    }
//    
//}

@end
