//
//  ICRQMutiSelectViewController.m
//  Cruiser
//
//  Created by Xummer on 6/7/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRQMutiSelectViewController.h"
#import "ICRQuestionManager.h"

static NSString *kCellID = @"cellID";

@interface ICRQMutiSelectViewController ()
<
    UITableViewDataSource,
    UITableViewDelegate
>

@property (strong, nonatomic) IBTTableView *m_tableView;
@property (strong, nonatomic) NSMutableArray *m_arrSelectedData;

@end

@implementation ICRQMutiSelectViewController

#pragma mark - Life Cycle

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.m_arrSelectedData = [[NSMutableArray alloc] initWithArray:self.m_answer.details];
    for (NSDictionary *dict in _m_arrSelectedData) {
        NSUInteger answer = [dict[ @"index" ] unsignedIntegerValue] ;
        if (answer >= 1) {
            NSIndexPath *indexP =
            [NSIndexPath indexPathForRow:answer - 1 inSection:0];
            [_m_tableView selectRowAtIndexPath:indexP animated:NO scrollPosition:UITableViewScrollPositionNone];
        }
        
    }
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method

- (void)initScrollViewWithRect:(CGRect)rect {
    
    self.m_tableView = [[IBTTableView alloc] initWithFrame:rect style:UITableViewStylePlain];
    _m_tableView.bHandleKeyboard = YES;
    _m_tableView.backgroundColor = [UIColor clearColor];
    _m_tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    _m_tableView.editing = YES;
    [_m_tableView registerClass:[IBTTableViewCell class] forCellReuseIdentifier:kCellID];
    _m_tableView.allowsMultipleSelectionDuringEditing = YES;
    _m_tableView.dataSource = self;
    _m_tableView.delegate = self;
    
    self.m_contentScrollView = _m_tableView;
    [self.view addSubview:_m_tableView];
    if (self.d_notEdit) {
        self.m_tableView.userInteractionEnabled = NO;
    }
}

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView
 numberOfRowsInSection:(NSInteger)section
{
    return self.m_arrOptions.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kCellID forIndexPath:indexPath];
    cell.backgroundColor = [UIColor clearColor];
    [self configureCell:cell forRowAtIndexPath:indexPath];
    
    return cell;
}

- (void)configureCell:(UITableViewCell *)cell
    forRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSDictionary *dicOptionItem = self.m_arrOptions[ indexPath.row ];
    cell.textLabel.text = [NSString stringWithFormat:@"%@. %@",[GTOCommonTools stringLetterWithNumber:indexPath.row],dicOptionItem[ @"value" ]];//选项内容：单选类，多选类和品类调查类使用
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView
didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSDictionary *dicOptionItem = self.m_arrOptions[ indexPath.row ];

    ICRAnswerDetail *dE = [ICRAnswerDetail DBObject];
    dE.index = [dicOptionItem[ @"index" ] unsignedIntegerValue];
    dE.uuid = [[ICRUserUtil sharedInstance] mobileID];
    dE.stringValue = dicOptionItem[ @"value" ];
    
    [self.m_arrSelectedData addObject:[dE dictForCommit]];
     self.m_answer.details = _m_arrSelectedData;
}

- (void)tableView:(UITableView *)tableView
didDeselectRowAtIndexPath:(NSIndexPath *)indexPath {
    
    for (NSDictionary *dict in _m_arrSelectedData) {
        NSUInteger uiAnswer = [dict[ @"index" ] unsignedIntegerValue];
        if (uiAnswer == indexPath.row + 1) {
            [_m_arrSelectedData removeObject:dict];
            break;
        }
    }
    self.m_answer.details = _m_arrSelectedData;
}

#pragma mark - Actions
- (void)onNextBtnAction:(__unused id)sender {
    if (self.d_notEdit) {
        [super disMissSelf];
        return;
    }
    
    if ([_m_arrSelectedData count] <= 0) {
        self.m_answer.bIsAnswered = NO;
        return;
    }
    
    self.m_answer.bIsAnswered = YES;
    
    
    self.m_answer.remark = self.m_helperView.m_inputTxtF.text;
    ICRQuestionManager *mgr = [ICRQuestionManager sharedManager];
    UIViewController *qVC = [mgr questionViewControlAtIndex:self.m_uiIndex + 1];
    if (qVC) {
        [self PushViewController:qVC animated:YES];
    }
    else {
        [super disMissSelf];
//        [self openResultView];
    }
    
    [self.m_answer saveToDBWithHandleData:NULL complete:NULL fail:NULL];
}

@end
