//
//  GTOLicenceResultHeaderContentView.m
//  total
//
//  Created by freecui on 15/11/3.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOButtonHeaderContentView.h"

@interface GTOButtonHeaderContentView ()
@property (strong, nonatomic) IBTUILabel *m_titleLabel;
@property (strong, nonatomic) UIImageView *m_imgV;
@end
@implementation GTOButtonHeaderContentView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    
    self.m_titleLabel = [[IBTUILabel alloc]initWithfont:[UIFont systemFontOfSize:20] tintColor:GTO_GRAY_TINT_COLOR backgroundColor:XXFBgColor textAlignment:NSTextAlignmentLeft];
    
    self.m_btn = [IBTUIButton buttonWithTitle:@"" textColor:GTO_GRAY_TINT_COLOR textFont:[UIFont systemFontOfSize:17] backColor: XXFBgColor ];
    [self.m_btn.titleLabel setTextAlignment:NSTextAlignmentRight];
    self.m_imgV = [[UIImageView alloc]initWithImage:[UIImage imageNamed:@"CellCustomArrow"]];
    self.m_imgV.contentMode = UIViewContentModeScaleAspectFit;
    [self addSubview:_m_titleLabel];
    [self addSubview:_m_btn];
    [self addSubview:_m_imgV];
    
}

- (void)layoutSubviews {
    CGFloat lblH = 27;
    _m_titleLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = (SCREEN_SIZE.width - 2 *GTO_LEFT_PADDING) * 0.5,
        .size.height = lblH,
    };
    
    _m_btn.frame = (CGRect){
        .origin.x = self.width - GTO_LEFT_PADDING - 20 - 100,
        .origin.y = _m_titleLabel.y,
        .size.width = 100,
        .size.height = lblH ,
    };

    _m_imgV.frame = (CGRect){
        .origin.x = _m_btn.right,
        .origin.y = _m_titleLabel.y,
        .size.width = 20,
        .size.height = 20,
    };
    
}

@end

@implementation GTOButtonHeaderContentView (configure)
- (void)updateWithTitleLabelText: (NSString *)title
              andButtonLabelText: (NSString *)btnText {
    _m_titleLabel.text = title;
    [_m_btn setTitle:btnText forState:UIControlStateNormal];
    [self layoutSubviews];
}
@end

