//
//  GTOAppViewControllerManager.m
//  total
//
//  Created by freecui on 15/9/9.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "ICRAppViewControllerManager.h"
#import "ICRUIAppearance.h"

#import "IBTUINavigationController.h"
#import "ICRLoginViewController.h"

#import "GTOHomeViewController.h"
#import "GTOBusinessViewController.h"
#import "GTOMeViewController.h"
#import "BusinessViewController.h"

@interface ICRAppViewControllerManager ()
<
UITabBarControllerDelegate
>
@end
@implementation ICRAppViewControllerManager

+ (UINavigationController *)getCurrentNavigationController {
    return nil;
}

+ (IBTTabBarController *)getTabBarController {
    return [[self getAppViewControllerManager] getTabBarController];
}

+ (ICRAppViewControllerManager *)getAppViewControllerManager {
    static ICRAppViewControllerManager *_sharedMgr = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
        _sharedMgr = [[ICRAppViewControllerManager alloc] initWithWindow:keyWindow];
    });
    
    return _sharedMgr;
}

- (id)initWithWindow:(UIWindow *)window {
    self = [super init];
    if (!self) {
        return nil;
    }


    [ICRUIAppearance CustomAppearance];
    
    m_window = window;
    m_arrTabBarBaseViewController = [NSMutableArray array];
    m_arrViewController = [NSMutableArray array];
    
    // Automatic login
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    //if ([userUtil isLogin]) {
    if (userUtil.f_user_loginName && !userUtil.f_isLogout) {
        [self openMainFrame];
    }
    else {
        [self openFirstView];
    }

    return self;
}

- (void)dealloc {
    m_window = nil;
    m_arrViewController = nil;
    m_arrTabBarBaseViewController = nil;
    m_tabbarController = nil;
}
#pragma mark - Public Method
- (CGSize)getRootViewSize {
    return m_window.rootViewController.view.frame.size;
}

- (IBTTabBarController *)getTabBarController {
    return m_tabbarController;
}

- (NSUInteger)getCurTabBarIndex {
    return m_tabbarController.selectedIndex;
}

- (UIViewController *)getTabBarBaseViewController:(CRTapBarItemIndex)index {
    if (index > kTOMe || index > [m_arrTabBarBaseViewController count]) {
        return nil;
    }
    
    return m_arrTabBarBaseViewController[ index ];
}

- (void)openFirstView {
    if ([m_window.rootViewController isKindOfClass:[IBTUINavigationController class]]) {
        IBTUINavigationController *navCtrl = (IBTUINavigationController *)m_window.rootViewController;
        
        if ([[navCtrl.viewControllers lastObject] isKindOfClass:[ICRLoginViewController class]]) {
            return;
        }
        else if ([[navCtrl.viewControllers firstObject] isKindOfClass:[ICRLoginViewController class]]) {
            [navCtrl popToRootViewControllerAnimated:YES];
            return;
        }
    }
    
    ICRLoginViewController *loginCtrl = [[ICRLoginViewController alloc] init];
    IBTUINavigationController *naviCtrl = [[IBTUINavigationController alloc] initWithRootViewController:loginCtrl];
    naviCtrl.navigationBarHidden = YES;
    
    m_window.rootViewController = naviCtrl;
}
- (void)openMainFrame {
    if (m_window.rootViewController &&
        m_window.rootViewController == m_tabbarController) {
        return;
    }
    
    [m_arrTabBarBaseViewController removeAllObjects];
    [m_arrViewController removeAllObjects];
    
    [self createHomeViewController];
    [self createBusinessController];
    [self createMeController];

    if (!m_tabbarController) {
        m_tabbarController = [[IBTTabBarController alloc] init];
        m_tabbarController.delegate = self;
    }
    
    [m_tabbarController setViewControllers:m_arrViewController];
    [m_tabbarController setSelectedIndex:kTOHome];
    
    m_window.rootViewController = m_tabbarController;
}
#pragma mark - Actions
- (void)doLogout {
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    [userUtil logout];
    //[ICRDataBaseController CleanUpDBPath];
    
    [self openFirstView];
}

#pragma mark - Creation
- (void)createHomeViewController {
    
    NSString *nsTitle = ACETapBarItemNames[ kTOHome ];
    
    GTOHomeViewController *homeVCtrl = [[GTOHomeViewController alloc] init];
    [m_arrTabBarBaseViewController addObject:homeVCtrl];
    homeVCtrl.title = [IBTCommon localizableString:nsTitle];
    
    IBTUINavigationController *navCtrl = [[IBTUINavigationController alloc] initWithRootViewController:homeVCtrl];
    [m_arrViewController addObject:navCtrl];
    
    navCtrl.title = nsTitle;
}
- (void)createBusinessController {
    NSString *nsTitle = ACETapBarItemNames[kTOBusiness];
    UIStoryboard *storyBoard = [UIStoryboard storyboardWithName:@"BusinessStoryBoard" bundle:nil];
    BusinessViewController *businessVC = [storyBoard instantiateViewControllerWithIdentifier:@"BusinessViewController"];
    [m_arrTabBarBaseViewController addObject:businessVC];
    businessVC.title = [IBTCommon localizableString:nsTitle];
    
    IBTUINavigationController *navC = [[IBTUINavigationController alloc]initWithRootViewController:businessVC];
    [m_arrViewController addObject:navC];
    
    navC.title = nsTitle;
}

- (void)createMeController{
    NSString *nsTitle = ACETapBarItemNames[kTOMe];
   GTOMeViewController *businessVC = [[GTOMeViewController alloc]init];
    [m_arrTabBarBaseViewController addObject:businessVC];
    businessVC.title = [IBTCommon localizableString:nsTitle];
    
    IBTUINavigationController *navC = [[IBTUINavigationController alloc]initWithRootViewController:businessVC];
    [m_arrViewController addObject:navC];

    navC.title = nsTitle;
}

@end
