//
//  GXFBottomView.h
//  XFFruit
//
//  Created by freecui on 15/9/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "IBTUIView.h"

@class GXFBottomView;
@protocol GXFBottomViewDelegate <NSObject>
@optional
- (void)bottomView:(GXFBottomView *)bottomView leftButtonClicked: (UIButton *)leftBtn;
- (void)bottomView:(GXFBottomView *)bottomView RightButtonClicked: (UIButton *)rightBtn;
- (void)bottomView:(GXFBottomView *)bottomView oneButtonClicked: (UIButton *)oneBtn;
@end

@interface GXFBottomView : IBTUIView

typedef NS_ENUM(NSInteger, buttonTag){
    leftTag = 1,
    rightTag
};

@property (nonatomic, weak) id<GXFBottomViewDelegate>delegate;
@property (nonatomic, strong) UIButton *f_leftBtn;
@property (nonatomic, strong) UIButton *f_rightBtn;
@property (nonatomic, strong) UIButton *f_oneBtn;
- (instancetype)initWithFrame:(CGRect)frame
                 LeftBtnTitle: (NSString *)leftTitle
                rightBtnTitle: (NSString *)rightTitle;

- (instancetype)initWithFrame:(CGRect)frame
                leftButtonColor: (UIColor *)leftBtnColor
             rightButtonColor: (UIColor *)rightBtnColor
                 LeftBtnTitle: (NSString *)leftTitle
                rightBtnTitle: (NSString *)rightTitle;

- (instancetype)initOneButtonWithFrame:(CGRect)frame
                           buttonColor: (UIColor *)btnColor
                           buttonTitle: (NSString *)title;
@end
