//
//  GTOCommonTools.h
//  total
//
//  Created by freecui on 15/10/15.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface GTOCommonTools : NSObject

+ (instancetype)sharedManager;

//null 转@“”
+ (NSString *)nullChangedWithId: (id)data;
+ (NSString *)stringWithId: (id)data;
+ (NSDate *)dateWithString: (NSString *)string;
+ (NSString *)stringLetterWithNumber: (NSInteger)number; //数字对应字母
+ (NSString *)dateSubstringDeleteZeroWithDateString:(NSString *)string;
+ (NSDate *)dateTwoWithString:(NSString *)string;

//拓站状态
+ (NSString *)pioneeringStateWithString: (NSString *)state;

//巡检
+ (NSString *)pioneeringCategoryWithString: (NSString *)category;

//各种巡检和SHE状态返回成对应的中文
+ (NSString *)patrolStateChineseWithEnglish: (NSString *)englishState;
//各种许可证状态返回成对应的中文
+ (NSString *)licenceStateChineseWithEnglish: (NSString *)englishState;

//各种报修状态返回成对应的中文
+ (NSString *)repairStateChineseWithEnglish: (NSString *)englishState;
//各种拓站状态返回成对应的中文
+ (NSString *)pioneeringStateChineseWithEnglish: (NSString *)englishState;
//根据状态返回返回不同的文字颜色
+ (UIColor *)textColorWithState: (NSString *)state;

//是否有某个功能的权限
+ (BOOL)hasPermissionWithPermissionId: (NSUInteger)permissionId;

//是否在一定时间范围内
+ (BOOL)nowInTimeDuringMinTime: (NSString *)minTime
                       maxTime: (NSString *)maxTime;
//返回订油单、配油单、建仓单、收油单图片
+ (UIImage *)returnOrderStateImage:(NSString *)stateString;
+ (NSString *)returnOrderStateString:(NSString *)stateString;
+ (UIColor *)returnOrderSateColor:(NSString *)stateString;

//结束MJRefresh刷新状态
+ (void)cancelMJRefreshState:(UIScrollView *)scrollView;
//返回当前时间
+ (NSString *)GetCurrenttime;
#pragma mark -计算两个字符串的差
+ (NSDecimalNumber *)calculateTwoStringSubtractingOneString:(NSString *)string stringTwo:(NSString *)stringtwo;
#pragma mark -计算两个字符串的和
+ (NSDecimalNumber *)calculateTwoStringAddingOneString:(NSString *)string stringTwo:(NSString *)stringtwo;
#pragma mark -计算两个字符串的积
+ (NSDecimalNumber *)calculateTwoStringMultiplyingOneString:(NSString *)string stringTwo:(NSString *)stringtwo;
#pragma mark -计算两个字符串的商
+ (NSDecimalNumber *)calculateTwoStringDividingOneString:(NSString *)string stringTwo:(NSString *)stringtwo;

@end
