//
//  DetailTimeViewController.m
//  total
//
//  Created by 曹云霄 on 16/6/24.
//  Copyright © 2016年 free. All rights reserved.
//

#import "DetailTimeViewController.h"
#import "KMDatePicker.h"
@interface DetailTimeViewController ()<KMDatePickerDelegate>

@property (nonatomic,strong) KMDatePicker *datePicker;
@end

@implementation DetailTimeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupDatePickerView];
}

#pragma mark -UI
- (void)setupDatePickerView
{
    // 年月日时分
   self.datePicker = [[KMDatePicker alloc]
                                initWithFrame:CGRectMake(0, 0, ScreenSize.width-40, 200)
                                delegate:self
                                datePickerStyle:KMDatePickerStyleYearMonthDayHourMinute];
    //显示风格
    self.datePicker.datePickerStyle = self.indexStyle;
    //默认显示时间
    self.datePicker.scrollToDate = self.defaultTime;
    //限制最小时间
    self.datePicker.minLimitedDate = [GTOCommonTools dateWithString:[GTOCommonTools GetCurrenttime]];
    [self.view addSubview:self.datePicker];
}

- (void)datePicker:(KMDatePicker *)datePicker didSelectDate:(KMDatePickerDateModel *)datePickerDate
{
    if (self.datePicker.datePickerStyle == 1) {//年月日
        NSString *dateStr = [NSString stringWithFormat:@"%@-%@-%@",
                             datePickerDate.year,
                             datePickerDate.month,
                             datePickerDate.day
                             ];
        if (self.returnSelectDate) {
            self.returnSelectDate([NSString stringWithFormat:@"%@",dateStr]);
        }
    }else {//年月日时分秒
        NSString *dateStr = [NSString stringWithFormat:@"%@-%@-%@ %@:%@",
                             datePickerDate.year,
                             datePickerDate.month,
                             datePickerDate.day,
                             datePickerDate.hour,
                             datePickerDate.minute
                             ];
        if (self.returnSelectDate) {
            self.returnSelectDate([NSString stringWithFormat:@"%@:00",dateStr]);
        }
    }
}

@end
