//
//  GTOHomePatrolItem.m
//  total
//  巡检的item
//  Created by freecui on 15/10/20.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOHomePatrolItem.h"
#import "GTOPatrolPlan.h"
@interface GTOHomePatrolItem ()

@property (strong, nonatomic) IBTUILabel *m_nameLabel;
@property (strong, nonatomic) IBTUILabel *m_processLabel;
@property (strong, nonatomic) UILabel *m_processValueLabel;
@property (strong, nonatomic) IBTUILabel * m_processFractionLabel;
@property (strong, nonatomic) IBTUIView *m_processBarView;//进度条

@property (assign, nonatomic) CGFloat d_processLength;
@end
@implementation GTOHomePatrolItem

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self){
        return nil;
    }
    [self initSubviews];
    return self;
}
- (void)initSubviews {
    
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_nameLabel = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processLabel = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processValueLabel = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processFractionLabel = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentRight];
    [self addSubview:_m_nameLabel];
    [self addSubview:_m_processLabel];
    [self addSubview:_m_processValueLabel];
    [self addSubview:_m_processFractionLabel];
    
    
}
- (void)layoutSubviews {
    [super layoutSubviews];
    CGFloat lblW = self.lineView.width * 0.6;
    
    self.m_nameLabel.frame = ((CGRect){
        .origin.x = LEFT_PADDING,
        .origin.y = self.lineView.bottom + VERTICAL_PADDING  ,
        .size.width = 100,
        .size.height = LBL_HEIGHT
    });[_m_nameLabel sizeToFit];
    self.m_processLabel.frame = ((CGRect){
        .origin.x = LEFT_PADDING,
        .origin.y = self.m_nameLabel.bottom + VERTICAL_PADDING  ,
        .size.width = 100,
        .size.height = LBL_HEIGHT
    });

    
    self.m_processValueLabel.frame = ((CGRect){
        .origin.x = _m_processLabel.right,
        .origin.y = _m_processLabel.y,
        .size.width = self.width - 2 * _m_processLabel.x - _m_processLabel.width,
        .size.height = LBL_HEIGHT
    });
    
    self.m_processFractionLabel.frame = ((CGRect){
        .origin.x = self.width - 2 * _m_processLabel.x - 60,
        .origin.y = _m_processLabel.y,//_m_processLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = 100,
        .size.height = LBL_HEIGHT
    });[self.m_processFractionLabel sizeToFit];
    
    CGRect rect = (CGRect){
        .origin.x = _m_processLabel.x,
        .origin.y = _m_processLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = self.width - _m_processLabel.x * 2  ,
        .size.height = LBL_HEIGHT
    };
    self.m_processBarView = [[IBTUIView alloc]initWithFrame:rect processBarFloat:_d_processLength processBarColor:GTO_BLUE_SHALLOW_TINT_COLOR viewBorderBarColor:GTO_GRAY_SHALLOW_TINT_COLOR];
    
    [self addSubview:_m_processBarView];
    //self.height = _m_processBarView.bottom + 10;
}
@end

@implementation GTOHomePatrolItem (configure)
- (void)updateWithData: (id)data  andCategory: (NSString *)category{
    
    if ([category isEqualToString:@"project"]) {
        self.titleLabel.text = @"工程巡检";
    } else {
        self.titleLabel.text = @"HSE专项巡检";
    }
    if (![data isKindOfClass:[GTOPatrolPlan class]]) {
        self.m_nameLabel.text = @"无相关任务";
        return;
    }
    GTOPatrolPlan *patrolPlan = (GTOPatrolPlan *)data;
    if (patrolPlan.totalStoreNumber <= 0) {
        patrolPlan.totalStoreNumber = 0;
        self.d_processLength = 0.0;
    } else {
        self.d_processLength =  patrolPlan.finishedStoreNumber * 1.0 / patrolPlan.totalStoreNumber;
    }
    int percent = patrolPlan.processLength * 100;
    
   
    self.m_nameLabel.text = patrolPlan.name;
    self.m_processLabel.text = @"巡检总进度:";
    self.m_processValueLabel.textColor = GTO_RED_COLOR;
    self.m_processValueLabel.text = [NSString stringWithFormat:@"%d%%",percent];
    self.m_processFractionLabel.textColor = GTO_RED_COLOR;
    self.m_processFractionLabel.text = [NSString stringWithFormat:@"%ld/%ld(油站)",patrolPlan.finishedStoreNumber,patrolPlan.totalStoreNumber];
    [self layoutSubviews];
}
@end
