//
//  GTORepairListCellContentView.m
//  total
//
//  Created by freecui on 15/10/29.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTORepairDetailTopCellView.h"
#import "GTORepair.h"
@interface GTORepairDetailTopCellView ()

@property (strong, nonatomic) IBTUILabel *m_billNumberLabel;
@property (strong, nonatomic) IBTUILabel *m_projectLabel;//报修项目
@property (strong, nonatomic) IBTUILabel *m_storeNameLabel;//油站
@property (strong, nonatomic) IBTUILabel *m_repairDateLabel;//开始时间
@property (strong, nonatomic) IBTUILabel *m_engineerNameLabel;
@property (strong, nonatomic) IBTUILabel *m_startDateLabel;
@property (strong, nonatomic) IBTUILabel *m_contentLabel;//

@end
@implementation GTORepairDetailTopCellView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_billNumberLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_projectLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_storeNameLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_repairDateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_engineerNameLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_startDateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_contentLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_contentLabel.numberOfLines = 0;
    
    
    [self addSubview:_m_billNumberLabel];
    [self addSubview:_m_projectLabel];
    [self addSubview:_m_storeNameLabel];
    [self addSubview:_m_repairDateLabel];
    [self addSubview:_m_engineerNameLabel];
    [self addSubview:_m_startDateLabel];
    [self addSubview:_m_contentLabel];
    
    
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_billNumberLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH + 10,
    };
    CGFloat leftX = _m_billNumberLabel.x;
    CGFloat width = SCREEN_SIZE.width - GTO_LEFT_PADDING;
    _m_projectLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_billNumberLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    _m_storeNameLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_projectLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = _m_billNumberLabel.width,
        .size.height = lblH,
    };
    _m_repairDateLabel.frame = (CGRect){
        .origin.x =leftX,
        .origin.y = _m_storeNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = width,
        .size.height = lblH,
    };
       _m_engineerNameLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_repairDateLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };

    _m_startDateLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_engineerNameLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = width,
        .size.height = lblH,
    };

    _m_contentLabel.frame = (CGRect){
        .origin.x = leftX,
        .origin.y = _m_startDateLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH ,
    };
    
}
@end


@implementation GTORepairDetailTopCellView (configure)

- (void)updateWithRepair: (GTORepair *)repair {

    self.m_billNumberLabel.text = [NSString stringWithFormat:@"报修单号：%@ ",repair.billnumber];
    self.m_projectLabel.text = [NSString stringWithFormat:@"报修项目: %@",repair.title ];
    self.m_storeNameLabel.text = [NSString stringWithFormat:@"油站名称：%@ ",repair.store_name];
    self.m_startDateLabel.text = [NSString stringWithFormat:@"新建时间：%@",repair.create_time ];
    self.m_engineerNameLabel.text = [NSString stringWithFormat:@"报修申请人：%@ ",repair.requestor];
    self.m_repairDateLabel.text = [NSString stringWithFormat:@"报修日期：%@ ",repair.repairDate];
    self.m_contentLabel.text = [NSString stringWithFormat:@"内容：%@ ",[GTOCommonTools nullChangedWithId:repair.content]];
   
}
@end
