//
//  GTOQStarViewController.m
//  Cruiser
//  星数类
//  Created by Xummer on 6/7/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "GTOQStarViewController.h"
#import "ASStarRatingView.h"
#import "GTOQuestionManager.h"

#define kLeftPadding 20.0f
#define kStarHeight  60.0f
#define kStarWidth   (320.0f * kStarHeight / 59.0f)

@interface GTOQStarViewController ()
@property (strong, nonatomic) ASStarRatingView *m_starRatingView;
@end

@implementation GTOQStarViewController

#pragma mark - Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.

    
    _m_starRatingView.rating = self.d_answer.resultScore;
    _m_starRatingView.maxRating = (int)self.d_question.star;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning]; 
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method
- (void)initScrollViewWithRect:(CGRect)rect {
    
    [super initScrollViewWithRect:rect];
    self.m_starRatingView = [[ASStarRatingView alloc] initWithFrame:CGRectMake((self.c_contentScrollView.width - kStarWidth) * 0.5, 20, kStarWidth, kStarHeight )];
    _m_starRatingView.canEdit = YES;
    _m_starRatingView.maxRating = 5;
    _m_starRatingView.rating = 0;
    [self.c_contentScrollView addSubview:_m_starRatingView];
    if (self.d_notEdit) {
        self.m_starRatingView.userInteractionEnabled = NO;
    }
}

#pragma mark - Actions
- (void)onNextBtnAction:(__unused id)sender {
  
    if (self.d_notEdit) {
        [super disMissSelf];
        return;
    }
    
    self.d_answer.resultScore = _m_starRatingView.rating;
    
    self.d_answer.bIsAnswered = YES;
    self.d_answer.resultRemark = self.c_helperView.m_inputTxtF.text;
    GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
    UIViewController *qVC = [mgr questionViewControlAtIndex:self.d_questionIndex + 1];
    if (qVC) {
        [self PushViewController:qVC animated:YES];
    }
    else {
        [super disMissSelf];
        // [self openResultView];
    }
    


    [self.d_answer saveToDBWithHandleData:NULL
                                 complete:^{
                                     [IBTLoadingView hideHUDWithText:nil];
                                     
                                     
                                 }
                                     fail:^(NSError *error) {
                                         
                                         [IBTLoadingView hideHUDWithText:error.localizedDescription];
                                     }];
}

@end
