
//
//  GTOPatrolPlanResultTopItem.m
//  total
//  巡检结果中的每月巡检的下面的cell
//  Created by freecui on 15/9/28.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOPatrolPlanResultTopItem.h"
#import "GTOPioneering.h"
#import "GTODisplayResult.h"
@interface GTOPatrolPlanResultTopItem ()
@property (strong, nonatomic) IBTUILabel *m_planTimeLabel;
@property (strong, nonatomic) IBTUILabel *m_startTimeLabel;
@property (strong, nonatomic) IBTUILabel *m_processLabel;//完成进度
@property (strong, nonatomic) IBTUILabel *m_processValueLabel;
@property (strong, nonatomic) IBTUILabel * m_processFractionLabel;
@property (strong, nonatomic) IBTUIView *m_processBarView;

@property (nonatomic, assign) CGFloat d_processLength;//进度条长度
@end
@implementation GTOPatrolPlanResultTopItem


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_planTimeLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_startTimeLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processValueLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processFractionLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentRight];
    
    [self addSubview:_m_planTimeLabel];
    [self addSubview:_m_startTimeLabel];
    [self addSubview:_m_processLabel];
    [self addSubview:_m_processValueLabel];
    [self addSubview:_m_processFractionLabel];

}
- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_planTimeLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    _m_startTimeLabel.frame = (CGRect){
        .origin.x = _m_planTimeLabel.x,
        .origin.y = _m_planTimeLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = _m_planTimeLabel.width,
        .size.height = lblH,
    };
    _m_processLabel.frame = (CGRect){
        .origin.x = _m_startTimeLabel.x,
        .origin.y = _m_startTimeLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = 120,
        .size.height = lblH,
    };
    _m_processValueLabel.frame = (CGRect){
        .origin.x = _m_processLabel.right,
        .origin.y = _m_processLabel.y,
        .size.width = 150,
        .size.height = lblH,
    }; [_m_processValueLabel sizeToFit];
    _m_processFractionLabel.frame = (CGRect){
        .origin.x = SCREEN_SIZE.width - 80 - GTO_LEFT_PADDING  ,
        .origin.y = _m_processLabel.y,
        .size.width = 100,
        .size.height = lblH,
    }; [_m_processFractionLabel sizeToFit];
    
    CGRect rect = (CGRect){
        .origin.x = _m_processLabel.x,
        .origin.y = _m_processLabel.bottom + GTO_VERTICAL_PADDING ,
        .size.width = SCREEN_SIZE.width - _m_processLabel.x - GTO_LEFT_PADDING,
        .size.height = 20,
    };
    self.m_processBarView = [[IBTUIView alloc]initWithFrame:rect processBarFloat:_d_processLength processBarColor:GTO_BLUE_SHALLOW_TINT_COLOR viewBorderBarColor:GTO_GRAY_SHALLOW_TINT_COLOR];
    [self addSubview:_m_processBarView];
    
    
}

@end

@implementation GTOPatrolPlanResultTopItem (configure)
- (void)updateWithPatrolPlan: (GTOPatrolPlan *)patrolPlan
                 storeResult: (ICRStoreResult *)storeResult
       finishCategorysNumber: (NSInteger)finishNumber
              totalCategorys: (NSInteger)totalNumber{
    self.m_planTimeLabel.text = [NSString stringWithFormat:@"计划时间：%@ ~ %@",patrolPlan.beginDate ,patrolPlan.endDate ];
    self.m_startTimeLabel.text = [NSString stringWithFormat:@"开始时间：%@",storeResult.beginTime];
    self.m_processLabel.text = [NSString stringWithFormat:@"巡检总进度" ];
        self.m_processFractionLabel.text = [NSString stringWithFormat:@" %ld/%ld（区）",finishNumber,totalNumber];
    
    self.d_processLength = 1.0 * finishNumber / totalNumber;
    int percent = self.d_processLength *100;
    self.m_processValueLabel.text = [NSString stringWithFormat:@"进行中 %d%%",percent]; //为什么直接写self.d_processLength *100 却是其他数据（貌似是随机分配的垃圾数据）？？？？

    
    
    [self layoutSubviews];
}
- (void)updateWithPatrolPlan: (GTOPatrolPlan *)patrolPlan
                 storeResult: (ICRStoreResult *)storeResult {
    self.m_planTimeLabel.text = [NSString stringWithFormat:@"计划时间：%@ ~ %@",patrolPlan.beginDate ,patrolPlan.endDate ];
    self.m_startTimeLabel.text = [NSString stringWithFormat:@"开始时间：%@",storeResult.beginTime ];
    NSInteger finishNumber = storeResult.answers.count;
    NSInteger totalNumber = storeResult.questions.count;
    self.d_processLength = 1.0 * finishNumber / totalNumber;
    int percent = self.d_processLength *100;
    self.m_processLabel.text = [NSString stringWithFormat:@"巡检总进度" ];
    self.m_processValueLabel.text = [NSString stringWithFormat:@"进行中 %d%%(题)",percent]; //为什么直接写self.d_processLength *100 却是其他数据（貌似是随机分配的垃圾数据）？？？？
    [self layoutSubviews];
}
- (void)updateWithPioneering: (GTOPioneering *)pioneering
         arrayDictDisplayResults: (NSArray *)arrDisplayResults
{
    self.m_planTimeLabel.text = [NSString stringWithFormat:@"拓店人员：%@",pioneering.pioneer_name ];
    self.m_startTimeLabel.text = [NSString stringWithFormat:@"开始时间：%@",pioneering.beginDate];
    self.m_processLabel.text = [NSString stringWithFormat:@"拓站总进度：" ];
    
    NSUInteger totalNumber = arrDisplayResults.count;
    NSUInteger finishNumber = 0;
    for(NSDictionary *dictDisplayR in arrDisplayResults){
        GTODisplayResult *displayR = [GTODisplayResult DBObject];
        [displayR praseFromJsonDict:dictDisplayR];
        if (displayR.arrAnswers.count == displayR.arrQuestions.count) {
            finishNumber ++;
        }
    }
    self.d_processLength = 1.0 * finishNumber / totalNumber;
    int percent = self.d_processLength *100;
    self.m_processValueLabel.text = [NSString stringWithFormat:@"进行中 %d%%",percent];
    [self layoutSubviews];
}

@end
