//
//  GTOPatrolPlanResultProblemItem.m
//  total
// 巡检结果中：每个问题和答案
//  Created by freecui on 15/9/28.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOPatrolPlanResultProblemItem.h"
#import "GTODisplayResult.h"
#import "GTOQuestion.h"
#import "ICRAnswer.h"
#import "GTOAnswer.h"
#import "GTOAnswerDetail.h"
#import "ASValueTrackingSlider.h"
#import "ASStarRatingView.h"
@interface GTOPatrolPlanResultProblemItem ()
@property (strong, nonatomic) IBTUILabel *m_problemLabel;
@property (strong, nonatomic) IBTUILabel *m_answerLabel;  //1单选，3回复，8单选打分 ,2多选，5库存
@property (strong, nonatomic) GTOAnswer *m_answer;
@property (strong, nonatomic) ASValueTrackingSlider *m_scoreSlider;//4评分
@property (strong, nonatomic) ASStarRatingView *m_starRatingView;
@end
@implementation GTOPatrolPlanResultProblemItem


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_problemLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:[UIColor clearColor] textAlignment:NSTextAlignmentLeft];
    self.m_modifyBtn = [[UIButton alloc]init];
    [self.m_modifyBtn setImage:[UIImage imageNamed:@"icon_modify"] forState:UIControlStateNormal];
    
    
    self.m_answerLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_TINT_COLOR backgroundColor:[UIColor clearColor] textAlignment:NSTextAlignmentLeft];
    
    self.m_scoreSlider = [[ASValueTrackingSlider alloc]init];
    self.m_scoreSlider.popUpViewCornerRadius = 0.0;
    [self.m_scoreSlider setMaxFractionDigitsDisplayed:0];
    self.m_scoreSlider.popUpViewColor = [UIColor colorWithHue:0.55 saturation:0.8 brightness:0.9 alpha:0.7];
    self.m_scoreSlider.font = [UIFont systemFontOfSize:20];
    self.m_scoreSlider.textColor = [UIColor colorWithHue:0.55 saturation:1.0 brightness:0.5 alpha:1];
    self.m_scoreSlider.popUpViewWidthPaddingFactor = 1.7;
    [_m_scoreSlider showPopUpViewAnimated:YES];
    
    


    
    [self addSubview:_m_problemLabel];
    [self addSubview:_m_modifyBtn];
    
    [self addSubview:_m_answerLabel];
  //  [self addSubview:_m_scoreSlider];
   
    
}
- (void)layoutSubviews {
    
    CGFloat lblH = 17;
    _m_problemLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width,
        .size.height = lblH,
    };
    _m_modifyBtn.frame = (CGRect){
        .origin.x = SCREEN_SIZE.width - GTO_LEFT_PADDING - 40,
        .origin.y = _m_problemLabel.bottom,// + GTO_VERTICAL_PADDING,
        .size.width = 40,
        .size.height = lblH + GTO_VERTICAL_PADDING,
    };

    _m_answerLabel.frame = (CGRect){
        .origin.x = _m_problemLabel.x,
        .origin.y = _m_modifyBtn.y +  7,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING * 2 - _m_modifyBtn.width,
        .size.height = lblH + 5 ,
    };
    
}

@end

@implementation GTOPatrolPlanResultProblemItem (configure)


- (void)updateWithDisplayResult: (GTODisplayResult *)displayResult
                       andIndex: (NSUInteger)index{
    GTOQuestion *question = displayResult.arrQuestions[index];
    ICRAnswer *answer = displayResult.arrAnswers[index];
    self.m_problemLabel.text = [NSString stringWithFormat:@"%ld.%@ ?",index + 1,question.title];
    
    //答案显示需要把不同类型的问题分类，现在还没完善
    if (answer.details.count > 1) {
        
    } else {
    self.m_answerLabel.text = [NSString stringWithFormat:@"答：index=%@   %@",[answer.details objectAtIndex:0][@"index"],answer.uuid];
    }
    //self.m_modifyBtn.text = [NSString stringWithFormat:@"修改"];
}

/*
 kICRQestionTypeSingleSel = 0,
 kICRQestionTypeMultipleSel,
 kICRQestionTypeReply,
 kICRQestionTypeScore,
 kICRQestionTypeStoreInv,
 kICRQestionTypeSpeciesInv,
 kICRQestionTypeStarNum,
 kICRQestionTypeSingleScore//单选打分（新增加）
 
 */
- (void)updateWithPioneeringDisplayResult: (GTODisplayResult *)displayResult
                       andIndex: (NSUInteger)index{
    GTOQuestion *question = displayResult.arrQuestions[index];

    GTOAnswer *answer = displayResult.arrAnswers[index];
    self.m_answer = answer;
    self.m_problemLabel.text = [NSString stringWithFormat:@"%ld.%@ ?",index + 1,question.title];

    switch (answer.type) {
        case kICRQestionTypeSingleSel:
        {
        
        }
            break;
        case kICRQestionTypeSingleScore:
        {
            
        }
            break;
        case kICRQestionTypeReply:
        {
            
        }
            break;
        case kICRQestionTypeMultipleSel:
        {
            
        }
            break;
        default:
            break;
    }
     NSDictionary *dict = (NSDictionary *)answer.resultDetails[0];

    self.m_answerLabel.text = [NSString stringWithFormat:@"答：number = %@ ,string = %@",dict[@"numberValue"],dict[@"stringValue"]];
    [self layoutSubviews];
}

- (void)updatePatrolWithQuestion: (GTOQuestion *)question
                    answer: (ICRAnswer *)answer
                     index: (NSUInteger)index{
    self.m_problemLabel.text = [NSString stringWithFormat:@"%ld.%@ ?",index + 1,question.title];
    
    if(!answer) {
        self.m_answerLabel.text = @"";
        [self layoutSubviews];
        return;
    }
    if(answer.details.count == 1){
        GTOAnswerDetail *answerDetail = [GTOAnswerDetail DBObject];
        [answerDetail praseFromJsonDict:answer.details[0]];
        //        self.m_answerLabel.text = [NSString stringWithFormat:@"答：number = %ld ,string = %@",answerDetail.numberValue,answerDetail.stringValue];
        NSString *textContent ;
        
        switch (answer.type) {
            case kICRQestionTypeSingleSel:
            {
                textContent = [NSString stringWithFormat:@"%@",answerDetail.stringValue];
            }
                break;
            case kICRQestionTypeMultipleSel:
            {
                textContent = [NSString stringWithFormat:@"%@",answerDetail.stringValue];
            }
                break;
            case kICRQestionTypeSingleScore:
            {
                textContent = [NSString stringWithFormat:@"值: %@,分数: %ld ",answerDetail.stringValue,answerDetail.numberValue];
            }
                break;
                
                
            default:
                break;
        }
        self.m_answerLabel.text =  self.m_answerLabel.text = [NSString stringWithFormat:@"答：%@",textContent];
    } else if (answer.details.count > 1) {
        NSMutableString *content = [NSMutableString string];
        for(NSDictionary *dict in answer.details) {
            GTOAnswerDetail *answerDetail = [GTOAnswerDetail DBObject];
            [answerDetail praseFromJsonDict:dict];
            [content appendString: [GTOCommonTools nullChangedWithId:answerDetail.stringValue]];
        }
        self.m_answerLabel.text = [NSString stringWithFormat:@"答：%@",content];
    } else {
        
    }
    
    
    switch (answer.type) {
        case kICRQestionTypeReply:
        {
            self.m_answerLabel.text = [NSString stringWithFormat:@"答：%@",answer.content];
        }
            break;
        case kICRQestionTypeStarNum://6  星数类
        {
            CLog(@"%lf",_m_modifyBtn.width);
            CGRect rect = CGRectMake(0, 0, (SCREEN_SIZE.width - GTO_LEFT_PADDING * 2 ) * 0.7,20);
            self.m_starRatingView = [[ASStarRatingView alloc] initWithFrame:rect ];
            _m_starRatingView.rating = answer.score;
            _m_starRatingView.maxRating = (int)question.star;
            _m_starRatingView.canEdit = NO;
            [self.m_answerLabel addSubview:_m_starRatingView];
        }
            break;
        case kICRQestionTypeScore:
        case kICRQestionTypeStoreInv:
        case kICRQestionTypeSpeciesInv://3  评分类
        {
            self.m_answerLabel.text = @"点击查看详情";
        }
            break;
            //        case kICRQestionTypeStoreInv://4 库存调查类
            //        {
            //
            //        }
            //            break;
            //        case kICRQestionTypeSpeciesInv://5 品类调查类
            //        {
            //
            //        }
            //            break;
        default:
            break;
    }
    [self layoutSubviews];
}

/*
 kICRQestionTypeSingleSel = 0,
 kICRQestionTypeMultipleSel,
 kICRQestionTypeReply,
 kICRQestionTypeScore,
 kICRQestionTypeStoreInv,
 kICRQestionTypeSpeciesInv,
 kICRQestionTypeStarNum,
 kICRQestionTypeSingleScore//单选打分（新增加）
 */

- (void)updateWithQuestion: (GTOQuestion *)question
                    answer: (GTOAnswer *)answer
                     index: (NSUInteger)index{
    self.m_problemLabel.text = [NSString stringWithFormat:@"%ld.%@ ?",index + 1,question.title];
    
    if(!answer) {
        self.m_answerLabel.text = @"";
        [self layoutSubviews];
        return;
    }
    if(answer.resultDetails.count == 1){
        GTOAnswerDetail *answerDetail = [GTOAnswerDetail DBObject];
        [answerDetail praseFromJsonDict:answer.resultDetails[0]];
        //        self.m_answerLabel.text = [NSString stringWithFormat:@"答：number = %ld ,string = %@",answerDetail.numberValue,answerDetail.stringValue];
        NSString *textContent ;
        
        switch (answer.type) {
            case kICRQestionTypeSingleSel:
            {
                textContent = [NSString stringWithFormat:@"%@",answerDetail.stringValue];
            }
                break;
            case kICRQestionTypeMultipleSel:
            {
                textContent = [NSString stringWithFormat:@"%@",answerDetail.stringValue];
            }
                break;
            case kICRQestionTypeSingleScore:
            {
                textContent = [NSString stringWithFormat:@"值: %@,分数: %ld ",answerDetail.stringValue,answerDetail.numberValue];
            }
                break;
            

            default:
                break;
        }
        self.m_answerLabel.text =  self.m_answerLabel.text = [NSString stringWithFormat:@"答：%@",textContent];
    } else if (answer.resultDetails.count > 1) {
        NSMutableString *content = [NSMutableString string];
        for(NSDictionary *dict in answer.resultDetails) {
            GTOAnswerDetail *answerDetail = [GTOAnswerDetail DBObject];
            [answerDetail praseFromJsonDict:dict];
            [content appendString: [GTOCommonTools nullChangedWithId:answerDetail.stringValue]];
        }
        self.m_answerLabel.text = [NSString stringWithFormat:@"答：%@",content];
    } else {
        
    }
    
    
    switch (answer.type) {
        case kICRQestionTypeReply:
        {
            self.m_answerLabel.text = [NSString stringWithFormat:@"答：%@",answer.resultContent];
        }
            break;
        case kICRQestionTypeStarNum://6  星数类
        {
            CLog(@"%lf",_m_modifyBtn.width);
            CGRect rect = CGRectMake(0, 0, (SCREEN_SIZE.width - GTO_LEFT_PADDING * 2 ) * 0.7,20);
            self.m_starRatingView = [[ASStarRatingView alloc] initWithFrame:rect ];
            _m_starRatingView.rating = answer.resultScore;
            _m_starRatingView.maxRating = (int)question.star;
            _m_starRatingView.canEdit = NO;
            [self.m_answerLabel addSubview:_m_starRatingView];
        }
            break;
        case kICRQestionTypeScore:
        case kICRQestionTypeStoreInv:
        case kICRQestionTypeSpeciesInv://3  评分类
        {
            self.m_answerLabel.text = @"点击查看详情";
        }
            break;
//        case kICRQestionTypeStoreInv://4 库存调查类
//        {
//            
//        }
//            break;
//        case kICRQestionTypeSpeciesInv://5 品类调查类
//        {
//            
//        }
//            break;
        default:
            break;
    }

    [self layoutSubviews];
}
@end
