//
//  GlineTopatrolPlanResultHeadItem.m
//  total
// 巡检结果中：不同区的headerView
//  Created by freecui on 15/9/28.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOPatrolPlanResultHeaderItem.h"
#import "GTODisplayResult.h"
@interface GTOPatrolPlanResultHeaderItem ()<UIGestureRecognizerDelegate>
@property (nonatomic, strong) IBTUILabel *lblCategory;
@property (nonatomic, strong) IBTUILabel *lblResult;
@property (nonatomic, strong) UIImageView *imgV;
@property (nonatomic, strong) IBTUILabel *lineTop;
@property (nonatomic, strong) IBTUILabel *lineBottom;

@end
@implementation GTOPatrolPlanResultHeaderItem

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    UIFont *font = [UIFont systemFontOfSize:14];
    self.lblCategory = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:[UIColor blackColor] backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.lblResult = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:[UIColor blackColor] backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.imgV = [[UIImageView alloc]initWithImage:[UIImage imageNamed:@"arrowright"]];
    self.lineTop = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:nil backgroundColor:GTO_LINE_COLOR textAlignment:NSTextAlignmentLeft];
    self.lineBottom = [[IBTUILabel alloc]initWithtext:nil font:font tintColor:nil backgroundColor:GTO_LINE_COLOR textAlignment:NSTextAlignmentLeft];
    [self addSubview:_lblCategory];
    [self addSubview:_lblResult];
    [self addSubview:_imgV];
    [self addSubview:_lineTop];
    [self addSubview:_lineBottom];
    
    UITapGestureRecognizer *tapGes = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(tapIsDisplay)];
    tapGes.delegate = self;
    tapGes.numberOfTapsRequired = 1;
    [self addGestureRecognizer:tapGes];
    
}
- (void)layoutSubviews {
    CGFloat padding = 10;
   
    _imgV.frame = (CGRect){
        .origin.x =  padding,
        .origin.y = (HEADER_HEIGHT - 10) * 0.5,
        .size.width = 10,
        .size.height = 10,
    };

    _lblCategory.frame = (CGRect){
        .origin.x = _imgV.right + padding,
        .origin.y = 0,
        .size.width = 100,
        .size.height = HEADER_HEIGHT,
    };
    
    _lblResult.frame = (CGRect){
        .origin.x = _lblCategory.right,
        .origin.y = 0,
        .size.width = SCREEN_SIZE.width - _lblCategory.right,
        .size.height = _lblCategory.height,
    };
    
    _lineTop.frame = (CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = [UIScreen mainScreen].bounds.size.width,//self.width,
        .size.height = 1,
    };
    _lineBottom.frame = (CGRect){
        .origin.x = _lineTop.x,
        .origin.y = HEADER_HEIGHT - _lineTop.height,
        .size.width = _lineTop.width,
        .size.height = _lineTop.height ,
    };

}

- (void)tapIsDisplay {
    self.isDisplay = !_isDisplay;
    self.imgV.image = _isDisplay ?[UIImage imageNamed:@"arrowdown"]: [UIImage imageNamed:@"arrowright"];
    if ([_delegate respondsToSelector:@selector(patrolPlanResultHeaderItem:andIsDisplay:)]) {
        [_delegate patrolPlanResultHeaderItem:self andIsDisplay:_isDisplay];
    }
}
@end


@implementation GTOPatrolPlanResultHeaderItem (configure)

- (void)updateWithDisplayResult: (GTODisplayResult *)displayResult {

    _lblCategory.text = displayResult.category;
    _lblResult.text = [NSString stringWithFormat:@"已检项/总数  %ld/%ld" ,displayResult.arrAnswers.count,displayResult.arrQuestions.count];
    
    self.imgV.image = _isDisplay ?[UIImage imageNamed:@"arrowdown"]: [UIImage imageNamed:@"arrowright"];
    [self layoutSubviews];
}
@end
