//
//  GTOPatrolPlanInfoItemView.m
//  total
//  巡检汇总头部： 巡检信息item
//  Created by freecui on 15/9/15.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOPatrolPlanInfoItemView.h"
#import "GTOPatrolPlan.h"
#define PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR        [UIColor blackColor]
#define PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR      [UIColor grayColor]

#define PATROL_PLAN_CONTENT_LABEL_VERTICAL_MARGIN    (10.0f)
#define PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN     (15.0f)
#define PATROL_PLAN_CONTENT_LABEL_INNER_GAP          (5.0f)
#define PATROL_PLAN_CONTENT_LABEL_HEIGHT             (16)
@interface GTOPatrolPlanInfoItemView ()
@property (strong, nonatomic) UILabel *m_patrolInfoLabel;
@property (strong, nonatomic) UILabel *m_locationLabel;
//@property (strong, nonatomic) UIButton *m_locationButton;

@property (strong, nonatomic) UILabel *m_titleLabel;
@property (strong, nonatomic) UILabel *m_planTimeLabel;
@property (strong, nonatomic) UILabel *m_planTimeValueLabel;
@property (strong, nonatomic) UILabel *m_stateLabel; //状态
@property (strong, nonatomic) UILabel *m_stateValueLabel;

@property (strong, nonatomic) UILabel *m_processLabel;//完成进度
@property (strong, nonatomic) UILabel *m_processValueLabel;

@property (strong, nonatomic) IBTUIView *m_processBarView;
@property (strong, nonatomic) UILabel * m_processFractionLabel;

@property (nonatomic, assign) CGFloat d_processLength;//进度条长度

@end

@implementation GTOPatrolPlanInfoItemView

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self _init];
    }
    return self;
}

- (void)_init {
    
    self.m_patrolInfoLabel = [[UILabel alloc]init];
    self.m_patrolInfoLabel.font = [UIFont systemFontOfSize:18];
    self.m_patrolInfoLabel.textColor = ICR_BLUE_BTN_COLOR;
    self.m_patrolInfoLabel.text = @"巡检信息";

    self.m_locationLabel = [[self class]customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR];
    self.m_locationLabel.textAlignment = NSTextAlignmentRight;
    self.m_locationButton = [[UIButton alloc]init];
    [self.m_locationButton setBackgroundImage:[UIImage imageNamed:@"icon_nav_start"] forState:UIControlStateNormal];

    [self addSubview:_m_locationButton];
    [self addSubview:_m_patrolInfoLabel];
    [self addSubview:_m_locationLabel];
    
    
    self.m_titleLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR];
    [self addSubview:_m_titleLabel];
    
    self.m_planTimeLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR];
    _m_planTimeLabel.text = @"计划时间：";//[IBTCommon localizableString:@"Type:"];
    [self addSubview:_m_planTimeLabel];
    
    self.m_planTimeValueLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR];
    
    [self addSubview:_m_planTimeValueLabel];
    
    self.m_stateLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR];
    _m_stateLabel.text = @"油站巡检情况";//[IBTCommon localizableString:@"Start Time:"];
    [self addSubview:_m_stateLabel];
    
    self.m_stateValueLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR];
    [self addSubview:_m_stateValueLabel];
    
    self.m_processLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_TITLE_COLOR];
    _m_processLabel.text = @"完成进度：";//[IBTCommon localizableString:@"End Time:"];
    [self addSubview:_m_processLabel];
    
    self.m_processValueLabel = [[self class] customLabelWithTextColor:PATROL_PLAN_CONTENT_LABEL_CONTENT_COLOR];
    [self addSubview:_m_processValueLabel];

    
    self.m_processFractionLabel = [[UILabel alloc]init];
    self.m_processFractionLabel.backgroundColor =  XXFBgColor;
    self.m_processFractionLabel.font = [UIFont systemFontOfSize:18];
    self.m_processFractionLabel.textAlignment = NSTextAlignmentCenter;
    [self addSubview:_m_processFractionLabel];
    
    self.height = _m_processFractionLabel.bottom;
    
}

- (void)layoutSubviews {
    CGFloat MaxW = self.width - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN;
    
    CGFloat padding = 5;
    _m_patrolInfoLabel.frame = ((CGRect){
        .origin.x = padding,
        .origin.y = PATROL_PLAN_CONTENT_LABEL_VERTICAL_MARGIN,
        .size.width = ( self.width - 2 *padding ) * 0.5,
        .size.height = PATROL_PLAN_CONTENT_LABEL_HEIGHT * 2
    });

    _m_locationButton.frame = ((CGRect){
        .origin.x = self.width - padding - PATROL_PLAN_CONTENT_LABEL_HEIGHT * 2,
        .origin.y = _m_patrolInfoLabel.y,
        .size.width = PATROL_PLAN_CONTENT_LABEL_HEIGHT * 2 ,
        .size.height = PATROL_PLAN_CONTENT_LABEL_HEIGHT * 2
    });
    _m_locationLabel.frame = ((CGRect){
        .origin.x =  _m_patrolInfoLabel.right ,
        .origin.y = _m_patrolInfoLabel.y,
        .size.width = _m_patrolInfoLabel.width - _m_locationButton.width ,
        .size.height = PATROL_PLAN_CONTENT_LABEL_HEIGHT
    });

    
    CGSize size = CGSizeMake(MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_titleLabel widthLimitedSizeThatFits:size];
    _m_titleLabel.frame = ((CGRect){
        .origin.x = PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN,
        .origin.y = _m_patrolInfoLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
        .size = size
    });
    
    size = CGSizeMake(MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_planTimeLabel widthLimitedSizeThatFits:size];
    _m_planTimeLabel.frame = ((CGRect){
        .origin.x = _m_titleLabel.left,
        .origin.y = _m_titleLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
        .size = size
    });
    
    size = CGSizeMake(MaxW - _m_planTimeLabel.right, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_planTimeValueLabel widthLimitedSizeThatFits:size];
    _m_planTimeValueLabel.frame = ((CGRect){
        .origin.x = _m_planTimeLabel.right,
        .origin.y = _m_planTimeLabel.top,
        .size = size
    });
    
    size = CGSizeMake(MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_stateLabel widthLimitedSizeThatFits:size];
    _m_stateLabel.frame = ((CGRect){
        .origin.x = _m_planTimeLabel.left,
        .origin.y = _m_planTimeLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP, //_m_planTimeValueLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
        .size = size
    });
    
    size = CGSizeMake(MaxW - _m_stateLabel.right, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_stateValueLabel widthLimitedSizeThatFits:size];
    _m_stateValueLabel.frame = ((CGRect){
        .origin.x = _m_stateLabel.right,
        .origin.y = _m_stateLabel.top,
        .size = size
    });
    
    size = CGSizeMake(MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_processLabel widthLimitedSizeThatFits:size];
    _m_processLabel.frame = ((CGRect){
        .origin.x = _m_stateLabel.left,
        .origin.y = _m_stateLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
        .size = size
    });
    
    size = CGSizeMake(MaxW - _m_processLabel.right, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    size = [_m_processValueLabel widthLimitedSizeThatFits:size];
    _m_processValueLabel.frame = ((CGRect){
        .origin.x = _m_processLabel.right,
        .origin.y = _m_processLabel.top,
        .size = size
    });
    
    
    size = CGSizeMake((MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN ) * 0.6, PATROL_PLAN_CONTENT_LABEL_HEIGHT);
    //    _m_processBarView.frame = ((CGRect){
    //        .origin.x = _m_processLabel.left,
    //        .origin.y = _m_processLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
    //        .size = size
    //    });
    CGRect rect = (CGRect){
        .origin.x = _m_processLabel.left,
        .origin.y = _m_processLabel.bottom + PATROL_PLAN_CONTENT_LABEL_INNER_GAP,
        .size = size
    };
    self.m_processBarView = [[IBTUIView alloc]initWithFrame:rect processBarFloat:_d_processLength processBarColor:[UIColor yellowColor] viewBorderBarColor:[UIColor blackColor]];
    [self addSubview:_m_processBarView];
    
    
    size = CGSizeMake(PATROL_PLAN_CONTENT_LABEL_HEIGHT *2.0 / 3.0 * 4.0, PATROL_PLAN_CONTENT_LABEL_HEIGHT * 2);//宽：长 = 4：3
    _m_processFractionLabel.frame = ((CGRect){
        .origin.x = MaxW - PATROL_PLAN_CONTENT_LABEL_HORIZON_MARGIN * 2 - size.width,
        .origin.y = _m_processLabel.y ,
        .size = size
    });
    
    self.height = _m_processFractionLabel.bottom + PATROL_PLAN_CONTENT_LABEL_VERTICAL_MARGIN;
}
#pragma mark - Class Method

+ (IBTUILabel *)customLabelWithTextColor:(UIColor *)textColor {
    
    IBTUILabel *label = [[IBTUILabel alloc] init];
    label.textAlignment = NSTextAlignmentLeft;
    label.textColor = textColor;
    label.font = [UIFont systemFontOfSize:15];
    
    return label;
}
@end


@implementation GTOPatrolPlanInfoItemView (Configure)

- (void)updateValueLabelWithPatrolPlan:(GTOPatrolPlan *)patrolPlan {

    _m_titleLabel.text = patrolPlan.name;
    _m_planTimeValueLabel.text = [NSString stringWithFormat:@"%@ ~ %@",patrolPlan.beginDate,patrolPlan.endDate ];//atrol.patrolCategory;
    _m_stateValueLabel.text = [NSString stringWithFormat:@"%ld",patrolPlan.state  ];//patrol.planStartDate;
    _m_processValueLabel.text = @"70%";
    
    
    _m_processFractionLabel.text = [NSString stringWithFormat:@"%d/%d",3,4];
    
    
    self.d_processLength = 0.5;

    self.m_locationLabel.text = [NSString stringWithFormat:@"当前位置：%@",@"闵行" ];
    [self.m_locationButton addTarget:self action:@selector(locationClicked) forControlEvents:UIControlEventTouchUpInside];
    
    [self layoutSubviews];
}

- (void)locationClicked {
    if ([self.delegate respondsToSelector:@selector(patrolPlanInfoItemViewLocationWithLongitude:andLatitude:)]) {
        [self.delegate patrolPlanInfoItemViewLocationWithLongitude:11 andLatitude:10];
    }
}
@end