
//
//  GTOPatrolPlanResultTopItem.m
//  total
//  巡检结果中的每月巡检的下面的cell
//  Created by freecui on 15/9/28.
//  Copyright (c) 2015年 free. All rights reserved.
//

#import "GTOPatrolPlanAllTopItem.h"
#import "GTOPatrolPlan.h"
#import "GTOInspector.h"
@interface GTOPatrolPlanAllTopItem ()
@property (strong, nonatomic) IBTUILabel *m_planStateLabel;
@property (strong, nonatomic) IBTUILabel *m_planTimeLabel;

@property (strong, nonatomic) IBTUILabel *m_processLabel;//完成进度
@property (strong, nonatomic) IBTUILabel *m_processValueLabel;
@property (strong, nonatomic) IBTUILabel * m_processFractionLabel;
@property (strong, nonatomic) IBTUIView *m_processBarView;

@property (nonatomic, assign) CGFloat d_processLength;//进度条长度
@end
@implementation GTOPatrolPlanAllTopItem


- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    return self;
}

- (void)initSubViews {
    UIFont *font = [UIFont systemFontOfSize:17];
    self.m_planStateLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_planTimeLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];

    self.m_processLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_GRAY_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processValueLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentLeft];
    self.m_processFractionLabel = [[IBTUILabel alloc]initWithfont:font tintColor:GTO_BLUE_SHALLOW_TINT_COLOR backgroundColor:nil textAlignment:NSTextAlignmentRight];
    
    [self addSubview:_m_planStateLabel];
    [self addSubview:_m_planTimeLabel];
    [self addSubview:_m_processLabel];
    [self addSubview:_m_processValueLabel];
    [self addSubview:_m_processFractionLabel];
    
}
- (void)layoutSubviews {
    CGFloat lblH = 17;
    _m_planStateLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = GTO_TOP_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    _m_planTimeLabel.frame = (CGRect){
        .origin.x = GTO_LEFT_PADDING,
        .origin.y = _m_planStateLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = SCREEN_SIZE.width - GTO_LEFT_PADDING,
        .size.height = lblH,
    };
    _m_processLabel.frame = (CGRect){
        .origin.x = _m_planTimeLabel.x,
        .origin.y = _m_planTimeLabel.bottom + GTO_VERTICAL_PADDING,
        .size.width = 100,
        .size.height = lblH,
    };
    _m_processValueLabel.frame = (CGRect){
        .origin.x = _m_processLabel.right,
        .origin.y = _m_processLabel.y,
        .size.width = 120,
        .size.height = lblH,
    };
    _m_processFractionLabel.frame = (CGRect){
        .origin.x = SCREEN_SIZE.width - 100 - GTO_LEFT_PADDING,
        .origin.y = _m_processLabel.y,
        .size.width = 100,
        .size.height = lblH,
    };
    
    CGRect rect = (CGRect){
        .origin.x = _m_processLabel.x,
        .origin.y = _m_processLabel.bottom + GTO_VERTICAL_PADDING ,
        .size.width = SCREEN_SIZE.width - _m_processLabel.x - GTO_LEFT_PADDING,
        .size.height = 27,
    };

    [self.m_processBarView removeFromSuperview];
    self.m_processBarView = [[IBTUIView alloc]initWithFrame:rect processBarFloat:_d_processLength processBarColor:GTO_BLUE_SHALLOW_TINT_COLOR viewBorderBarColor:GTO_GRAY_SHALLOW_TINT_COLOR];
    [self addSubview:_m_processBarView];
   }

@end

@implementation GTOPatrolPlanAllTopItem (configure)
- (void)updateWithPatrolPlan: (GTOPatrolPlan *)patrolPlan
{
    
    NSString *stateStr = [NSString stringWithFormat:@"%ld",patrolPlan.state];
    self.m_planStateLabel.text = [NSString stringWithFormat:@"状态：%@",[GTOCommonTools patrolStateChineseWithEnglish:stateStr]];
    self.m_planTimeLabel.text = [NSString stringWithFormat:@"计划时间：%@ ~ %@",patrolPlan.beginDate ,patrolPlan.endDate ];
    self.m_processLabel.text = [NSString stringWithFormat:@"巡检总进度"];
    
//    int finishStores = 0; int totalStores = (int)patrolPlan.inspectors.count;
//    for(NSDictionary *dict in patrolPlan.inspectors) {
//        if ([dict[@"state" ] integerValue] == 1) {
//            finishStores ++;
//        }
//    }
    
    self.d_processLength = patrolPlan.processLength >= 0 || patrolPlan.processLength <= 1 ? patrolPlan.processLength : 0;//finishStores * 1.0 / totalStores ;
    int percent = self.d_processLength * 100;
    if (patrolPlan.finishedStoreNumber == patrolPlan.totalStoreNumber) {
        self.m_processValueLabel.text = [NSString stringWithFormat:@"%d%%",percent];
        self.m_processValueLabel.textColor = GTO_GRAY_TINT_COLOR;
        self.m_processFractionLabel.textColor = GTO_GRAY_TINT_COLOR;
    } else {
        self.m_processValueLabel.text = [NSString stringWithFormat:@"%d%%",percent];
        self.m_processValueLabel.textColor = GTO_BLUE_TINT_COLOR;
        self.m_processFractionLabel.textColor = GTO_BLUE_TINT_COLOR;
    }
    
    self.m_processFractionLabel.text = [NSString  stringWithFormat:@"%.0f/%ld (油站)",patrolPlan.totalStoreNumber * self.d_processLength,patrolPlan.totalStoreNumber];
    
    
    [self layoutSubviews];
}
@end
