//
//  ICRQuestionHelperView.m
//  Cruiser
//
//  Created by Xummer on 15/6/3.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRQuestionHelperView.h"
#import "ICRAttachmentView.h"
#import "LBorderView.h"
#import "IBTCustomButtom.h"

#import "ICRQuestionManager.h"

#define LEFT_MARGIN                 (15.0f)
#define HELPER_VIEW_MAX_HEIGHT      (330)
#define HELPER_VIEW_R_MAX_HEIGHT    (210)
#define HELPER_VIEW_MIN_HEIGHT      (150)
#define HELPER_ATTACH_HEIGHT        (60)

@interface ICRQuestionHelperView ()
{
    BOOL m_bIsResult;
}

@property (strong, nonatomic) IBTUILabel *m_titleLable;
@property (strong, nonatomic) UIButton *m_changeBtn;

@property (strong, nonatomic) LBorderView *m_attachBGView;

@property (strong, nonatomic) UIView *m_attachInputView;

@end

@implementation ICRQuestionHelperView

+ (UIView *)TextFWithLeftLabel:(NSString *)nsLeftLabel
                         textF:(UITextField * __autoreleasing *)textFPointer
{
    UIView *v = [[UIView alloc] initWithFrame:(CGRect){
        .origin.x = 0,
        .origin.y = 0,
        .size.width = 300,
        .size.height = 40
    }];
    v.backgroundColor = [UIColor clearColor];
    
    IBTUILabel *leftLabel = [[IBTUILabel alloc] init];
    leftLabel.font = [UIFont systemFontOfSize:16];
    leftLabel.textColor = [UIColor lightGrayColor];
    leftLabel.text = nsLeftLabel;
    [leftLabel sizeToFit];
    leftLabel.x = 0;
    
    UIView *labelContainer = [[UIView alloc] init];
    labelContainer.backgroundColor = [UIColor clearColor];
    labelContainer.frame = (CGRect){
        .origin.x = 0,
        .origin.y = 8,
        .size.width = leftLabel.width + 2 * 5,
        .size.height = leftLabel.height
    };
    [labelContainer addSubview:leftLabel];
    [v addSubview:labelContainer];
    UITextField *txtF = [[UITextField alloc] initWithFrame:(CGRect){
        .origin.x = leftLabel.right + 2,
        .origin.y = 5,//0,
        .size.width = v.width - 4 - leftLabel.right,
        .size.height = v.height - 5
    }];
    txtF.borderStyle = UITextBorderStyleRoundedRect;
    txtF.backgroundColor = [UIColor clearColor];
    txtF.leftViewMode = UITextFieldViewModeAlways;
   // txtF.leftView = labelContainer;
    [txtF autoresizingWithStrechFullSize];
    
//    UIImageView *txtFBG = [[UIImageView alloc] initWithFrame:(CGRect){
//        .origin.x = labelContainer.width,
//        .origin.y = 0,
//        .size.width = txtF.width - labelContainer.width,
//        .size.height = txtF.height
//    }];
//    txtFBG.userInteractionEnabled = YES;
//    txtFBG.image =
//    [[UIImage imageNamed:@"LoginInputBG"] stretchableImageWithLeftCapWidth:10
//                                                              topCapHeight:25];
//    txtFBG.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight | UIViewAutoresizingFlexibleRightMargin;
//    [v addSubview:txtFBG];
    [v addSubview:txtF];

    
    if (textFPointer) {
        *textFPointer = txtF;
    }
    
    return v;
}

#pragma mark - Life Cycle

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubviews];
    
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame isResult:(BOOL)bIsResult {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    m_bIsResult = bIsResult;
    
    [self initSubviews];
    
    return self;
}
- (instancetype)initWithFrame:(CGRect)frame isFirst: (BOOL)bIsFirst isLast: (BOOL)bIsLast {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    self.m_isFirst = bIsFirst;
    self.m_isLast = bIsLast;
    
    [self initSubviews];
    
    return self;

}
- (instancetype)initWithFrame:(CGRect)frame
                      isFirst: (BOOL)bIsFirst
                       isLast: (BOOL)bIsLast
                      notEdit: (BOOL)notEdit {
    
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    self.m_isFirst = bIsFirst;
    self.m_isLast = bIsLast;
    self.m_notEdit = notEdit;
    [self initSubviews];
    
    return self;
}
- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat fH = 35;
    CGFloat fW = self.width - 2 * LEFT_MARGIN;
    
    _m_changeBtn.frame = (CGRect){
        .origin.x = self.width - LEFT_MARGIN - fH,
        .origin.y = 0,
        .size.width = fH,
        .size.height = fH
    };
    
    _m_titleLable.frame = (CGRect){
        .origin.x = LEFT_MARGIN,
        .origin.y = 0,
        .size.width = fW - _m_changeBtn.width,
        .size.height = fH
    };
    
    if (_m_notEdit) {
        _m_nextBtn.frame = (CGRect){
            .origin.x = _m_titleLable.left,
            .origin.y = self.height - 65,
            .size.width = fW ,
            .size.height = 42
        };

    } else {
        if (_m_isFirst || _m_isLast) {
            _m_nextBtn.frame = (CGRect){
                .origin.x = _m_titleLable.left,
                .origin.y = self.height - 65,
                .size.width = fW ,
                .size.height = 42
            };
        } else {
            _m_beforeBtn.frame = (CGRect){
                .origin.x = _m_titleLable.left,
                .origin.y = self.height - 65,
                .size.width = (fW - 50 ) * 0.5,
                .size.height = 42
            };
            
            _m_nextBtn.frame = (CGRect){
                .origin.x = _m_beforeBtn.right + 50,
                .origin.y = _m_beforeBtn.y,
                .size.width = _m_beforeBtn.width,
                .size.height = _m_beforeBtn.height
            };
            
        }

    
    }
    
    _m_attachBGView.frame = (CGRect){
        .origin.x = _m_titleLable.left,
        .origin.y = _m_titleLable.bottom,
        .size.width = fW,
        .size.height = _m_nextBtn.top - 13 - _m_titleLable.bottom
    };
    
    CGFloat fGap = 5;
    _m_attachInputView.frame = (CGRect){
        .origin.x = fGap,
        .origin.y = 0,
        .size.width = _m_attachBGView.width - 2 * fGap,
        .size.height = 30
    };
    
    CGFloat fDy = _m_attachInputView.bottom;
    
    if (_m_photoAttachView) {
        _m_photoAttachView.frame = (CGRect){
            .origin.x = fGap,
            .origin.y = fDy,
            .size.width = _m_attachInputView.width,
            .size.height = HELPER_ATTACH_HEIGHT
        };
        
        fDy = _m_photoAttachView.bottom;
    }
    
    if (_m_taskAttachView) {
        _m_taskAttachView.frame = (CGRect){
            .origin.x = fGap,
            .origin.y = fDy,
            .size.width = _m_attachInputView.width,
            .size.height = HELPER_ATTACH_HEIGHT
        };
        
        fDy = _m_taskAttachView.bottom;
    }
    
    if (_m_voiceAttachView) {
        _m_voiceAttachView.frame = (CGRect){
            .origin.x = fGap,
            .origin.y = fDy,
            .size.width = _m_attachInputView.width,
            .size.height = HELPER_ATTACH_HEIGHT
        };
    }
}

#pragma mark - Private Method
- (void)initSubviews {
    
    self.backgroundColor = [UIColor whiteColor];
    
    ICRQuestionManager *mgr = [ICRQuestionManager sharedManager];
    
    self.m_titleLable = [[IBTUILabel alloc] init];
    _m_titleLable.font = [UIFont systemFontOfSize:14];
    _m_titleLable.textColor = ICR_TINTCOLOR;
    _m_titleLable.text = @"附加信息:";
    
    [self addSubview:_m_titleLable];
    
    self.m_changeBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [_m_changeBtn setImage:[UIImage imageNamed:@"AttachHide"] forState:UIControlStateNormal];
    [_m_changeBtn setImage:[UIImage imageNamed:@"AttachDisplay"] forState:UIControlStateSelected];
    [_m_changeBtn addTarget:self
                     action:@selector(onChangeBtnTapped:)
           forControlEvents:UIControlEventTouchUpInside];
    _m_changeBtn.selected = mgr.m_bIsHelpViewAttachHide;
    
    [self addSubview:_m_changeBtn];
    
    self.m_attachBGView = [[LBorderView alloc] init];
    _m_attachBGView.cornerRadius = IBT_DEFAULT_CORNER_RADIUS;
    _m_attachBGView.borderType = BorderTypeDashed;
    _m_attachBGView.borderWidth = .5f;
    _m_attachBGView.borderColor = [UIColor lightGrayColor];
    _m_attachBGView.dashPattern = 4;
    _m_attachBGView.spacePattern = 2;
    [self addSubview:_m_attachBGView];
    
    // attachViews
    UITextField *txtF = nil;
    self.m_attachInputView =
    [[self class] TextFWithLeftLabel:@"备注:" textF:&txtF];
    
    self.m_inputTxtF = txtF;
    
    [_m_attachBGView addSubview:_m_attachInputView];
    
    if (!m_bIsResult) {
        self.m_photoAttachView = [[ICRAttachmentView alloc] initWithType:kAttViewImage];
        _m_photoAttachView.m_uiMaxAttCount = 1;
        
        [_m_attachBGView addSubview:_m_photoAttachView];
        
        
        
        self.m_voiceAttachView = [[ICRAttachmentView alloc] initWithType:kAttViewVoice];
        _m_voiceAttachView.m_uiMaxAttCount = 1;
        
      //  [_m_attachBGView addSubview:_m_voiceAttachView];
    }
    
    self.m_taskAttachView = [[ICRAttachmentView alloc] initWithType:kAttViewTask];
    _m_taskAttachView.m_uiMaxAttCount = 1;
    
   // [_m_attachBGView addSubview:_m_taskAttachView];
    
    if (_m_notEdit) {
        self.m_nextBtn = [IBTCustomButtom buttonWithTitle:@"返回" color:GTO_BLUE_DEEP_COLOR target:nil action:nil];
        [self addSubview:_m_nextBtn];
    } else {
        if (_m_isFirst && !_m_isLast) {
            self.m_nextBtn = [IBTCustomButtom buttonWithTitle:@"下一项" color:GTO_RED_COLOR target:nil action:nil];
            [self addSubview:_m_nextBtn];
        } else if (_m_isLast) {
            self.m_nextBtn = [IBTCustomButtom buttonWithTitle:@"返回" color:GTO_BLUE_DEEP_COLOR target:nil action:nil];
            [self addSubview:_m_nextBtn];
        } else {
            self.m_nextBtn = [IBTCustomButtom buttonWithTitle:@"下一项" color:GTO_RED_COLOR target:nil action:nil];
            [self addSubview:_m_nextBtn];
            
            self.m_beforeBtn = [IBTCustomButtom buttonWithTitle:@"上一项" color:GTO_BLUE_DEEP_COLOR target:nil action:nil];
            [self addSubview:_m_beforeBtn];
        }
    }
    
    [self updateViewRect:_m_changeBtn.selected];
    
}

- (void)updateViewRect:(BOOL)bHide {
    
    //CGFloat fH = bHide ? HELPER_VIEW_MIN_HEIGHT : (m_bIsResult ? HELPER_VIEW_R_MAX_HEIGHT : HELPER_VIEW_MAX_HEIGHT) ;
    CGFloat fH = bHide ? HELPER_VIEW_MIN_HEIGHT : (m_bIsResult ? HELPER_VIEW_R_MAX_HEIGHT : HELPER_VIEW_R_MAX_HEIGHT) ;
    self.m_photoAttachView.hidden = bHide;
    self.m_taskAttachView.hidden = bHide;
    self.m_voiceAttachView.hidden = bHide;
    
    if (self.height == fH) {
        return;
    }
    else {
        self.frame = (CGRect){
            .origin.x = 0,
            .origin.y = self.bottom - fH,
            .size.width = self.width,
            .size.height = fH
        };
    }
    
}

#pragma mark - Actions
- (void)onChangeBtnTapped:(id)sender {
    [_m_inputTxtF resignFirstResponder];
    
    _m_changeBtn.selected = ! _m_changeBtn.selected;
    
    if (!m_bIsResult) {
        ICRQuestionManager *mgr = [ICRQuestionManager sharedManager];
        mgr.m_bIsHelpViewAttachHide = _m_changeBtn.selected;
    }
    
    [self updateViewRect:_m_changeBtn.selected];
}

@end
