//
//  ICRQStarViewController.m
//  Cruiser
//
//  Created by Xummer on 6/7/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRQStarViewController.h"
#import "ASStarRatingView.h"
#import "ICRQuestionManager.h"

#define kLeftPadding 20.0f
#define kStarHeight  60.0f
#define kStarWidth   (320.0f * kStarHeight / 59.0f)

@interface ICRQStarViewController ()
@property (strong, nonatomic) ASStarRatingView *m_starRatingView;
@end

@implementation ICRQStarViewController

#pragma mark - Life Cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    _m_starRatingView.rating = self.m_answer.score;
    _m_starRatingView.maxRating = (int)self.m_question.star;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method
- (void)initScrollViewWithRect:(CGRect)rect {
    
    [super initScrollViewWithRect:rect];
    self.m_starRatingView = [[ASStarRatingView alloc] initWithFrame:CGRectMake((self.m_contentScrollView.width - kStarWidth) * 0.5, 20, kStarWidth, kStarHeight )];
    _m_starRatingView.canEdit = YES;
    _m_starRatingView.maxRating = 5;
    _m_starRatingView.rating = 0;
    [self.m_contentScrollView addSubview:_m_starRatingView];
    if (self.d_notEdit) {
        self.m_starRatingView.userInteractionEnabled = NO;
    }
}

#pragma mark - Actions
- (void)onNextBtnAction:(__unused id)sender {
    
    if (self.d_notEdit) {
        [super disMissSelf];
        return;
    }
    
    self.m_answer.score = _m_starRatingView.rating;
    
    self.m_answer.bIsAnswered = YES;
    self.m_answer.remark = self.m_helperView.m_inputTxtF.text;
    ICRQuestionManager *mgr = [ICRQuestionManager sharedManager];
    UIViewController *qVC = [mgr questionViewControlAtIndex:self.m_uiIndex + 1];
    if (qVC) {
        [self PushViewController:qVC animated:YES];
    }
    else {
        [super disMissSelf];
//        [self openResultView];
    }
    [self.m_answer saveToDBWithHandleData:NULL complete:NULL fail:NULL];
}

@end
