//
//  ICRQAViewController.m
//  Cruiser
//
//  Created by Xummer on 6/7/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRQAViewController.h"
#import "ICRQuestionManager.h"

@interface ICRQAViewController ()

@property (strong, nonatomic) UILabel *m_questionLabel;
@property (strong, nonatomic) UITextView *m_answerTextView;
@end

@implementation ICRQAViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
//    self.m_helperView.m_inputTxtF.text = self.m_answer.content;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)initScrollViewWithRect:(CGRect)rect {
    [super initScrollViewWithRect:rect];
    
    self.m_questionLabel = [[IBTUILabel alloc] init];
    _m_questionLabel.numberOfLines = 0;
    _m_questionLabel.font = [UIFont systemFontOfSize:17];
    _m_questionLabel.textColor = [UIColor grayColor];
//    _m_questionLabel.text = @"请将内容填写在【备注】框中";
    
    CGFloat fMargin = 12.0f;
    CGSize size = CGSizeMake(self.view.width - 2 * fMargin,CGFLOAT_MAX);
    size = [_m_questionLabel widthLimitedSizeThatFits:size];
    
    _m_questionLabel.frame = (CGRect){
        .origin.x = fMargin,
        .origin.y = 0,
        .size = size
    };
    
    [self.m_contentScrollView addSubview:_m_questionLabel];
    
    
    
    //answerTextView
    self.m_answerTextView = [[UITextView alloc] init];
    _m_answerTextView.font = [UIFont systemFontOfSize:17];
    _m_answerTextView.textColor = [UIColor grayColor];
    //    _m_questionLabel.text = @"请将内容填写在【备注】框中";
    _m_answerTextView.text = self.m_answer.content;
    if (self.d_notEdit) {
        _m_answerTextView.editable = NO;
    }
    size = CGSizeMake(self.view.width - 2 * fMargin,100);
    //    size = CGSizeMake(self.view.width - 2 * fMargin,CGFLOAT_MAX);
    //    size = [_m_answerTextView widthLimitedSizeThatFits:size];
    
    _m_answerTextView.frame = (CGRect){
        .origin.x = fMargin,
        .origin.y = _m_questionLabel.bottom + 20,
        .size = size
    };
    
    [self.m_contentScrollView addSubview:_m_answerTextView];
}

#pragma mark - UITextFieldDelegate

#pragma mark - Actions
- (void)onNextBtnAction:(__unused id)sender {
    if (self.d_notEdit) {
        [super disMissSelf];
        return;
    }
    
    if (self.m_answerTextView.text.length <= 0) {
        self.m_answer.bIsAnswered = NO;
        return;
    }
    
    
     self.m_answer.content = self.m_answerTextView.text;
    self.m_answer.bIsAnswered = YES;
    self.m_answer.remark = self.m_helperView.m_inputTxtF.text;
    ICRQuestionManager *mgr = [ICRQuestionManager sharedManager];
    UIViewController *qVC = [mgr questionViewControlAtIndex:self.m_uiIndex + 1];
    if (qVC) {
        [self PushViewController:qVC animated:YES];
    }
    else {
        [super disMissSelf];
//        [self openResultView];
    }
    [self.m_answer saveToDBWithHandleData:NULL complete:NULL fail:NULL];
}


@end
