//
//  ICRTask.h
//  Cruiser
//
//  Created by Xummer on 4/10/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTModel.h"
#import "ICRLocalDataCommon.h"

typedef NS_ENUM(NSUInteger, ICRTaskStatus) {
    kICRTaskStatusNew = 0,
    kICRTaskStatusUnalloted = 1,
    kICRTaskStatusUnknow = 2,
    kICRTaskStatusAlloted = 3,      // 已分配
    kICRTaskStatusProcessed = 4,
    kICRTaskStatusCanceled = 5,
};

typedef NS_ENUM(NSUInteger, ICRTaskLocalState) {
    kICRTaskLocalCreated,
    kICRTaskLocalAlloted,
    kICRTaskLocalFinished,
};

static NSString * const TaskState[] = {
    [ kICRTaskLocalCreated ]        = @"initial",
    [ kICRTaskLocalFinished ]       = @"finished",
};

@class ICRPostTask;
@interface ICRTask : IBTModel
@property (copy, nonatomic)   NSString *uuid ;
@property (assign, nonatomic) long version;
@property (copy, nonatomic)   NSDictionary *createInfo;
@property (copy, nonatomic)   NSDictionary *lastModifyInfo;
@property (copy, nonatomic)   NSString *billNumber;
@property (copy, nonatomic)   NSString *title;
@property (copy, nonatomic)   NSString *content;
@property (copy, nonatomic)   NSString *orgUuid;
@property (copy, nonatomic)   NSString *storeCode;
@property (copy, nonatomic)   NSString *requireDate;
@property (copy, nonatomic)   NSString *state;
@property (copy, nonatomic)   NSString *processor;
@property (copy, nonatomic)   NSString *processResult;
@property (copy, nonatomic)   NSString *processDate;
@property (copy, nonatomic)   NSString *enterprise;
@property (assign, nonatomic)   NSInteger isNotUploaded;



+ (ICRTask *)taskFromPostTask:(ICRPostTask *)postTask;


@end
