//
//  GTORepairNewViewController.m
//  total
//
//  Created by freecui on 15/10/31.
//  Copyright © 2015年 free. All rights reserved.
//

#import "GTOLicenceNewViewController.h"
#import "RETableViewManager.h"
#import "RETableViewOptionsController.h"

#import "GXFBottomView.h"
#import "GTOPioneeringTemplateViewController.h"
#import "GTOPatrolTemplate.h"
#import "GTOAlertInfoLicenceViewController.h"
#import "GTOLicence.h"
#import "GTORepair.h"
#import "GTOQuestion.h"
#import "GTOAnswer.h"
#import "GTOQuestionManager.h"
#import "GTODisplayResult.h"
#import "GTOLiceneResultViewController.h"
#import "GTOCollectionViewController.h"
#import "ICRPostAttachment.h"
@interface GTOLicenceNewViewController ()
<RETableViewManagerDelegate,GXFBottomViewDelegate,
GTOAlertInfoLicenceViewControllerDelegate>
//IBTDatePickerDelegate>
typedef NS_ENUM(NSUInteger, bottomTag) {
    kbottomDelBtnsTag = 0,
    kbottomBackBtnsTag
};
#define BOTTOM_TEXT_DELETE  @"删除"
#define BOTTOM_TEXT_BACK  @"返回"
@property (nonatomic, strong) UITableView *c_tableView;
@property (strong, readwrite, nonatomic) RETableViewManager *manager;
@property (strong, readwrite, nonatomic) RETextItem *repairBillNumberItem;
@property (strong, readwrite, nonatomic) RETextItem *applicantItem;
@property (strong, readwrite, nonatomic) RERadioItem *valideTimeItem;
@property (strong, readwrite, nonatomic) RERadioItem *riskGradeItem;
@property (strong, readwrite, nonatomic) RERadioItem *licenceTypeItem;


@property (nonatomic, strong) GTOPatrolTemplate *d_patrolTemplate;
@property (nonatomic, assign) BOOL isStartlicence;//
@property (nonatomic, assign) BOOL d_isClosed; //点击弹框的“关闭”按钮
@property (nonatomic, assign) BOOL d_isNext;// 非弹框上的“下一步”
@property (nonatomic, strong) GTOLicence *d_licence;
@property (nonatomic, strong) GTOAlertInfoLicenceViewController *alertInfoVC;
@property (nonatomic, strong) NSArray *d_arrCategorys; //问题按区域分
@property (nonatomic, strong) GXFBottomView *bottomV;
@end

@implementation GTOLicenceNewViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"新增许可证";
    [self p_initData];
    [self p_initWithSubViews];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self fetchLocalNoSubmittedLicence];
}
- (void)fetchLocalNoSubmittedLicence {
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = [NSString stringWithFormat:@"SELECT *  FROM %@ WHERE %@=? AND %@ = ?", [GTOLicence TableName], @"state",@"repairUuid"];
        NSLog(@"%@",sql);
        
        return [db executeQuery:sql,GTO_PIONEERING_STATE_LOCAL,_d_repair.uuid];
    };
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (!fetchedObjects) {
            return ;
        }
        if (fetchedObjects) {
            [self p_initData];
            self.d_licence = fetchedObjects[0];
            //tableview
            _valideTimeItem.value = [NSString stringWithFormat:@"%ld",_d_licence.validHours];
            _riskGradeItem.value = _d_licence.riskGrade;
            _licenceTypeItem.value = _d_licence.licenceType;
            
            [_valideTimeItem reloadRowWithAnimation:UITableViewRowAnimationNone];
            [_riskGradeItem reloadRowWithAnimation:UITableViewRowAnimationNone];
            [_licenceTypeItem reloadRowWithAnimation:UITableViewRowAnimationNone];
            _c_tableView.userInteractionEnabled = NO;
            
            if (self.bottomV.tag == kbottomBackBtnsTag) {
                self.bottomV.tag = kbottomDelBtnsTag;
                [self.bottomV.f_leftBtn setTitle:BOTTOM_TEXT_DELETE forState:UIControlStateNormal];
            }
            
        }
        [strongSelf p_addAlerInfoLicenceView];
    };
    
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:[GTOLicence class]
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];

}
- (void)p_initData {
    if (!_d_licence) {
        self.d_licence = [[GTOLicence alloc]init];
    }
}
- (void)p_initWithSubViews {

    self.c_tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, -44,ScreenSize.width, 44 * 6) style:(UITableViewStylePlain)];
    [self.view addSubview:self.c_tableView];

    self.manager = [[RETableViewManager alloc] initWithTableView:self.c_tableView delegate:self];
    __typeof (&*self) __weak weakSelf = self;
    
    RETableViewSection *section = [RETableViewSection sectionWithHeaderTitle:@"Basic controls"];
    [self.manager addSection:section];
    
    self.repairBillNumberItem = [RETextItem itemWithTitle:@"报修单号：" value:_d_repair.billnumber placeholder:@"请输入报修单号"];
    
    self.applicantItem = [RETextItem itemWithTitle:@"申请人：" value:[[ICRUserUtil sharedInstance] f_user_name] placeholder:@"请输入申请人姓名"];
    self.licenceTypeItem = [RERadioItem itemWithTitle:@"许可证类型：" value:nil selectionHandler:^(RERadioItem *item) {
         GTOPioneeringTemplateViewController *VC = [[GTOPioneeringTemplateViewController alloc]init];
        VC.purpose = @"licence";
                // if (VC.choseBaseInfo) {
                VC.choseBaseInfo = ^(NSArray *templateNames) {
                    GTOPatrolTemplate *patroTemplate = templateNames[0];
                   self.licenceTypeItem.value = patroTemplate.name;
                    self.d_patrolTemplate = patroTemplate;
                    [item reloadRowWithAnimation:UITableViewRowAnimationNone];
                };
                [self PushViewController:VC animated:YES];

    }];
    
    self.valideTimeItem =   [RERadioItem itemWithTitle:@"有效时间(h)：" value:nil selectionHandler:^(RERadioItem *item) {

        NSArray *arrRiskGrades = @[@"8",@"12",@"24",@"48",@"72"];
        RETableViewOptionsController *optionsController = [[RETableViewOptionsController alloc] initWithItem:item options:arrRiskGrades multipleChoice:NO completionHandler:^(RETableViewItem *selectedItem){
            [weakSelf.navigationController popViewControllerAnimated:YES];
//            if (!self.d_licence) {
//                self.d_licence.riskGrade = item.value;
//            }
            [item reloadRowWithAnimation:UITableViewRowAnimationNone];
             }];
        optionsController.delegate = weakSelf;
        optionsController.style = section.style;
        if (weakSelf.c_tableView.backgroundView == nil) {
            optionsController.tableView.backgroundColor = weakSelf.c_tableView.backgroundColor;
            optionsController.tableView.backgroundView = nil;
        }
        
        // Push the options controller
        //
        [weakSelf.navigationController pushViewController:optionsController animated:YES];

//                    GTOCollectionViewController *dVC = [[GTOCollectionViewController alloc] init];
//        dVC.blockValideTime = ^(NSUInteger validTime){
//            self.valideTimeItem.value = [NSString  stringWithFormat:@"%ld",validTime];
//            [item reloadRowWithAnimation:UITableViewRowAnimationNone];
//           
//        };
//        [self PushViewController:dVC animated:YES];
    }];

    self.riskGradeItem = [RERadioItem itemWithTitle:@"危险等级：" value:nil selectionHandler:^(RERadioItem *item) {
        [item deselectRowAnimated:YES];
        NSArray *arrRiskGrades = @[@"高",@"中"];
        //
        RETableViewOptionsController *optionsController = [[RETableViewOptionsController alloc] initWithItem:item options:arrRiskGrades multipleChoice:NO completionHandler:^(RETableViewItem *selectedItem){
            [weakSelf.navigationController popViewControllerAnimated:YES];
            if (!self.d_licence) {
                self.d_licence.riskGrade = item.value;
            }
            [item reloadRowWithAnimation:UITableViewRowAnimationNone]; // same as [weakSelf.tableView reloadRowsAtIndexPaths:@[item.indexPath] withRowAnimation:UITableViewRowAnimationNone];
        }];
        
        // Adjust styles
        //
        optionsController.delegate = weakSelf;
        optionsController.style = section.style;
        if (weakSelf.c_tableView.backgroundView == nil) {
            optionsController.tableView.backgroundColor = weakSelf.c_tableView.backgroundColor;
            optionsController.tableView.backgroundView = nil;
        }
        
        // Push the options controller
        //
        [weakSelf.navigationController pushViewController:optionsController animated:YES];
    }];
    

    
    
    [section addItem:_repairBillNumberItem];
    [section addItem:_applicantItem];
    [section addItem:_riskGradeItem];
    [section addItem:_licenceTypeItem];
    [section addItem:_valideTimeItem];
    
    CGRect rect = CGRectMake(0, self.c_tableView.bottom +20, self.view.width, BottomViewHeight);
    GXFBottomView *bottomV = [[GXFBottomView alloc]initWithFrame:rect leftButtonColor:GTO_BLUE_DEEP_COLOR rightButtonColor:GTO_RED_COLOR LeftBtnTitle:BOTTOM_TEXT_BACK rightBtnTitle:@"下一步"];
    bottomV.delegate = self;
    bottomV.tag = kbottomBackBtnsTag;
    self.bottomV = bottomV;
    [self.view addSubview:_bottomV];
}


- (void)p_addAlerInfoLicenceView {
    GTOAlertInfoLicenceViewController *alertInfoVC = [[GTOAlertInfoLicenceViewController alloc]initWithLicence:_d_licence ];
    self.alertInfoVC = alertInfoVC;
    
    alertInfoVC.delegate = self;
    
    [[UIApplication sharedApplication].keyWindow addSubview:_alertInfoVC.view];
}

- (void)p_licenceWithatrolTemplate: (GTOPatrolTemplate *)patrolTemple
{
    [self p_initData];
    ICRUserUtil *userU = [ICRUserUtil sharedInstance];
    
    self.d_licence.uuid = [userU mobileID];
    self.d_licence.version = 0;
    self.d_licence.requestDate = [[NSDate date] httpParameterString];
    self.d_licence.state = GTO_LICENCE_STATE_LOCAL;
    self.d_licence.engineer_uuid = userU.f_user_uuid;
    self.d_licence.engineer_name = userU.f_user_name;
    self.d_licence.engineer_code = userU.f_user_code;
    self.d_licence.licenceType = patrolTemple.name;
    self.d_licence.repairUuid = _d_repair.uuid;
    self.d_licence.repairNumber = _d_repair.billnumber;
    self.d_licence.riskGrade = self.riskGradeItem.value;
//    self.d_licence.beginDate
//    self.d_licence.endDate
    self.d_licence.store_uuid = _d_repair.store_uuid;
    self.d_licence.store_name = _d_repair.store_name;
    self.d_licence.store_code = _d_repair.store_code;
    self.d_licence.validHours = [self.valideTimeItem.value integerValue];


    
//    self.d_licence.create_time = patrolTemple.create_time;//
//    self.d_licence.create_id = patrolTemple.create_id;
//    self.d_licence.create_operName = patrolTemple.create_operName;
//    self.d_licence.lastModify_time = patrolTemple.lastModify_time;
//    self.d_licence.lastModify_id = patrolTemple.lastModify_id;
//    
//    self.d_licence.purpose = patrolTemple.purpose;
    NSMutableArray *muArrQuestions = [NSMutableArray array];
    for(NSDictionary *dictQuestion in patrolTemple.questions) {
        GTOQuestion *question = [GTOQuestion DBObject];
        [question praseFromJsonDict:dictQuestion];
        question.uuid = [[ICRUserUtil sharedInstance] mobileID];
        question.licenceUuid = _d_licence.uuid;
        [question saveToDBWithHandleData:NULL complete:NULL fail:NULL];
        [muArrQuestions addObject:[question dictForCommit]];
    }
    self.d_licence.questions = muArrQuestions;//patrolTemple.questions;//
    [self p_licenceDisplayResults];
    
}
- (void)p_saveLicence {
    __weak typeof(self)weakSelf = self;
    [_d_licence saveToDBWithHandleData:NULL
                                 complete:^{
                                     __strong __typeof(weakSelf)strongSelf = weakSelf;
                                     [IBTLoadingView hideHUDWithText:nil];
                                     self.isStartlicence = YES;
                                     
                                     GTOAlertInfoLicenceViewController *alertInfoVC = [[GTOAlertInfoLicenceViewController alloc]initWithLicence:_d_licence];
                                     self.alertInfoVC = alertInfoVC;
                                     alertInfoVC.delegate = self;
                                     [[UIApplication sharedApplication].keyWindow addSubview:_alertInfoVC.view];
                                 }
                                     fail:^(NSError *error) {
                                         
                                         [IBTLoadingView hideHUDWithText:error.localizedDescription];
                                     }];
    
}
- (void)p_licenceDisplayResults {
    //问题的分类
    if (!_d_arrCategorys) {
        NSUInteger uiQuestionsCount = [_d_licence.questions count];
        
        NSArray *arrQuestIDs = [_d_licence.questions valueForKeyPath:@"uuid"];
        
        
        ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
            NSString * sql = [NSString stringWithFormat:@"SELECT DISTINCT category  FROM %@ WHERE %@ IN %@  ORDER BY %@ ASC", [GTOQuestion TableName], @"uuid", [IBTModel ValuePlaceholdersWithCount:uiQuestionsCount], @"lineNo"];
            NSLog(@"%@",sql);//lineno没有，因为现在后台没有给问题排序
            
            return [db executeQuery:sql withArgumentsInArray:arrQuestIDs];
        };
        
        __weak typeof(self)weakSelf = self;
        ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
            __strong __typeof(weakSelf)strongSelf = weakSelf;
            NSMutableArray *muArr = [NSMutableArray array];
            for(GTOQuestion * question in fetchedObjects){
                [muArr addObject:question.category];
            }
            strongSelf.d_arrCategorys = [NSArray arrayWithArray:muArr];
            
        };
        
        ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
        [dbCtrl runFetchForClass:[GTOQuestion class]
                      fetchBlock:fetchBlk
               fetchResultsBlock:fetchResultsBlk];
    }
    
    
    //答案  （新建任务答案肯定是没有的，所以这个可以不写）
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE %@ = ?", [GTOAnswer TableName], @"licenceUuid"];
        NSLog(@"%@",sql);//lineno没有，因为现在后台没有给问题排序
        
        return [db executeQuery:sql,_d_licence.uuid];
    };
    
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        NSMutableArray *muArrDisplayRs = [NSMutableArray array];
        
        for( NSString *category in   _d_arrCategorys){
            
            //答案
            GTODisplayResult *displayR = [[GTODisplayResult alloc]init];
            NSMutableArray *muArrAnswers = [NSMutableArray array];
            
            for(GTOAnswer *answer in fetchedObjects){
                if ([answer.category isEqualToString:category])
                    //[muArrAnswers addObject:answer];
                    [muArrAnswers addObject:[answer dictForCommit]];
                
            }
            
            //问题
            NSMutableArray *muArrQuestions = [NSMutableArray array];
            for(NSDictionary *dict in  _d_licence.questions){
                if ([dict[@"category"] isEqualToString:category]) {
                    GTOQuestion *question = [GTOQuestion DBObject];
                    [question praseFromJsonDict:dict];
                    //  question.uuid = [[ICRUserUtil sharedInstance] mobileID];//给所有问题分配唯一标识
                    [muArrQuestions addObject:[question dictForCommit]];
                }
                
            }
            
            displayR.arrAnswers = muArrAnswers;
            displayR.category = category;
            displayR.isDisplay = NO;
            
            displayR.arrQuestions = muArrQuestions;
            
            //            displayR.answerNumber = muArrAnswers.count;
            //            displayR.questionNumber = muArrQuestions.count;
            [muArrDisplayRs addObject:[displayR dictForCommit]];
            
            
        }
        // strongSelf.d_arrDisplayResults = muArrDisplayRs;
        strongSelf.d_licence.arrCategorys = _d_arrCategorys;
        strongSelf.d_licence.arrDisplayResults = muArrDisplayRs;
        [strongSelf p_saveLicence];
        
        [_c_tableView reloadData];
        
        
    };
    
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:[GTOAnswer class]
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];
    
    
    
}
#pragma  GXFBottomViewDelegate
- (void)bottomView:(GXFBottomView *)bottomView leftButtonClicked:(UIButton *)leftBtn {
    if(bottomView.tag == kbottomBackBtnsTag){
        [self PopViewControllerAnimated:YES];
        return;
    }
    if (bottomView.tag == kbottomDelBtnsTag) {
        ICRDataBaseController *dataBaseC = [ICRDataBaseController sharedController];
        [dataBaseC.m_dbQueue inDatabase:^(FMDatabase *db) {
            NSString *strSql = [NSString stringWithFormat:@"DELETE FROM %@ WHERE %@=?",[GTOLicence TableName],@"uuid" ];
            BOOL del = [db executeUpdate:strSql,_d_licence.uuid];
            if (!del) {
                [IBTLoadingView showTextOnly:@"删除失败"];
                return ;
            }
            //tableview
            _valideTimeItem.value = nil;
            _riskGradeItem.value = nil;
            _licenceTypeItem.value = nil;
            _d_arrCategorys = nil;
            _d_licence = nil;
            
            [_valideTimeItem reloadRowWithAnimation:UITableViewRowAnimationNone];
            [_riskGradeItem reloadRowWithAnimation:UITableViewRowAnimationNone];
            [_licenceTypeItem reloadRowWithAnimation:UITableViewRowAnimationNone];
            _c_tableView.userInteractionEnabled = YES;

            self.bottomV.tag = kbottomBackBtnsTag;
            [self.bottomV.f_leftBtn setTitle:BOTTOM_TEXT_BACK forState:UIControlStateNormal];

        }];
        [self localDelete];
    }

    
}
//本地删除
- (void)localDelete {
    ICRDataBaseController *dataBaseC = [ICRDataBaseController sharedController];
    //删除本地答案
    [dataBaseC.m_dbQueue inDatabase:^(FMDatabase *db) {
        NSString *strSql = [NSString stringWithFormat:@"DELETE FROM %@ WHERE %@=?",[GTOAnswer TableName],@"licenceUuid" ];
        [db executeUpdate:strSql,_d_licence.uuid];
    }];
    //删除本地问题
    [dataBaseC.m_dbQueue inDatabase:^(FMDatabase *db) {
        NSString *strSql = [NSString stringWithFormat:@"DELETE FROM %@ WHERE %@=?",[GTOQuestion TableName],@"licenceUuid" ];
        [db executeUpdate:strSql,_d_licence.uuid];
    }];
    //删除本地图片
    [dataBaseC.m_dbQueue inDatabase:^(FMDatabase *db) {
        NSString *strSql = [NSString stringWithFormat:@"DELETE FROM %@ WHERE %@=?",[ICRPostAttachment TableName],@"licenceUuid" ];
        [db executeUpdate:strSql,_d_licence.uuid];
    }];
    
}
- (void)bottomView:(GXFBottomView *)bottomView RightButtonClicked:(UIButton *)rightBtn {
    if (_riskGradeItem.value.length <= 0) {
        [IBTLoadingView showTextOnly:@"请选择危险等级"];
        return;
    }
    if (_licenceTypeItem.value.length <= 0) {
        [IBTLoadingView showTextOnly:@"请选择许可证类型"];
        return;
    }
    if (_valideTimeItem.value.length <= 0) {
        [IBTLoadingView showTextOnly:@"请选择有效时间"];
        return;
    }
    if (!_d_licence.uuid) {
        [self p_licenceWithatrolTemplate:_d_patrolTemplate];
    } else {
        [self p_addAlerInfoLicenceView];
    }
    _c_tableView.userInteractionEnabled = NO;
    if(self.bottomV.tag == kbottomBackBtnsTag) {
        self.bottomV.tag = kbottomDelBtnsTag;
        [self.bottomV.f_leftBtn setTitle:BOTTOM_TEXT_DELETE forState:UIControlStateNormal];
        
    }
}
#pragma GTOAlertInfoLicenceViewControllerDelegate
- (void)alertInfoLicenceViewController:(GTOAlertInfoLicenceViewController *)alertInfoLicence closeClickedWithBtton:(UIButton *)btn {
    self.d_isClosed = YES;
    [_alertInfoVC.view removeFromSuperview];
}
- (void)alertInfoLicenceViewController:(GTOAlertInfoLicenceViewController *)alertInfoLicence seeResultClickedWithBtton:(UIButton *)btn {

    GTOLiceneResultViewController *resultVC = [[GTOLiceneResultViewController alloc]initWithLicence:_d_licence ];
    resultVC.d_isNew = YES;
    self.d_isClosed = YES;
    [_alertInfoVC.view removeFromSuperview];
    [self PushViewController:resultVC animated:YES];
}
- (void)alertInfoLicenceViewController:(GTOAlertInfoLicenceViewController *)alertInfoLicence nextClickedWithBtton:(UIButton *)btn {
        BOOL isAllFinished = YES;
    for(NSDictionary *dict in _d_licence.arrDisplayResults) {
        GTODisplayResult *displayR = [GTODisplayResult DBObject];
        [displayR praseFromJsonDict:dict];
        if (displayR.arrAnswers.count < displayR.arrQuestions.count) {
            GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
             mgr.d_category = displayR.category;
//            [mgr openQuestionVCFromViewControler:self Licence:_d_licence Pioneering:nil];
            BOOL notEdit = NO;
            if ([_d_licence.state isEqualToString:GTO_LICENCE_STATE_LOCAL ]
                || [_d_licence.state isEqualToString:GTO_LICENCE_STATE_INITIAL]) {
                notEdit = NO;
            } else {
                notEdit = YES;
            }
            [mgr openQuestionVCFromViewControler:self Licence:_d_licence Pioneering:nil IsNotEdit:notEdit ProblemIndex:0];
            

            [self alertInfoLicenceViewController:alertInfoLicence closeClickedWithBtton:nil];
            isAllFinished = NO;
            break;
        }
    }
    
    if (isAllFinished) {
        NSDictionary *dictR = [_d_licence.arrDisplayResults lastObject];
        GTODisplayResult *displayR = [GTODisplayResult DBObject];
        [displayR praseFromJsonDict:dictR];
        GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
        mgr.d_category = displayR.category;
//        [mgr openQuestionVCFromViewControler:self Licence:_d_licence Pioneering:nil];
        BOOL notEdit = NO;
        if ([_d_licence.state isEqualToString:GTO_LICENCE_STATE_LOCAL ]
            || [_d_licence.state isEqualToString:GTO_LICENCE_STATE_INITIAL]) {
            notEdit = NO;
        } else {
            notEdit = YES;
        }
        [mgr openQuestionVCFromViewControler:self Licence:_d_licence Pioneering:nil IsNotEdit:notEdit ProblemIndex:0];
        

        [self alertInfoLicenceViewController:alertInfoLicence closeClickedWithBtton:nil];
    }
}
- (void)alertInfoLicenceViewController:(GTOAlertInfoLicenceViewController *)alertInfoLicence didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    self.d_licence.isChanged = YES;
    [_d_licence saveToDBWithHandleData:NULL complete:NULL fail:NULL];
    GTOQuestionManager *mgr = [GTOQuestionManager sharedManager];
    GTODisplayResult *displayR = [GTODisplayResult DBObject];
    [displayR praseFromJsonDict:_d_licence.arrDisplayResults[indexPath.row]];
    mgr.d_category = displayR.category;//alertInfoPioneering.d_arrCategorys[indexPath.row];
    
    BOOL notEdit = NO;
    if ([_d_licence.state isEqualToString:GTO_LICENCE_STATE_LOCAL ]
         || [_d_licence.state isEqualToString:GTO_LICENCE_STATE_INITIAL]) {
        notEdit = NO;
    } else {
        notEdit = YES;
    }
    [mgr openQuestionVCFromViewControler:self Licence:_d_licence Pioneering:nil IsNotEdit:notEdit ProblemIndex:0];

   
    [self alertInfoLicenceViewController:alertInfoLicence closeClickedWithBtton:nil];
    
}

- (void)viewWillDisappear:(BOOL)animated {

    
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
