//
//  ICRAnnouncementDetailHeadView.m
//  Cruiser
//
//  Created by Lili Wang on 15/4/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#define LABEL_TEXT_COLOR         [UIColor colorWithRed:0.286f green:0.549f blue:0.933f alpha:1.00f]
#define CONTENT_LABEL_TEXT_COLOR [UIColor colorWithRed:0.471f green:0.471f blue:0.478f alpha:1.00f]
#define MYSELF_BACKGROUND_COLOR  [UIColor colorWithRed:0.941f green:0.965f blue:0.996f alpha:1.00f]
#define LIMITED_SIZE             CGSizeMake( self.width/2 , CREAT_BY_LABEL_HEIGHT )

#define TITLE_IMG_TOP_PANDING         (5)
#define TITLT_IMG_HEIGHT              (55)
#define TITLE_LABEL_HEIGHT            (15)
#define TITLE_LABEL_TOP_PANDING       (13)
#define CREAT_BY_LABEL_HEIGHT         (13)
#define CREAT_BY_LABEL_LEFT_PANDING   (20)
#define CREAT_TIME_LABEL_LEFT_PANDING (self.width/2)
#define CREAT_BY_LABEL_INNER          (15)
#define CREAT_BY_VALUE_LABEL_INNER    (5)
#define TEXTVIEW_BOTTOM_PANDING       (20)

#import "ICRAnnouncementDetailHeadView.h"
#import "ICRAnnocementContentView.h"
#import "ICRAnnouncement.h"

@interface ICRAnnouncementDetailHeadView ()

@property (strong, nonatomic) UIImageView *m_titleImageView;

@property (strong, nonatomic) UILabel *m_titleLabel;
@property (strong, nonatomic) UILabel *m_creatByLabel;
@property (strong, nonatomic) UILabel *m_creatByValueLabel;
@property (strong, nonatomic) UILabel *m_creatTimeLabel;
@property (strong, nonatomic) UILabel *m_creatTimeValueLabel;
@property (strong, nonatomic) UILabel *m_announcementContentLabel;

@property (strong, nonatomic) UILabel *m_announcementContentDetail;

@end
@implementation ICRAnnouncementDetailHeadView

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        // code
        [self _init];
    }
    return self;
}

- (void)layoutSubviews {
    
    CGFloat fMaxW = self.width - CREAT_BY_LABEL_LEFT_PANDING;
    
    CGSize size = CGSizeMake( fMaxW , CGFLOAT_MAX );
    size = [_m_titleLabel widthLimitedSizeThatFits:size];
    
    _m_titleImageView.frame = (CGRect){
        .origin.x = CREAT_BY_LABEL_LEFT_PANDING,
        .origin.y = TITLE_IMG_TOP_PANDING,
        .size.width = self.width - CREAT_BY_LABEL_LEFT_PANDING * 2,
        .size.height = size.height + TITLE_LABEL_TOP_PANDING * 2
    };
    
    _m_titleLabel.frame = (CGRect){
        .origin.x = (_m_titleImageView.width - size.width)/2,
        .origin.y = (_m_titleImageView.height - size.height)/2,
        .size = size
    };
    
    size = [_m_creatByLabel widthLimitedSizeThatFits:LIMITED_SIZE];
    _m_creatByLabel.frame = (CGRect){
        .origin.x = _m_titleImageView.left,
        .origin.y = _m_titleImageView.bottom + CREAT_BY_LABEL_INNER,
        .size = size
    };
    
    size = [_m_creatByValueLabel widthLimitedSizeThatFits:LIMITED_SIZE];
    _m_creatByValueLabel.frame = (CGRect){
        .origin.x = _m_creatByLabel.left,
        .origin.y = _m_creatByLabel.bottom + CREAT_BY_VALUE_LABEL_INNER,
        .size = size
    };
    
    size = [_m_creatTimeLabel widthLimitedSizeThatFits:LIMITED_SIZE];
    _m_creatTimeLabel.frame = (CGRect){
        .origin.x = CREAT_TIME_LABEL_LEFT_PANDING,
        .origin.y = _m_creatByLabel.top,
        .size = size
    };
    
    size = [_m_creatTimeValueLabel widthLimitedSizeThatFits:LIMITED_SIZE];
    _m_creatTimeValueLabel.frame = (CGRect){
        .origin.x = _m_creatTimeLabel.left,
        .origin.y = _m_creatByValueLabel.top,
        .size = size
    };
    
    size = [_m_announcementContentLabel widthLimitedSizeThatFits:LIMITED_SIZE];
    _m_announcementContentLabel.frame = (CGRect){
        .origin.x = _m_creatByLabel.left,
        .origin.y = _m_creatByValueLabel.bottom + CREAT_BY_LABEL_INNER,
        .size = size
    };
    
    size = CGSizeMake( fMaxW , CGFLOAT_MAX);
    size = [_m_announcementContentDetail heightLimitedSizeThatFits:size];
    _m_announcementContentDetail.frame = (CGRect){
        .origin.x = _m_announcementContentLabel.left,
        .origin.y = _m_announcementContentLabel.bottom + CREAT_BY_VALUE_LABEL_INNER,
        .size.width = fMaxW,
        .size.height = size.height
    };
    
    self.height = _m_announcementContentDetail.bottom + TEXTVIEW_BOTTOM_PANDING;
}
#pragma mark - Private Method

- (void)_init {
    
    self.backgroundColor = MYSELF_BACKGROUND_COLOR;
    
    self.m_titleImageView = [[UIImageView alloc] init];
    _m_titleImageView.backgroundColor = [UIColor clearColor];
    _m_titleImageView.image = [[UIImage imageNamed:@"AnnounceTitleBG"]
                               stretchableImageWithLeftCapWidth:50 topCapHeight:10];
    [self addSubview:_m_titleImageView];
    
    self.m_titleLabel = [[ICRAnnocementContentView class]
                         creatLabelWithTextColor:[UIColor whiteColor]
                         textFont:[UIFont boldSystemFontOfSize:14]
                         textAlignment:NSTextAlignmentLeft];
    _m_titleLabel.lineBreakMode = NSLineBreakByWordWrapping;
    _m_titleLabel.numberOfLines = 0;
    [_m_titleImageView addSubview:_m_titleLabel];
    
    self.m_creatByLabel = [[ICRAnnocementContentView class]
                           creatLabelWithTextColor:LABEL_TEXT_COLOR
                           textFont:[UIFont systemFontOfSize:12]
                           textAlignment:NSTextAlignmentLeft];
    _m_creatByLabel.text = [IBTCommon localizableString:@"Publisher"];
    [self addSubview:_m_creatByLabel];
    
    self.m_creatByValueLabel = [[ICRAnnocementContentView class]
                                creatLabelWithTextColor:CONTENT_LABEL_TEXT_COLOR
                                textFont:[UIFont systemFontOfSize:14]
                                textAlignment:NSTextAlignmentLeft];
    [self addSubview:_m_creatByValueLabel];
    
    self.m_creatTimeLabel = [[ICRAnnocementContentView class]
                             creatLabelWithTextColor:LABEL_TEXT_COLOR
                             textFont:[UIFont systemFontOfSize:12]
                             textAlignment:NSTextAlignmentLeft];
    _m_creatTimeLabel.text = [IBTCommon localizableString:@"Publish Time"];
    [self addSubview:_m_creatTimeLabel];
    
    self.m_creatTimeValueLabel = [[ICRAnnocementContentView class]
                                  creatLabelWithTextColor:CONTENT_LABEL_TEXT_COLOR
                                  textFont:[UIFont systemFontOfSize:14]
                                  textAlignment:NSTextAlignmentLeft];
    [self addSubview:_m_creatTimeValueLabel];
    
    self.m_announcementContentLabel = [[ICRAnnocementContentView class]
                                       creatLabelWithTextColor:LABEL_TEXT_COLOR
                                       textFont:[UIFont systemFontOfSize:12]
                                       textAlignment:NSTextAlignmentLeft];
    _m_announcementContentLabel.text = [IBTCommon localizableString:@"Content"];
    [self addSubview:_m_announcementContentLabel];
    
    self.m_announcementContentDetail = [[ICRAnnocementContentView class]
                                        creatLabelWithTextColor:CONTENT_LABEL_TEXT_COLOR
                                        textFont:[UIFont systemFontOfSize:12]
                                        textAlignment:NSTextAlignmentLeft];
    _m_announcementContentDetail.numberOfLines = 0;
    
    [self addSubview:_m_announcementContentDetail];
    
}

#pragma mark - Public Method
- (void)updateContentWithData:(ICRAnnouncement *)announcement {
    
    self.m_titleLabel.text = announcement.title ? : @"";
    self.m_creatByValueLabel.text = announcement.create_operName;//[announcement createInfo][@"operator"][@"operName"] ? : @"";
    self.m_creatTimeValueLabel.text =  announcement.create_time;//[announcement createInfo][@"time"] ? :@"";
    self.m_announcementContentDetail.text = announcement.content ? : @"";
    
    [self setNeedsLayout];
}
@end
