//
//  ICRAnnouncement.h
//  Cruiser
//
//  Created by Lili Wang on 15/4/13.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "IBTModel.h"

typedef NS_ENUM(NSUInteger, ICRAnnouncementPriority) {
    kICRAnnouncementPriorityLow = 0,
    kICRAnnouncementPriorityNormal,
    kICRAnnouncementPriorityHigh
};

typedef NS_ENUM(NSUInteger, ICRAnnouncemenState) {
    kICRAnnouncementStateUnsubmited = 0,
    kICRAnnouncementStateSubmited,
    kICRAnnouncementStateCancled
};
typedef NS_ENUM(NSUInteger, ICRAnnouncementReadType) {
    kICRAnnouncementTypeUnread = 0,
    kICRAnnouncementTypeReaded
};

@interface ICRAnnouncement : IBTModel

@property (copy, nonatomic) NSString *uuid;
@property (assign, nonatomic) NSInteger version;
@property (copy, nonatomic) NSString *create_time;
@property (copy, nonatomic) NSString *create_id;
@property (copy, nonatomic) NSString *create_operName;
@property (copy, nonatomic) NSString *lastModify_time;
@property (copy, nonatomic) NSString *lastModify_id;
@property (copy, nonatomic) NSString *lastModify_operName;
@property (copy, nonatomic) NSString *enterprise;
@property (copy, nonatomic) NSString *title;
@property (copy, nonatomic) NSString *content;
@property (copy, nonatomic) NSString *attachmentId;
@property (copy, nonatomic) NSArray *attachmentUrls;
//附件的url 后台暂时没加
@property (assign, nonatomic) ICRAnnouncementPriority priority;
@property (assign, nonatomic) ICRAnnouncemenState state;
@property (assign, nonatomic) ICRAnnouncementReadType readType;
@end
