//
//  ICRAnnouncementViewController.m
//  Cruiser
//
//  Created by Xummer on 4/11/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#define MYANNOUNCEMENTCELL_HEIGHT (75)
#define PAGE_SIZE (10)
#import "ICRAnnouncementViewController.h"
#import "ICRAnnouncementDetailViewController.h"
#import "ICRAnnouncement.h"
#import "ICRAnnocementContentView.h"
#import "IBTRefreshTableView.h"
#import "GTOPaging.h"
#import "MJRefresh.h"
static NSString *MyTableViewCell = @"IBTTableViewCell";

@interface ICRAnnouncementViewController ()
<
UITableViewDataSource,
UITableViewDelegate,
//IBTScrollViewRefreshDelegate,
UITableViewDataSource,UITableViewDelegate
>
{
    BOOL _isRefresh;
    BOOL _isLoadMore;
}
@property (nonatomic,strong)UITableView *m_tableView;
@property (strong, nonatomic) IBTSegmentContainer *m_segContainer;
@property (weak,   nonatomic) IBTSegmentedControl *m_segmentControl;
@property (strong, nonatomic) NSMutableArray *m_arrUnReadData;
@property (strong, nonatomic) NSMutableArray *m_arrReadData;
@property (assign, nonatomic) NSUInteger m_unReadCurrentPage;
@property (assign, nonatomic) NSUInteger m_readedCurrentPage;
//@property (assign, nonatomic) BOOL m_isClickeUnread;
@end

@implementation ICRAnnouncementViewController

#pragma mark - Life Cycle

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.title = [IBTCommon localizableString:@"Announcement"];
    
    [self initSegmentConatinerFromOriginY:0];
    [self initTableView];
    [self createRefresh];
    [self fetchDataMore:NO type:_m_segmentControl.selectedSegmentIndex];

}
- (void)viewWillAppear:(BOOL)animated {
//    if (!_m_isClickeUnread) {
//        return;
//    }
    NSUserDefaults *userDefault = [NSUserDefaults standardUserDefaults];
    NSString *read = [userDefault objectForKey:READ_SUCCESS];
    if (![read isEqualToString:@"true"]) {
        return;
    }
    if (!_m_segmentControl) {
        return;
    }
    if (_m_segmentControl.selectedSegmentIndex == 0) {
        [self fetchDataMore:NO type:_m_segmentControl.selectedSegmentIndex];
    } else {
         [self fetchDataMore:YES type:_m_segmentControl.selectedSegmentIndex];
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method
- (void)initTableView {
    CGFloat dy = CGRectGetMaxY(_m_segContainer.frame);
    CGRect frame = self.view.bounds;
    frame.origin.y = dy;
    frame.size.height -= CGRectGetMinY(frame);
    
    self.m_tableView =
    [[UITableView alloc] initWithFrame:frame style:UITableViewStylePlain];
    [_m_tableView registerClass:[IBTTableViewCell class]
         forCellReuseIdentifier:MyTableViewCell];
    [_m_tableView autoresizingWithStrechFullSize];
    _m_tableView.dataSource = self;
    _m_tableView.delegate = self;
    UIView *view = [[UIView alloc] initWithFrame:CGRectZero];
    _m_tableView.tableFooterView = view;
    
    [self.view addSubview:_m_tableView];
}

- (void)initSegmentConatinerFromOriginY:(CGFloat)y {
    
    if (_m_segContainer) {
        return;
    }
    
    NSArray *arrSegments =
    @[ [IBTCommon localizableString:@"Unread"],
       [IBTCommon localizableString:@"Read"], ];
    self.m_segContainer = [[IBTSegmentContainer alloc] initWithItems:arrSegments];
    self.m_segmentControl = _m_segContainer.segmentControl;
    _m_segmentControl.selectedSegmentIndex = 0;
    _m_segContainer.segmentControl.tintColor = GTO_BLUE_DEEP_COLOR;
    _m_segContainer.frame = (CGRect){
        .origin.x = 0,
        .origin.y = y,
        .size.width = CGRectGetWidth(self.view.bounds),
        .size.height = IBT_SEGMENT_CONTAINER_DEFUALT_HEIGHT
    };
    [self.view addSubview:_m_segContainer];
    
    [_m_segmentControl addTarget:self action:@selector(onSegmentsTapped:)
                forControlEvents:UIControlEventValueChanged];
}

#pragma mark - Action
- (void)onSegmentsTapped:(id)sender {
    UISegmentedControl *segmentedCtrl = sender;
    switch (segmentedCtrl.selectedSegmentIndex) {
        case 0: // 未读
        {
            [self fetchDataMore:NO type:kICRAnnouncementTypeUnread];
        }
            break;
        case 1: // 已读
        {
            [self fetchDataMore:NO type:kICRAnnouncementTypeReaded];
        }
            break;
            
        default:
            break;
    }
}

#pragma mark - UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _m_segmentControl.selectedSegmentIndex == 0 ? _m_arrUnReadData.count : _m_arrReadData.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView
         cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell =
    [tableView dequeueReusableCellWithIdentifier:MyTableViewCell
                                    forIndexPath:indexPath];
    
    [self configureCell:cell forRowAtIndexPath:indexPath];
    
    return cell;
}

- (void)configureCell:(UITableViewCell *)cell
    forRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    
    id obj ;
    if (!_m_segmentControl.selectedSegmentIndex) {
        obj = _m_arrUnReadData[indexPath.row];
    }else {
        obj = _m_arrReadData[indexPath.row];
    }

    
    UIView *contentView = cell.contentView;
    
    ICRAnnocementContentView *aContentView = [contentView viewWithClass:
                                              [ICRAnnocementContentView class]];
    
    if (!aContentView) {
        aContentView = [[ICRAnnocementContentView alloc] initWithFrame:contentView.frame];
        [aContentView autoresizingWithStrechFullSize];
        [contentView addSubview:aContentView];
    }
    
    [aContentView updateContentWithData:obj];
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView
didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    ICRAnnouncement *annocement ;
    if (_m_segmentControl.selectedSegmentIndex == 0) { //未读
        annocement = _m_arrUnReadData[indexPath.row];
       // [self httpReadBoardWithAnnouncement:annocement];
    } else {
        annocement = _m_arrReadData[indexPath.row];
    }
    ICRAnnouncementDetailViewController *dVC = [[ICRAnnouncementDetailViewController alloc]
                                                initWithAnnouncementData:annocement];
    [self PushViewController:dVC animated:YES];

}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return MYANNOUNCEMENTCELL_HEIGHT;
}

//
- (void)httpReadBoardWithAnnouncement: (ICRAnnouncement *)annocement{

    void(^succ)(id) = ^(id data) {
        CLog(@"%@",data);
        if ([data[@"success"] integerValue] == 1) {
           // self.m_isClickeUnread = YES;
            ICRAnnouncementDetailViewController *dVC = [[ICRAnnouncementDetailViewController alloc]
                                                        initWithAnnouncementData:annocement];
            [self PushViewController:dVC animated:YES];
        }
    };
    void(^fail)(id) = ^(id data) {
        CLog(@"%@",data);
    };
    
    //[IBTLoadingView showProgressLabel:@""];
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doReadBoardWithID:annocement.uuid success:succ failure:fail];
}

#pragma mark - Get Data

- (void)fetchDataMore:(BOOL)more type:(ICRAnnouncementReadType)eType {
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [self endRefreshing];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if ([data[@"success"] integerValue] == 1) {
            NSDictionary *dictData = data[@"data"];
            [strongSelf fetchArrDataMore:more type:eType data:dictData];
        } else {
            
        }

    };
    
    void(^fail)(id) = ^(id data) {
        [self endRefreshing];
        [IBTLoadingView showTips:data];
    };
    
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    
    NSUInteger pageNu;
    if (eType > 0) {
        pageNu = _m_readedCurrentPage;
    } else  {
        pageNu = _m_unReadCurrentPage;
    }
    [httpCtrl doGetBoardListWithType:eType
                          pageNumber:pageNu
                            pageSize:20//PAGE_SIZE
                             success:succ
                             failure:fail];
    
}

- (void)fetchArrDataMore: (BOOL)more type:(ICRAnnouncementReadType)eType data: (NSDictionary *)data {
    GTOPaging *paging = [GTOPaging DBObject];
    [paging praseFromJsonDict:data[@"paging"]];
    NSMutableArray *records = [@[]mutableCopy] ;
    for(NSDictionary *dict in data[@"records"]) {
        ICRAnnouncement *announcemet = [ICRAnnouncement DBObject];
        [announcemet praseFromLocalDict:dict];
        announcemet.readType = eType;
        [records addObject:announcemet];
    }
    
    if (!_m_arrUnReadData) {
        self.m_arrUnReadData = [@[]mutableCopy] ;
    }
    if (!_m_arrReadData) {
        self.m_arrReadData = [@[]mutableCopy] ;
    }
    

    if (!more) {
        switch (eType) {
            case kICRAnnouncementTypeUnread: {
                // self.m_unReadCurrentPage = 0;
                    [self.m_arrUnReadData removeAllObjects];
                    [self.m_arrUnReadData addObjectsFromArray:records];
            }
               
                break;
            case kICRAnnouncementTypeReaded: {
               // self.m_readedCurrentPage = 0;
                    [self.m_arrReadData removeAllObjects];
                    [self.m_arrReadData addObjectsFromArray:records];
            }

            default:
                break;
        }
    } else {
        switch (eType) {
            case kICRAnnouncementTypeUnread:
            {
                if (paging.pageCount > _m_unReadCurrentPage) {
                  //  self.m_unReadCurrentPage ++ ;
                    [self.m_arrUnReadData addObjectsFromArray:records];
                } else {
                    [self.m_tableView.footer noticeNoMoreData];
                }

            }
                break;
            case kICRAnnouncementTypeReaded:
            {
                if (paging.pageCount > _m_readedCurrentPage) {
                  // self.m_unReadCurrentPage ++ ;
                    [self.m_arrReadData addObjectsFromArray:records];
                }else {
                    [self.m_tableView.footer noticeNoMoreData];
                }
            }
            default:
                break;
        }

    }
    
    [self.m_tableView reloadData];
}


- (void)createRefresh{
    self.m_tableView.header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        self.m_unReadCurrentPage = 0;
        self.m_readedCurrentPage = 0;
        _isRefresh = YES;
        [self fetchDataMore:NO type:_m_segmentControl.selectedSegmentIndex];
    }];
   // self.tableView.header.lastUpdatedTimeKey = GTO_REPAIR_UPDATEDATE;
    
    self.m_tableView.footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        _isLoadMore = YES;
        self.m_unReadCurrentPage ++ ;
        self.m_readedCurrentPage ++ ;
        [self fetchDataMore:YES type:_m_segmentControl.selectedSegmentIndex];
    } ];
}
#pragma mark - 结束刷新
- (void)endRefreshing{
    _isLoadMore = NO;
    _isRefresh = NO;
    [self.m_tableView.header endRefreshing];
    [self.m_tableView.footer endRefreshing];
}
@end
